/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.http.netty;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.ServiceErrorResponse;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.common.http.netty.NettyChannelContext;
import com.vmware.xenon.common.http.netty.NettyChannelPool;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http2.HttpConversionUtil;
import java.net.ProtocolException;
import java.util.EnumSet;
import java.util.Map;
import java.util.logging.Logger;

public class NettyHttpServerResponseHandler
extends SimpleChannelInboundHandler<HttpObject> {
    private NettyChannelPool pool;
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public NettyHttpServerResponseHandler(NettyChannelPool pool) {
        this.pool = pool;
    }

    public void channelRead0(ChannelHandlerContext ctx, HttpObject msg) {
        if (msg instanceof FullHttpResponse) {
            FullHttpResponse response = (FullHttpResponse)msg;
            Operation request = this.findOperation(ctx, response);
            request.setStatusCode(response.status().code());
            this.parseResponseHeaders(request, (HttpResponse)response);
            this.completeRequest(ctx, request, response.content());
        }
    }

    private Operation findOperation(ChannelHandlerContext ctx, FullHttpResponse response) {
        Operation request;
        if (ctx.channel().hasAttr(NettyChannelContext.HTTP2_KEY)) {
            Integer streamId = response.headers().getInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text());
            if (streamId == null) {
                this.logger.warning("HTTP/2 message has no stream ID: ignoring.");
                return null;
            }
            NettyChannelContext channelContext = (NettyChannelContext)ctx.channel().attr(NettyChannelContext.CHANNEL_CONTEXT_KEY).get();
            if (channelContext == null) {
                this.logger.warning("HTTP/2 channel is missing associated channel context: ignoring response on stream " + streamId);
                return null;
            }
            request = channelContext.getOperationForStream(streamId);
            if (request == null) {
                this.logger.warning("Can't find operation for stream " + streamId);
                return null;
            }
            channelContext.removeOperationForStream(streamId);
        } else {
            request = (Operation)ctx.channel().attr(NettyChannelContext.OPERATION_KEY).get();
            if (request == null) {
                this.logger.warning("Can't find operation for channel");
                return null;
            }
        }
        return request;
    }

    private void parseResponseHeaders(Operation request, HttpResponse nettyResponse) {
        HttpHeaders headers = nettyResponse.headers();
        if (headers.isEmpty()) {
            return;
        }
        request.setKeepAlive(HttpUtil.isKeepAlive((HttpMessage)nettyResponse));
        if (HttpUtil.isContentLengthSet((HttpMessage)nettyResponse)) {
            request.setContentLength(HttpUtil.getContentLength((HttpMessage)nettyResponse));
            headers.remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        }
        String contentType = headers.get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        headers.remove((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        if (contentType != null) {
            request.setContentType(contentType);
        }
        for (Map.Entry h : headers) {
            String key = (String)h.getKey();
            String value = (String)h.getValue();
            request.addResponseHeader(key, value);
        }
    }

    private void completeRequest(ChannelHandlerContext ctx, Operation request, ByteBuf content) {
        this.decodeResponseBody(request, content);
        this.pool.returnOrClose((NettyChannelContext)request.getSocketContext(), !request.isKeepAlive());
    }

    private void decodeResponseBody(Operation request, ByteBuf content) {
        if (!content.isReadable()) {
            if (this.checkResponseForError(request)) {
                return;
            }
            request.setContentLength(0L).complete();
            return;
        }
        request.nestCompletion((o, e) -> {
            if (e != null) {
                request.fail(e);
                return;
            }
            this.completeRequest(request);
        });
        Utils.decodeBody(request, content.nioBuffer());
    }

    private void completeRequest(Operation request) {
        if (this.checkResponseForError(request)) {
            return;
        }
        request.complete();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.logger.warning(Utils.toString(cause));
        Operation request = (Operation)ctx.channel().attr(NettyChannelContext.OPERATION_KEY).get();
        if (request == null) {
            this.logger.info("Channel exception but no HTTP/1.1 request to fail" + cause.getMessage());
            return;
        }
        request.setStatusCode(400);
        request.setBody(ServiceErrorResponse.create(cause, request.getStatusCode(), EnumSet.of(ServiceErrorResponse.ErrorDetail.SHOULD_RETRY)));
        request.fail(cause);
    }

    private boolean checkResponseForError(Operation op) {
        if (op.getStatusCode() < 400) {
            return false;
        }
        String errorMsg = String.format("Service %s returned error %d for %s. id %d", new Object[]{op.getUri(), op.getStatusCode(), op.getAction(), op.getId()});
        if (!op.hasBody()) {
            ServiceErrorResponse rsp = ServiceErrorResponse.create(new ProtocolException(errorMsg), op.getStatusCode());
            op.setBodyNoCloning(rsp);
        } else if ("application/json".equals(op.getContentType())) {
            Object originalBody = op.getBodyRaw();
            ServiceErrorResponse rsp = op.getBody(ServiceErrorResponse.class);
            if (rsp != null) {
                errorMsg = errorMsg + " message " + rsp.message;
            }
            op.setBodyNoCloning(originalBody);
        }
        op.fail(new ProtocolException(errorMsg));
        return true;
    }
}

