/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.ServiceHost;

public class OperationContext {
    private Operation.AuthorizationContext authContext;
    private String contextId;
    private static final ThreadLocal<String> threadContextId = new ThreadLocal();
    private static final ThreadLocal<Operation.AuthorizationContext> threadAuthContext = new ThreadLocal();

    private OperationContext(Operation.AuthorizationContext authContext, String contextId) {
        this.authContext = authContext;
        this.contextId = contextId;
    }

    public static void setContextId(String contextId) {
        threadContextId.set(contextId);
    }

    public static String getContextId() {
        return threadContextId.get();
    }

    static void setAuthorizationContext(Operation.AuthorizationContext ctx) {
        threadAuthContext.set(ctx);
    }

    public static void setAuthorizationContext(ServiceHost host, Operation op) {
        OperationContext.setAuthorizationContext(host.getAuthorizationContext(op));
    }

    public static Operation.AuthorizationContext getAuthorizationContext() {
        return threadAuthContext.get();
    }

    public static OperationContext getOperationContext() {
        return new OperationContext(threadAuthContext.get(), threadContextId.get());
    }

    public static void restoreOperationContext(OperationContext ctx) {
        OperationContext.setAuthorizationContext(ctx.authContext);
        OperationContext.setContextId(ctx.contextId);
    }
}

