/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class LogFormatter
extends Formatter {
    @Override
    public String format(LogRecord record) {
        StringBuilder sb = new StringBuilder();
        sb.append(LogItem.create(record).toString());
        sb.append("\n");
        return sb.toString();
    }

    public static class LogItem {
        public String l;
        public long id;
        public long t;
        public String m;
        public String method;
        public String classOrUri;

        public static LogItem create(LogRecord source) {
            LogItem sr = new LogItem();
            sr.l = source.getLevel().toString();
            sr.t = source.getMillis();
            sr.id = source.getSequenceNumber();
            sr.m = source.getMessage();
            sr.method = source.getSourceMethodName();
            sr.classOrUri = source.getSourceClassName();
            if (sr.classOrUri == null) {
                return sr;
            }
            if (sr.classOrUri.startsWith("http")) {
                int portIndex = sr.classOrUri.lastIndexOf(":");
                sr.classOrUri = sr.classOrUri.substring(portIndex + 1);
            } else {
                int simpleNameIndex = sr.classOrUri.lastIndexOf(".");
                if (simpleNameIndex != -1) {
                    sr.classOrUri = sr.classOrUri.substring(simpleNameIndex + 1);
                }
            }
            return sr;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[").append(this.id).append("]");
            sb.append("[").append(this.l.substring(0, 1)).append("]");
            sb.append("[").append(this.t).append("]");
            sb.append("[").append(this.classOrUri).append("]");
            sb.append("[").append(this.method).append("]");
            if (this.m != null && !this.m.isEmpty()) {
                sb.append("[").append(this.m).append("]");
            }
            return sb.toString();
        }
    }
}

