/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceDocumentDescription;
import com.vmware.xenon.common.StatelessService;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.NodeGroupBroadcastResponse;
import java.net.URI;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

public class NodeSelectorSynchronizationService
extends StatelessService {
    public static final String STAT_NAME_EPOCH_INCREMENT_RETRY_COUNT = "epochIncrementRetryCount";
    private Service parent;
    private boolean isDetailedLoggingEnabled = false;

    public NodeSelectorSynchronizationService(Service parent) {
        super(NodeGroupSynchronizationState.class);
        super.toggleOption(Service.ServiceOption.UTILITY, true);
        this.parent = parent;
    }

    @Override
    public void handleStart(Operation startPost) {
        startPost.complete();
    }

    @Override
    public void handleRequest(Operation post) {
        if (post.getAction() != Service.Action.POST) {
            post.fail(new IllegalArgumentException("Action not supported"));
            return;
        }
        if (!post.hasBody()) {
            post.fail(new IllegalArgumentException("Body is required"));
            return;
        }
        SynchronizePeersRequest body = post.getBody(SynchronizePeersRequest.class);
        if (body.kind == null) {
            post.fail(new IllegalArgumentException("kind is required"));
            return;
        }
        if (body.kind.equals(SynchronizePeersRequest.KIND)) {
            this.handleSynchronizeRequest(post, body);
            return;
        }
        post.fail(new IllegalArgumentException("kind is not supported: " + body.kind));
    }

    private void handleSynchronizeRequest(Operation post, SynchronizePeersRequest body) {
        if (body.state == null) {
            post.fail(new IllegalArgumentException("state is required"));
            return;
        }
        if (body.state.documentSelfLink == null) {
            post.fail(new IllegalArgumentException("state.documentSelfLink is required"));
            return;
        }
        if (body.options == null || body.options.isEmpty()) {
            post.fail(new IllegalArgumentException("options is required"));
            return;
        }
        if (body.factoryLink == null || body.factoryLink.isEmpty()) {
            post.fail(new IllegalArgumentException("factoryLink is required"));
            return;
        }
        URI localQueryUri = UriUtils.buildDocumentQueryUri(this.getHost(), body.state.documentSelfLink, false, true, body.options);
        Operation remoteGet = Operation.createGet(localQueryUri).setReferer(this.getUri()).setCompletion((o, e) -> {
            if (e != null) {
                post.fail(e);
                return;
            }
            NodeGroupBroadcastResponse rsp = o.getBody(NodeGroupBroadcastResponse.class);
            this.handleBroadcastGetCompletion(rsp, post, body);
        });
        this.getHost().broadcastRequest(this.parent.getSelfLink(), body.state.documentSelfLink, true, remoteGet);
    }

    private void handleBroadcastGetCompletion(NodeGroupBroadcastResponse rsp, Operation post, SynchronizePeersRequest request) {
        if (rsp.failures.size() > 0 && rsp.jsonResponses.isEmpty()) {
            post.fail(new IllegalStateException("Failures received: " + Utils.toJsonHtml(rsp)));
            return;
        }
        ServiceDocument bestPeerRsp = null;
        TreeMap<Long, ArrayList<ServiceDocument>> syncRspsPerEpoch = new TreeMap<Long, ArrayList<ServiceDocument>>();
        HashMap<URI, ServiceDocument> peerStates = new HashMap<URI, ServiceDocument>();
        for (Map.Entry<URI, String> e : rsp.jsonResponses.entrySet()) {
            ArrayList<ServiceDocument> statesForEpoch;
            ServiceDocument peerState = (ServiceDocument)Utils.fromJson(e.getValue(), request.state.getClass());
            if (peerState.documentSelfLink == null || !peerState.documentSelfLink.equals(request.state.documentSelfLink)) {
                this.logWarning("Invalid state from peer %s: %s", e.getKey(), e.getValue());
                peerStates.put(e.getKey(), new ServiceDocument());
                continue;
            }
            peerStates.put(e.getKey(), peerState);
            if (peerState.documentEpoch == null) {
                peerState.documentEpoch = 0L;
            }
            if ((statesForEpoch = (ArrayList<ServiceDocument>)syncRspsPerEpoch.get(peerState.documentEpoch)) == null) {
                statesForEpoch = new ArrayList<ServiceDocument>();
                syncRspsPerEpoch.put(peerState.documentEpoch, statesForEpoch);
            }
            statesForEpoch.add(peerState);
        }
        for (URI remotePeerService : rsp.receivers) {
            if (peerStates.containsKey(remotePeerService)) continue;
            this.logFine("No peer response for %s from %s", request.state.documentSelfLink, remotePeerService);
            peerStates.put(remotePeerService, new ServiceDocument());
        }
        if (!syncRspsPerEpoch.isEmpty()) {
            List statesForHighestEpoch = (List)syncRspsPerEpoch.get(syncRspsPerEpoch.lastKey());
            long maxVersion = Long.MIN_VALUE;
            for (ServiceDocument peerState : statesForHighestEpoch) {
                if (peerState.documentVersion <= maxVersion) continue;
                bestPeerRsp = peerState;
                maxVersion = peerState.documentVersion;
            }
        }
        if (bestPeerRsp != null && bestPeerRsp.documentEpoch == null) {
            bestPeerRsp.documentEpoch = 0L;
        }
        if (request.state.documentEpoch == null) {
            request.state.documentEpoch = 0L;
        }
        EnumSet<ServiceDocument.DocumentRelationship> results = EnumSet.noneOf(ServiceDocument.DocumentRelationship.class);
        if (bestPeerRsp == null) {
            results.add(ServiceDocument.DocumentRelationship.PREFERRED);
        } else if (request.state.documentEpoch.compareTo(bestPeerRsp.documentEpoch) > 0) {
            results.add(ServiceDocument.DocumentRelationship.PREFERRED);
        } else if (request.state.documentEpoch.equals(bestPeerRsp.documentEpoch)) {
            results = ServiceDocument.compare(request.state, bestPeerRsp, request.stateDescription, Utils.getTimeComparisonEpsilonMicros());
        }
        if (results.contains((Object)ServiceDocument.DocumentRelationship.IN_CONFLICT)) {
            this.markServiceInConflict(request.state, bestPeerRsp);
        } else if (results.contains((Object)ServiceDocument.DocumentRelationship.PREFERRED)) {
            bestPeerRsp = null;
        }
        if (bestPeerRsp != null && request.isOwner) {
            bestPeerRsp.documentOwner = this.getHost().getId();
        }
        if (bestPeerRsp != null && this.isDetailedLoggingEnabled) {
            this.logFine("Using best peer state for %s (e:%d, v:%d)", bestPeerRsp.documentSelfLink, bestPeerRsp.documentEpoch, bestPeerRsp.documentVersion);
        }
        boolean incrementEpoch = false;
        if (bestPeerRsp == null) {
            bestPeerRsp = request.state;
            if (this.isDetailedLoggingEnabled) {
                this.logFine("Local is best peer state for %s (e:%d, v:%d)", bestPeerRsp.documentSelfLink, bestPeerRsp.documentEpoch, bestPeerRsp.documentVersion);
            }
        }
        if (!request.wasOwner && request.isOwner) {
            incrementEpoch = true;
        }
        this.broadcastBestState(rsp.selectedNodes, peerStates, post, request, bestPeerRsp, incrementEpoch);
    }

    private void broadcastBestState(Map<String, URI> selectedNodes, Map<URI, ServiceDocument> peerStates, Operation post, SynchronizePeersRequest request, ServiceDocument bestPeerRsp, boolean incrementEpoch) {
        try {
            boolean isServiceDeleted;
            post.setBodyNoCloning(null);
            if (peerStates.isEmpty()) {
                this.logFine("(isOwner: %s) No peers available for %s", request.isOwner, bestPeerRsp.documentSelfLink);
                post.complete();
                return;
            }
            ServiceDocument bestState = bestPeerRsp;
            Iterator<Map.Entry<URI, ServiceDocument>> peerStateIt = peerStates.entrySet().iterator();
            TreeMap<String, URI> peersWithService = new TreeMap<String, URI>();
            peersWithService.put(this.getHost().getId(), this.getHost().getPublicUri());
            boolean isMissingFromOwner = false;
            HashMap<URI, String> uriToNodeId = new HashMap<URI, String>();
            for (Map.Entry<String, URI> en : selectedNodes.entrySet()) {
                uriToNodeId.put(UriUtils.buildUri(en.getValue(), ""), en.getKey());
            }
            while (peerStateIt.hasNext()) {
                Map.Entry<URI, ServiceDocument> e2 = peerStateIt.next();
                ServiceDocument peerState = e2.getValue();
                if (peerState.documentSelfLink == null) {
                    if (!request.isOwner) {
                        boolean isPeerNewOwner;
                        URI peerUri = e2.getKey();
                        boolean bl = isPeerNewOwner = peerUri.getHost().equals(request.ownerNodeReference.getHost()) && peerUri.getPort() == request.ownerNodeReference.getPort();
                        if (isPeerNewOwner) {
                            isMissingFromOwner = true;
                            continue;
                        }
                    }
                } else {
                    URI baseUri = UriUtils.buildUri(e2.getKey(), "");
                    String id = (String)uriToNodeId.get(baseUri);
                    if (id == null) {
                        this.logWarning("Failure finding id for peer %s, not synchronizing!", baseUri);
                    } else {
                        peersWithService.put(id, e2.getKey());
                    }
                }
                if (incrementEpoch || !request.isOwner) continue;
                if (this.getHost().getId().equals(peerState.documentOwner) && bestPeerRsp.documentEpoch.equals(peerState.documentEpoch) && bestPeerRsp.documentVersion == peerState.documentVersion) {
                    peerStateIt.remove();
                    if (!this.isDetailedLoggingEnabled) continue;
                    this.logFine("Peer %s has latest epoch, owner and version for %s skipping broadcast", e2.getKey(), peerState.documentSelfLink);
                    continue;
                }
                incrementEpoch = true;
            }
            if (isMissingFromOwner) {
                URI peerThatShouldAssumeOwnership = (URI)peersWithService.firstEntry().getValue();
                if (UriUtils.isHostEqual(this.getHost(), peerThatShouldAssumeOwnership)) {
                    request.isOwner = true;
                    incrementEpoch = true;
                    this.logInfo("Broadcasting %s (epoch %d) to new owner %s\n Others with service:%s", bestPeerRsp.documentSelfLink, bestPeerRsp.documentEpoch + 1L, request.ownerNodeReference, peersWithService);
                }
            }
            if (isServiceDeleted = Service.Action.DELETE.toString().equals(bestPeerRsp.documentUpdateAction)) {
                post.setBodyNoCloning(bestPeerRsp);
            }
            if (!request.isOwner) {
                post.complete();
                return;
            }
            if (peerStates.isEmpty()) {
                post.complete();
                return;
            }
            AtomicInteger remaining = new AtomicInteger(peerStates.size());
            Operation.CompletionHandler c = (o, e) -> {
                int r = remaining.decrementAndGet();
                if (e != null) {
                    this.logWarning("Peer update to %s:%d for %s failed with %s, remaining %d", o.getUri().getHost(), o.getUri().getPort(), bestPeerRsp.documentSelfLink, e.toString(), r);
                }
                if (r != 0) {
                    return;
                }
                post.complete();
            };
            bestPeerRsp.documentOwner = request.ownerNodeId;
            if (incrementEpoch) {
                if (this.isDetailedLoggingEnabled) {
                    this.logFine("Incrementing epoch from %d to %d for %s", bestPeerRsp.documentEpoch, bestPeerRsp.documentEpoch + 1L, bestPeerRsp.documentSelfLink);
                }
                ServiceDocument id = bestPeerRsp;
                id.documentEpoch = id.documentEpoch + 1L;
                ++bestPeerRsp.documentVersion;
                post.setBody(bestPeerRsp);
            }
            ServiceDocument clonedState = Utils.clone(bestPeerRsp);
            for (Map.Entry<URI, ServiceDocument> entry : peerStates.entrySet()) {
                URI peer = entry.getKey();
                URI targetFactoryUri = UriUtils.buildUri(peer, request.factoryLink);
                Operation peerOp = Operation.createPost(targetFactoryUri).setReferer(post.getReferer()).setExpiration(post.getExpirationMicrosUtc()).setCompletion(c);
                peerOp.addPragmaDirective("xn-rpl");
                peerOp.addPragmaDirective("xn-check-version");
                if (entry.getValue().documentSelfLink != null) {
                    if (isMissingFromOwner) {
                        c.handle(null, null);
                        continue;
                    }
                    peerOp.setAction(Service.Action.PUT);
                    peerOp.setUri(UriUtils.buildUri(peer, bestState.documentSelfLink));
                    clonedState.documentSelfLink = bestState.documentSelfLink;
                } else {
                    clonedState.documentSelfLink = bestState.documentSelfLink.replace(request.factoryLink, "");
                }
                if (isServiceDeleted) {
                    peerOp.setAction(Service.Action.DELETE);
                    this.logInfo("broadcasting DELETE for %s", clonedState.documentSelfLink);
                }
                peerOp.setBody(clonedState);
                if (this.isDetailedLoggingEnabled) {
                    this.logFine("(isOwner: %s)(remaining: %d) (last action: %s) Sending %s with best state for %s to %s (e:%d, v:%d)", new Object[]{request.isOwner, remaining.get(), clonedState.documentUpdateAction, peerOp.getAction(), clonedState.documentSelfLink, peerOp.getUri(), clonedState.documentEpoch, clonedState.documentVersion});
                }
                this.sendRequest(peerOp);
            }
        }
        catch (Throwable e3) {
            this.logSevere(e3);
            post.fail(e3);
        }
    }

    private void markServiceInConflict(ServiceDocument state, ServiceDocument bestPeerRsp) {
        this.logWarning("State in conflict. Local: %s, Among peers: %s", Utils.toJsonHtml(state), Utils.toJsonHtml(bestPeerRsp));
    }

    public static class SynchronizePeersRequest {
        public static final String KIND = Utils.buildKind(SynchronizePeersRequest.class);
        public ServiceDocument state;
        public ServiceDocumentDescription stateDescription;
        public EnumSet<Service.ServiceOption> options;
        public String factoryLink;
        public boolean wasOwner;
        public boolean isOwner;
        public URI ownerNodeReference;
        public String ownerNodeId;
        public String kind;

        public static SynchronizePeersRequest create() {
            SynchronizePeersRequest r = new SynchronizePeersRequest();
            r.kind = KIND;
            return r;
        }
    }

    public static class NodeGroupSynchronizationState
    extends ServiceDocument {
        public Set<String> inConflictLinks = new HashSet<String>();
    }
}

