/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.services.common.NodeState;
import java.net.URI;
import java.util.Collection;
import java.util.EnumSet;

public interface NodeSelectorService
extends Service {
    public String getNodeGroup();

    public void selectAndForward(Operation var1, SelectAndForwardRequest var2);

    public static class SelectOwnerResponse {
        public String key;
        public String ownerNodeId;
        public URI ownerNodeReference;
        public boolean isLocalHostOwner;
        public Collection<NodeState> selectedNodes;

        public static URI buildUriToOwner(SelectOwnerResponse rsp, String path, String query) {
            return UriUtils.buildUri(rsp.ownerNodeReference.getScheme(), rsp.ownerNodeReference.getHost(), rsp.ownerNodeReference.getPort(), path, query);
        }

        public static URI buildUriToOwner(SelectOwnerResponse rsp, Operation op) {
            return UriUtils.buildUri(rsp.ownerNodeReference.getScheme(), rsp.ownerNodeReference.getHost(), rsp.ownerNodeReference.getPort(), op.getUri().getPath(), op.getUri().getQuery());
        }
    }

    public static class SelectAndForwardRequest {
        public String key;
        public String targetPath;
        public String targetQuery;
        public transient Operation associatedOp;
        public transient ServiceDocument linkedState;
        public EnumSet<ForwardingOption> options;
        public EnumSet<Service.ServiceOption> serviceOptions;

        public static enum ForwardingOption {
            REPLICATE,
            BROADCAST,
            UNICAST,
            EXCLUDE_ENTRY_NODE;

        }
    }
}

