/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.OperationJoin;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.NodeGroupService;
import com.vmware.xenon.services.common.NodeState;
import java.util.ArrayList;

public class NodeGroupUtils {
    public static void checkConvergence(ServiceHost host, NodeGroupService.NodeGroupState ngs, Operation parentOp) {
        OperationJoin.JoinedCompletionHandler joinedCompletion = (ops, failures) -> {
            if (failures != null) {
                parentOp.fail(new IllegalStateException("At least one peer failed convergence"));
                return;
            }
            for (Operation peerOp : ops.values()) {
                NodeGroupService.CheckConvergenceResponse r = peerOp.getBody(NodeGroupService.CheckConvergenceResponse.class);
                if (r.isConverged) continue;
                String error = String.format("Peer %s is not converged", peerOp.getUri());
                parentOp.fail(new IllegalStateException(error));
                return;
            }
            parentOp.complete();
        };
        ArrayList<Operation> ops2 = new ArrayList<Operation>();
        for (NodeState ns : ngs.nodes.values()) {
            if (NodeState.isUnAvailable(ns)) continue;
            NodeGroupService.CheckConvergenceRequest peerReq = NodeGroupService.CheckConvergenceRequest.create(ngs.membershipUpdateTimeMicros);
            Operation peerOp = Operation.createPost(ns.groupReference).setReferer(parentOp.getReferer()).setExpiration(parentOp.getExpirationMicrosUtc()).setBodyNoCloning(peerReq);
            ops2.add(peerOp);
        }
        if (ops2.isEmpty()) {
            parentOp.fail(new IllegalStateException("no available nodes"));
            return;
        }
        OperationJoin.create(ops2).setCompletion(joinedCompletion).sendWith(host);
    }

    public static boolean isMembershipSettled(ServiceHost host, long maintIntervalMicros, NodeGroupService.NodeGroupState localState) {
        NodeState selfNode = localState.nodes.get(host.getId());
        if (selfNode == null) {
            return false;
        }
        long threshold = localState.membershipUpdateTimeMicros + localState.config.stableGroupMaintenanceIntervalCount * maintIntervalMicros;
        return Utils.getNowMicrosUtc() - threshold >= 0L;
    }

    public static boolean hasSynchronizationQuorum(ServiceHost host, NodeGroupService.NodeGroupState ngs) {
        NodeState selfNode = ngs.nodes.get(host.getId());
        if (selfNode == null) {
            return false;
        }
        int availableNodeCount = 0;
        for (NodeState ns : ngs.nodes.values()) {
            if (!NodeState.isAvailable(ns, selfNode.id, false)) continue;
            ++availableNodeCount;
        }
        return availableNodeCount >= selfNode.synchQuorum;
    }
}

