/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.esotericsoftware.kryo.KryoException;
import com.google.gson.JsonParser;
import com.vmware.xenon.common.FileUtils;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.QueryFilterUtils;
import com.vmware.xenon.common.ReflectionUtils;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceDocumentDescription;
import com.vmware.xenon.common.ServiceDocumentQueryResult;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.ServiceStats;
import com.vmware.xenon.common.StatelessService;
import com.vmware.xenon.common.TaskState;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.LuceneQueryConverter;
import com.vmware.xenon.services.common.LuceneQueryPageService;
import com.vmware.xenon.services.common.QueryFilter;
import com.vmware.xenon.services.common.QueryTask;
import com.vmware.xenon.services.common.UpdateIndexRequest;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.SimpleAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.CheckIndex;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexUpgrader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.KeepOnlyLastCommitDeletionPolicy;
import org.apache.lucene.index.SnapshotDeletionPolicy;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Version;

public class LuceneDocumentIndexService
extends StatelessService {
    public static String SELF_LINK = "/core/document-index";
    public static final String FILE_PATH_LUCENE = "lucene";
    private String indexDirectory;
    private static final int INDEX_SEARCHER_COUNT_THRESHOLD = 100;
    private static final int DEFAULT_INDEX_FILE_COUNT_THRESHOLD_FOR_WRITER_REFRESH = 1000;
    private static int INDEX_FILE_COUNT_THRESHOLD_FOR_WRITER_REFRESH = 1000;
    private static final String LUCENE_FIELD_NAME_BINARY_SERIALIZED_STATE = "binarySerializedState";
    private static final String LUCENE_FIELD_NAME_JSON_SERIALIZED_STATE = "jsonSerializedState";
    public static final String STAT_NAME_ACTIVE_QUERY_FILTERS = "activeQueryFilters";
    public static final String STAT_NAME_COMMIT_COUNT = "commitCount";
    public static final String STAT_NAME_INDEX_LOAD_RETRY_COUNT = "indexLoadRetryCount";
    public static final String STAT_NAME_COMMIT_DURATION_MICROS = "commitDurationMicros";
    public static final String STAT_NAME_QUERY_DURATION_MICROS = "queryDurationMicros";
    public static final String STAT_NAME_QUERY_SINGLE_DURATION_MICROS = "querySingleDurationMicros";
    public static final String STAT_NAME_QUERY_ALL_VERSIONS_DURATION_MICROS = "queryAllVersionsDurationMicros";
    public static final String STAT_NAME_RESULT_PROCESSING_DURATION_MICROS = "resultProcessingDurationMicros";
    public static final String STAT_NAME_INDEXED_FIELD_COUNT = "indexedFieldCount";
    public static final String STAT_NAME_INDEXED_DOCUMENT_COUNT = "indexedDocumentCount";
    public static final String STAT_NAME_FIELD_COUNT_PER_DOCUMENT = "fieldCountPerDocument";
    public static final String STAT_NAME_INDEXING_DURATION_MICROS = "indexingDurationMicros";
    public static final String STAT_NAME_SEARCHER_UPDATE_COUNT = "indexSearcherUpdateCount";
    private static final String STAT_NAME_WRITER_ALREADY_CLOSED_EXCEPTION_COUNT = "indexWriterAlreadyClosedFailureCount";
    public static final String STAT_NAME_SERVICE_DELETE_COUNT = "serviceDeleteCount";
    public static final String STAT_NAME_DOCUMENT_EXPIRATION_COUNT = "expiredDocumentCount";
    protected static final int UPDATE_THREAD_COUNT = 4;
    protected static final int QUERY_THREAD_COUNT = 2;
    private static final String DELETE_ACTION = Service.Action.DELETE.toString().intern();
    protected final Object searchSync = new Object();
    protected Queue<IndexSearcher> searchersPendingClose = new ConcurrentLinkedQueue<IndexSearcher>();
    protected IndexSearcher searcher = null;
    protected IndexWriter writer = null;
    protected final Semaphore writerAvailable = new Semaphore(6);
    protected Map<String, QueryTask> activeQueries = new ConcurrentSkipListMap<String, QueryTask>();
    private long searcherUpdateTimeMicros;
    private long indexUpdateTimeMicros;
    private long indexWriterCreationTimeMicros;
    private final ConcurrentSkipListMap<String, Long> linkAccessTimes = new ConcurrentSkipListMap();
    private final Map<String, Long> linkDocumentRetentionEstimates = new HashMap<String, Long>();
    private Sort versionSort;
    private ExecutorService privateIndexingExecutor;
    private ExecutorService privateQueryExecutor;
    private final FieldType longStoredField = LuceneDocumentIndexService.numericDocType(FieldType.NumericType.LONG, true);
    private final FieldType longUnStoredField = LuceneDocumentIndexService.numericDocType(FieldType.NumericType.LONG, false);
    private final FieldType doubleStoredField = LuceneDocumentIndexService.numericDocType(FieldType.NumericType.DOUBLE, true);
    private final FieldType doubleUnStoredField = LuceneDocumentIndexService.numericDocType(FieldType.NumericType.DOUBLE, false);
    private Set<String> fieldsToLoadNoExpand;
    private Set<String> fieldsToLoadWithExpand;
    private URI uri;

    public static void setIndexFileCountThresholdForWriterRefresh(int count) {
        INDEX_FILE_COUNT_THRESHOLD_FOR_WRITER_REFRESH = count;
    }

    public static int getIndexFileCountThresholdForWriterRefresh() {
        return INDEX_FILE_COUNT_THRESHOLD_FOR_WRITER_REFRESH;
    }

    public LuceneDocumentIndexService() {
        this(FILE_PATH_LUCENE);
    }

    public LuceneDocumentIndexService(String indexDirectory) {
        super(ServiceDocument.class);
        super.toggleOption(Service.ServiceOption.PERIODIC_MAINTENANCE, true);
        this.indexDirectory = indexDirectory;
    }

    @Override
    public void handleStart(Operation post) {
        super.setMaintenanceIntervalMicros(this.getHost().getMaintenanceIntervalMicros() * 5L);
        this.uri = super.getUri();
        File directory = new File(new File(this.getHost().getStorageSandbox()), this.indexDirectory);
        this.privateQueryExecutor = Executors.newFixedThreadPool(2, r -> new Thread(r, this.getUri() + "/queries/" + Utils.getNowMicrosUtc()));
        this.privateIndexingExecutor = Executors.newFixedThreadPool(4, r -> new Thread(r, this.getSelfLink() + "/updates/" + Utils.getNowMicrosUtc()));
        this.versionSort = new Sort(new SortField("documentVersion", SortField.Type.LONG, true));
        this.fieldsToLoadNoExpand = new HashSet<String>();
        this.fieldsToLoadNoExpand.add("documentSelfLink");
        this.fieldsToLoadNoExpand.add("documentVersion");
        this.fieldsToLoadNoExpand.add("documentUpdateTimeMicros");
        this.fieldsToLoadNoExpand.add("documentUpdateAction");
        this.fieldsToLoadNoExpand.add("documentExpirationTimeMicros");
        this.fieldsToLoadWithExpand = new HashSet<String>(this.fieldsToLoadNoExpand);
        this.fieldsToLoadWithExpand.add(LUCENE_FIELD_NAME_JSON_SERIALIZED_STATE);
        this.fieldsToLoadWithExpand.add(LUCENE_FIELD_NAME_BINARY_SERIALIZED_STATE);
        for (int retryCount = 0; retryCount < 2; ++retryCount) {
            try {
                this.createWriter(directory, true);
                this.doSelfValidationQuery();
                if (retryCount != 1) break;
                this.logInfo("Retry to create index writer was successful", new Object[0]);
                break;
            }
            catch (Throwable e) {
                this.adjustStat(STAT_NAME_INDEX_LOAD_RETRY_COUNT, 1.0);
                if (retryCount >= 1) {
                    this.logWarning("Failure creating index writer: %s", Utils.toString(e));
                    post.fail(e);
                    return;
                }
                this.logWarning("Failure creating index writer, will retry", new Object[0]);
                this.close(this.writer);
                this.archiveCorruptIndexFiles(directory);
                continue;
            }
        }
        post.complete();
    }

    public IndexWriter createWriter(File directory, boolean doUpgrade) throws Exception {
        FSDirectory dir = MMapDirectory.open((Path)directory.toPath());
        SimpleAnalyzer analyzer = new SimpleAnalyzer();
        if (doUpgrade && DirectoryReader.indexExists((Directory)dir)) {
            this.upgradeIndex((Directory)dir);
        }
        IndexWriterConfig iwc = new IndexWriterConfig((Analyzer)analyzer);
        iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        iwc.setIndexDeletionPolicy((IndexDeletionPolicy)new SnapshotDeletionPolicy((IndexDeletionPolicy)new KeepOnlyLastCommitDeletionPolicy()));
        Long totalMBs = this.getHost().getServiceMemoryLimitMB(this.getSelfLink(), ServiceHost.ServiceHostState.MemoryLimitType.EXACT);
        if (totalMBs != null) {
            totalMBs = Math.max(1L, totalMBs / 2L);
            iwc.setRAMBufferSizeMB((double)totalMBs.longValue());
        }
        this.writer = new IndexWriter((Directory)dir, iwc);
        this.writer.commit();
        this.linkAccessTimes.clear();
        this.indexWriterCreationTimeMicros = this.indexUpdateTimeMicros = Utils.getNowMicrosUtc();
        return this.writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeIndex(Directory dir) throws IOException {
        boolean doUpgrade = false;
        IndexWriterConfig iwc = new IndexWriterConfig(null);
        try (CheckIndex chkIndex = new CheckIndex(dir);){
            for (CheckIndex.Status.SegmentInfoStatus segmentInfo : chkIndex.checkIndex().segmentInfos) {
                if (segmentInfo.version.equals((Object)Version.LATEST)) continue;
                this.logInfo("Found Index version %s", segmentInfo.version.toString());
                doUpgrade = true;
                break;
            }
        }
        if (doUpgrade) {
            this.logInfo("Upgrading index to %s", Version.LATEST.toString());
            new IndexUpgrader(dir, iwc, false).upgrade();
            this.indexUpdateTimeMicros = Utils.getNowMicrosUtc();
        }
    }

    private void archiveCorruptIndexFiles(File directory) {
        File newDirectory = new File(new File(this.getHost().getStorageSandbox()), "lucene." + Utils.getNowMicrosUtc());
        try {
            Files.createDirectory(newDirectory.toPath(), new FileAttribute[0]);
            FileUtils.moveOrDeleteFiles(directory, newDirectory, false);
        }
        catch (IOException e) {
            this.logWarning(e.toString(), new Object[0]);
        }
    }

    private void doSelfValidationQuery() throws Throwable {
        TermQuery tq = new TermQuery(new Term("documentSelfLink", this.getSelfLink()));
        ServiceDocumentQueryResult rsp = new ServiceDocumentQueryResult();
        this.queryIndexWithWriter(Operation.createGet(this.getUri()), EnumSet.of(QueryTask.QuerySpecification.QueryOption.INCLUDE_ALL_VERSIONS), (Query)tq, null, null, Integer.MAX_VALUE, 0L, null, rsp, Service.ServiceOption.PERSISTENCE, new IndexSearcher((IndexReader)DirectoryReader.open((IndexWriter)this.writer, (boolean)true)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleBackup(Operation op, BackupRequest req) throws Throwable {
        IndexWriter w;
        block6: {
            SnapshotDeletionPolicy snapshotter = null;
            IndexCommit commit = null;
            this.handleMaintenanceImpl(true);
            w = this.writer;
            if (w == null) {
                op.fail(new CancellationException());
                return;
            }
            try {
                snapshotter = (SnapshotDeletionPolicy)w.getConfig().getIndexDeletionPolicy();
                commit = snapshotter.snapshot();
                String indexDirectory = UriUtils.buildUriPath(this.getHost().getStorageSandbox().getPath(), FILE_PATH_LUCENE);
                List<URI> fileList = FileUtils.filesToUris(indexDirectory, commit.getFileNames());
                req.backupFile = FileUtils.zipFiles(fileList, this.indexDirectory + "-" + Utils.getNowMicrosUtc());
                op.setBody(req).complete();
                if (snapshotter == null) break block6;
            }
            catch (Exception e) {
                try {
                    this.logSevere(e);
                    throw e;
                }
                catch (Throwable throwable) {
                    if (snapshotter != null) {
                        snapshotter.release(commit);
                    }
                    w.deleteUnusedFiles();
                    throw throwable;
                }
            }
            snapshotter.release(commit);
        }
        w.deleteUnusedFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRestore(Operation op, RestoreRequest req) {
        IndexWriter w = this.writer;
        if (w == null) {
            op.fail(new CancellationException());
            return;
        }
        int semaphoreCount = 5;
        try {
            File[] files;
            this.writerAvailable.acquire(5);
            this.close(w);
            File directory = new File(new File(this.getHost().getStorageSandbox()), this.indexDirectory);
            if (directory.exists() && (files = directory.listFiles()) != null && files.length > 0) {
                this.logInfo("archiving existing index %s", directory);
                this.archiveCorruptIndexFiles(directory);
            }
            this.logInfo("restoring index %s from %s md5sum(%s)", directory, req.backupFile, FileUtils.md5sum(new File(req.backupFile)));
            FileUtils.extractZipArchive(new File(req.backupFile), directory.toPath());
            this.indexUpdateTimeMicros = Utils.getNowMicrosUtc();
            this.createWriter(directory, true);
            op.complete();
            this.logInfo("restore complete", new Object[0]);
        }
        catch (Throwable e) {
            this.logSevere(e);
            op.fail(e);
        }
        finally {
            this.writerAvailable.release(5);
        }
    }

    @Override
    public void authorizeRequest(Operation op) {
        op.complete();
    }

    @Override
    public void handleRequest(Operation op) {
        ExecutorService exec;
        Service.Action a = op.getAction();
        if (a == Service.Action.PUT) {
            this.getHost().failRequestActionNotSupported(op);
            return;
        }
        if (a == Service.Action.PATCH && op.isRemote()) {
            this.getHost().failRequestActionNotSupported(op);
            return;
        }
        ExecutorService executorService = exec = a == Service.Action.GET ? this.privateQueryExecutor : this.privateIndexingExecutor;
        if (exec.isShutdown()) {
            op.fail(new CancellationException());
            return;
        }
        exec.execute(() -> {
            try {
                this.writerAvailable.acquire();
                switch (a) {
                    case DELETE: {
                        this.handleDeleteImpl(op);
                        return;
                    }
                    case GET: {
                        this.handleGetImpl(op);
                        return;
                    }
                    case PATCH: {
                        ServiceDocument sd = (ServiceDocument)op.getBodyRaw();
                        if (sd.documentKind != null) {
                            if (sd.documentKind.equals(QueryTask.KIND)) {
                                QueryTask task = (QueryTask)op.getBodyRaw();
                                this.handleQueryTaskPatch(op, task);
                                return;
                            }
                            if (sd.documentKind.equals(BackupRequest.KIND)) {
                                BackupRequest backupRequest = (BackupRequest)op.getBodyRaw();
                                this.handleBackup(op, backupRequest);
                                return;
                            }
                            if (sd.documentKind.equals(RestoreRequest.KIND)) {
                                RestoreRequest backupRequest = (RestoreRequest)op.getBodyRaw();
                                this.handleRestore(op, backupRequest);
                                return;
                            }
                        }
                        this.getHost().failRequestActionNotSupported(op);
                        return;
                    }
                    case POST: {
                        this.updateIndex(op);
                        return;
                    }
                }
                this.getHost().failRequestActionNotSupported(op);
                return;
            }
            catch (Throwable e) {
                this.checkFailureAndRecover(e);
                op.fail(e);
                return;
            }
            finally {
                this.writerAvailable.release();
            }
        });
    }

    private void handleQueryTaskPatch(Operation op, QueryTask task) {
        try {
            QueryTask.QuerySpecification qs = task.querySpec;
            Query luceneQuery = (Query)qs.context.nativeQuery;
            Sort luceneSort = (Sort)qs.context.nativeSort;
            LuceneQueryPageService.LuceneQueryPage lucenePage = (LuceneQueryPageService.LuceneQueryPage)qs.context.nativePage;
            IndexSearcher s = (IndexSearcher)qs.context.nativeSearcher;
            ServiceDocumentQueryResult rsp = new ServiceDocumentQueryResult();
            if (qs.options.contains((Object)QueryTask.QuerySpecification.QueryOption.CONTINUOUS)) {
                switch (task.taskInfo.stage) {
                    case CREATED: {
                        this.logWarning("Task %s is in invalid state: %s", new Object[]{task.taskInfo.stage});
                        op.fail(new IllegalStateException("Stage not supported"));
                        return;
                    }
                    case STARTED: {
                        QueryTask clonedTask = new QueryTask();
                        clonedTask.documentSelfLink = task.documentSelfLink;
                        clonedTask.querySpec = task.querySpec;
                        clonedTask.querySpec.context.filter = QueryFilter.create(qs.query);
                        this.activeQueries.put(task.documentSelfLink, clonedTask);
                        this.setStat(STAT_NAME_ACTIVE_QUERY_FILTERS, (double)this.activeQueries.size());
                        this.logInfo("Activated continuous query task: %s", task.documentSelfLink);
                        break;
                    }
                    case CANCELLED: 
                    case FAILED: 
                    case FINISHED: {
                        this.activeQueries.remove(task.documentSelfLink);
                        this.setStat(STAT_NAME_ACTIVE_QUERY_FILTERS, (double)this.activeQueries.size());
                        op.complete();
                        return;
                    }
                }
            }
            if (!this.queryIndex(s, op, null, qs.options, luceneQuery, luceneSort, lucenePage, (int)qs.resultLimit, task.documentExpirationTimeMicros, task.indexLink, rsp)) {
                op.setBodyNoCloning(rsp).complete();
            }
        }
        catch (Throwable e) {
            this.logSevere(e);
            op.fail(e);
        }
    }

    public void handleGetImpl(Operation get) throws Throwable {
        Map<String, String> params = UriUtils.parseUriQueryParams(get.getUri());
        String cap = params.get("capability");
        EnumSet<QueryTask.QuerySpecification.QueryOption> options = EnumSet.noneOf(QueryTask.QuerySpecification.QueryOption.class);
        Service.ServiceOption targetIndex = Service.ServiceOption.NONE;
        Long version = null;
        if (cap != null) {
            targetIndex = Service.ServiceOption.valueOf(cap);
        }
        if (params.containsKey("includeDeleted")) {
            options.add(QueryTask.QuerySpecification.QueryOption.INCLUDE_DELETED);
        }
        if (params.containsKey("documentVersion")) {
            version = Long.parseLong(params.get("documentVersion"));
        }
        String selfLink = params.get("documentSelfLink");
        String fieldToExpand = params.get("expand");
        if (fieldToExpand != null && fieldToExpand.equals("documentLinks")) {
            options.add(QueryTask.QuerySpecification.QueryOption.EXPAND_CONTENT);
        }
        if (selfLink == null) {
            get.fail(new IllegalArgumentException("documentSelfLink query parameter is required"));
            return;
        }
        if (!selfLink.endsWith("*")) {
            this.queryIndexSingle(selfLink, options, get, version);
            return;
        }
        int resultLimit = Integer.MAX_VALUE;
        selfLink = selfLink.substring(0, selfLink.length() - 1);
        PrefixQuery tq = new PrefixQuery(new Term("documentSelfLink", selfLink));
        ServiceDocumentQueryResult rsp = new ServiceDocumentQueryResult();
        rsp.documentLinks = new ArrayList<String>();
        if (this.queryIndex(null, get, selfLink, options, (Query)tq, null, null, resultLimit, 0L, null, rsp)) {
            return;
        }
        if (targetIndex == Service.ServiceOption.PERSISTENCE) {
            get.setBodyNoCloning(rsp).complete();
            return;
        }
        this.queryServiceHost(selfLink + "*", options, get);
    }

    private boolean queryIndex(IndexSearcher s, Operation op, String selfLinkPrefix, EnumSet<QueryTask.QuerySpecification.QueryOption> options, Query tq, Sort sort, LuceneQueryPageService.LuceneQueryPage page, int count, long expiration, String indexLink, ServiceDocumentQueryResult rsp) throws Throwable {
        if (options == null) {
            options = EnumSet.noneOf(QueryTask.QuerySpecification.QueryOption.class);
        }
        if (options.contains((Object)QueryTask.QuerySpecification.QueryOption.COUNT) && options.contains((Object)QueryTask.QuerySpecification.QueryOption.EXPAND_CONTENT)) {
            op.fail(new IllegalArgumentException("COUNT can not be combined with EXPAND: %s" + options.toString()));
            return true;
        }
        if (options.contains((Object)QueryTask.QuerySpecification.QueryOption.EXPAND_CONTENT)) {
            rsp.documents = new HashMap<String, Object>();
        }
        if (options.contains((Object)QueryTask.QuerySpecification.QueryOption.COUNT)) {
            rsp.documentCount = 0L;
            sort = null;
        } else {
            rsp.documentLinks = new ArrayList<String>();
        }
        IndexWriter w = this.writer;
        if (w == null) {
            op.fail(new CancellationException());
            return true;
        }
        if (sort == null) {
            sort = this.versionSort;
        }
        if (s == null) {
            s = this.searcher;
            if (!options.contains((Object)QueryTask.QuerySpecification.QueryOption.DO_NOT_REFRESH) || s == null) {
                s = this.updateSearcher(selfLinkPrefix, count, w);
            }
        }
        if ((tq = this.updateQuery(op, tq)) == null) {
            return false;
        }
        return this.queryIndexWithWriter(op, options, tq, sort, page, count, expiration, indexLink, rsp, Service.ServiceOption.PERSISTENCE, s);
    }

    private void queryIndexSingle(String selfLink, EnumSet<QueryTask.QuerySpecification.QueryOption> options, Operation op, Long version) throws Throwable {
        IndexWriter w = this.writer;
        if (w == null) {
            op.fail(new CancellationException());
            return;
        }
        IndexSearcher s = this.updateSearcher(selfLink, 1, w);
        long start = Utils.getNowMicrosUtc();
        TopDocs hits = this.searchByVersion(selfLink, s, version);
        long end = Utils.getNowMicrosUtc();
        if (hits.totalHits == 0) {
            op.complete();
            return;
        }
        if (this.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
            ServiceStats.ServiceStat st = this.getHistogramStat(STAT_NAME_QUERY_SINGLE_DURATION_MICROS);
            this.setStat(st, (double)(end - start));
        }
        Document doc = s.getIndexReader().document(hits.scoreDocs[0].doc, this.fieldsToLoadWithExpand);
        if (this.checkAndDeleteExpiratedDocuments(selfLink, s, hits.scoreDocs[0].doc, doc, Utils.getNowMicrosUtc())) {
            op.complete();
            return;
        }
        BytesRef binaryState = doc.getBinaryValue(LUCENE_FIELD_NAME_BINARY_SERIALIZED_STATE);
        if (binaryState != null) {
            ServiceDocument state = (ServiceDocument)Utils.fromDocumentBytes(binaryState.bytes, binaryState.offset, binaryState.length);
            op.setBodyNoCloning(state);
        }
        op.complete();
    }

    private TopDocs searchByVersion(String selfLink, IndexSearcher s, Long version) throws IOException {
        TermQuery tqSelfLink = new TermQuery(new Term("documentSelfLink", selfLink));
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.add((Query)tqSelfLink, BooleanClause.Occur.MUST);
        if (version != null) {
            NumericRangeQuery versionQuery = NumericRangeQuery.newLongRange((String)"documentVersion", (Long)version, (Long)version, (boolean)true, (boolean)true);
            builder.add((Query)versionQuery, BooleanClause.Occur.MUST);
        }
        TopFieldDocs hits = s.search((Query)builder.build(), 1, this.versionSort, false, false);
        return hits;
    }

    private void queryServiceHost(String selfLink, EnumSet<QueryTask.QuerySpecification.QueryOption> options, Operation op) {
        if (options.contains((Object)QueryTask.QuerySpecification.QueryOption.EXPAND_CONTENT)) {
            op.nestCompletion(o -> this.expandLinks((Operation)o, op));
        }
        this.getHost().queryServiceUris(selfLink, op);
    }

    boolean queryIndexWithWriter(Operation op, EnumSet<QueryTask.QuerySpecification.QueryOption> options, Query tq, Sort sort, LuceneQueryPageService.LuceneQueryPage page, int count, long expiration, String indexLink, ServiceDocumentQueryResult rsp, Service.ServiceOption targetIndex, IndexSearcher s) throws Throwable {
        Object resultBody = this.queryIndex(op, targetIndex, options, s, tq, sort, page, count, expiration, indexLink, rsp);
        if (count == 1 && resultBody instanceof String) {
            op.setBodyNoCloning(resultBody).complete();
            return true;
        }
        ServiceDocumentQueryResult result = (ServiceDocumentQueryResult)resultBody;
        if (result != null) {
            result.documentOwner = this.getHost().getId();
            if (!options.contains((Object)QueryTask.QuerySpecification.QueryOption.COUNT) && result.documentLinks.isEmpty()) {
                return false;
            }
            op.setBodyNoCloning(result).complete();
            return true;
        }
        return false;
    }

    private Query updateQuery(Operation op, Query tq) {
        Object rq = null;
        Operation.AuthorizationContext ctx = op.getAuthorizationContext();
        if (!this.getHost().isAuthorizationEnabled()) {
            return tq;
        }
        if (ctx == null) {
            return null;
        }
        if (ctx.isSystemUser()) {
            return tq;
        }
        rq = ctx.getResourceQuery(Service.Action.GET) == null ? new MatchNoDocsQuery() : LuceneQueryConverter.convertToLuceneQuery(ctx.getResourceQuery(Service.Action.GET));
        BooleanQuery.Builder builder = new BooleanQuery.Builder().add((Query)rq, BooleanClause.Occur.FILTER).add(tq, BooleanClause.Occur.FILTER);
        return builder.build();
    }

    private Object queryIndex(Operation op, Service.ServiceOption targetIndex, EnumSet<QueryTask.QuerySpecification.QueryOption> options, IndexSearcher s, Query tq, Sort sort, LuceneQueryPageService.LuceneQueryPage page, int count, long expiration, String indexLink, ServiceDocumentQueryResult rsp) throws Throwable {
        long queryStartTimeMicros;
        ScoreDoc after = null;
        boolean isPaginatedQuery = count != Integer.MAX_VALUE && !options.contains((Object)QueryTask.QuerySpecification.QueryOption.TOP_RESULTS);
        boolean hasPage = page != null;
        boolean shouldProcessResults = true;
        int resultLimit = count;
        if (hasPage) {
            after = page.after;
            rsp.prevPageLink = page.link;
        } else if (isPaginatedQuery) {
            resultLimit = 1;
            shouldProcessResults = false;
            rsp.documentCount = 1L;
        }
        Object results = null;
        rsp.queryTimeMicros = 0L;
        long start = queryStartTimeMicros = Utils.getNowMicrosUtc();
        do {
            results = sort == null ? s.searchAfter(after, tq, count) : s.searchAfter(after, tq, count, sort, false, false);
            long end = Utils.getNowMicrosUtc();
            if (results == null) {
                return null;
            }
            ScoreDoc[] hits = results.scoreDocs;
            long queryTime = end - start;
            rsp.documentCount = 0L;
            ServiceDocumentQueryResult serviceDocumentQueryResult = rsp;
            Long.valueOf(serviceDocumentQueryResult.queryTimeMicros + queryTime);
            serviceDocumentQueryResult.queryTimeMicros = serviceDocumentQueryResult.queryTimeMicros;
            ScoreDoc bottom = null;
            if (shouldProcessResults) {
                start = Utils.getNowMicrosUtc();
                bottom = this.processQueryResults(targetIndex, options, count, s, rsp, hits, queryStartTimeMicros);
                end = Utils.getNowMicrosUtc();
                if (this.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
                    String statName = options.contains((Object)QueryTask.QuerySpecification.QueryOption.INCLUDE_ALL_VERSIONS) ? STAT_NAME_QUERY_ALL_VERSIONS_DURATION_MICROS : STAT_NAME_QUERY_DURATION_MICROS;
                    ServiceStats.ServiceStat st = this.getHistogramStat(statName);
                    this.setStat(st, (double)queryTime);
                    st = this.getHistogramStat(STAT_NAME_RESULT_PROCESSING_DURATION_MICROS);
                    this.setStat(st, (double)(end - start));
                }
            }
            if (!isPaginatedQuery && !options.contains((Object)QueryTask.QuerySpecification.QueryOption.TOP_RESULTS) || hits.length == 0) break;
            if (isPaginatedQuery) {
                if (!hasPage) {
                    bottom = null;
                }
                if (!hasPage || rsp.documentLinks.size() >= count || hits.length < resultLimit) {
                    rsp.nextPageLink = this.createNextPage(op, s, options, tq, sort, bottom, count, expiration += queryTime, indexLink, hasPage);
                    break;
                }
            }
            after = bottom;
        } while ((resultLimit = count - rsp.documentLinks.size()) > 0);
        return rsp;
    }

    private String createNextPage(Operation op, IndexSearcher s, EnumSet<QueryTask.QuerySpecification.QueryOption> options, Query tq, Sort sort, ScoreDoc after, int count, long expiration, String indexLink, boolean hasPage) {
        URI u = UriUtils.buildUri(this.getHost(), UriUtils.buildUriPath("/core", "query-page", Utils.getNowMicrosUtc() + ""));
        URI forwarderUri = UriUtils.buildForwardToPeerUri(u, this.getHost().getId(), "/core/node-selectors/default", EnumSet.noneOf(Service.ServiceOption.class));
        String nextLink = forwarderUri.getPath() + "?" + forwarderUri.getQuery();
        URI forwarderUriOfPrevLinkForNewPage = UriUtils.buildForwardToPeerUri(op.getReferer(), this.getHost().getId(), "/core/node-selectors/default", EnumSet.noneOf(Service.ServiceOption.class));
        String prevLinkForNewPage = forwarderUriOfPrevLinkForNewPage.getPath() + "?" + forwarderUriOfPrevLinkForNewPage.getQuery();
        LuceneQueryPageService.LuceneQueryPage page = new LuceneQueryPageService.LuceneQueryPage(hasPage ? prevLinkForNewPage : null, after);
        QueryTask.QuerySpecification spec = new QueryTask.QuerySpecification();
        spec.options = options;
        spec.context.nativeQuery = tq;
        spec.context.nativePage = page;
        spec.context.nativeSearcher = s;
        spec.context.nativeSort = sort;
        spec.resultLimit = count;
        ServiceDocument body = new ServiceDocument();
        body.documentSelfLink = u.getPath();
        body.documentExpirationTimeMicros = expiration;
        Operation.AuthorizationContext ctx = op.getAuthorizationContext();
        if (ctx != null) {
            body.documentAuthPrincipalLink = ctx.getClaims().getSubject();
        }
        Operation startPost = Operation.createPost(u).setBody(body).setCompletion((o, e) -> {
            if (e != null) {
                this.logWarning("Unable to start next page service: %s", e.toString());
            }
        });
        if (ctx != null) {
            this.setAuthorizationContext(startPost, ctx);
        }
        this.getHost().startService(startPost, new LuceneQueryPageService(spec, indexLink));
        return nextLink;
    }

    private ScoreDoc processQueryResults(Service.ServiceOption targetIndex, EnumSet<QueryTask.QuerySpecification.QueryOption> options, int resultLimit, IndexSearcher s, ServiceDocumentQueryResult rsp, ScoreDoc[] hits, long queryStartTimeMicros) throws Throwable {
        ScoreDoc lastDocVisited = null;
        Set<String> fieldsToLoad = this.fieldsToLoadNoExpand;
        if (options.contains((Object)QueryTask.QuerySpecification.QueryOption.EXPAND_CONTENT)) {
            fieldsToLoad = this.fieldsToLoadWithExpand;
        }
        LinkedHashSet<String> uniques = new LinkedHashSet<String>(rsp.documentLinks);
        boolean hasCountOption = options.contains((Object)QueryTask.QuerySpecification.QueryOption.COUNT);
        HashMap<String, Long> latestVersions = new HashMap<String, Long>();
        for (ScoreDoc sd : hits) {
            boolean isDeleted;
            if (uniques.size() >= resultLimit) break;
            lastDocVisited = sd;
            Document d = s.getIndexReader().document(sd.doc, fieldsToLoad);
            String link = d.get("documentSelfLink");
            IndexableField versionField = d.getField("documentVersion");
            Long documentVersion = versionField.numericValue().longValue();
            Long latestVersion = (Long)latestVersions.get(link);
            if (latestVersion == null) {
                latestVersion = this.getLatestVersion(s, link);
                latestVersions.put(link, latestVersion);
            }
            if ((isDeleted = DELETE_ACTION.equals(d.get("documentUpdateAction"))) && !options.contains((Object)QueryTask.QuerySpecification.QueryOption.INCLUDE_DELETED)) {
                if (documentVersion < latestVersion) continue;
                uniques.remove(link);
                continue;
            }
            if (!options.contains((Object)QueryTask.QuerySpecification.QueryOption.INCLUDE_ALL_VERSIONS)) {
                if (documentVersion < latestVersion) {
                    continue;
                }
            } else {
                link = UriUtils.buildPathWithVersion(link, documentVersion);
            }
            if (this.checkAndDeleteExpiratedDocuments(link, s, sd.doc, d, queryStartTimeMicros)) {
                latestVersions.put(link, Long.MAX_VALUE);
                continue;
            }
            if (hasCountOption) {
                uniques.add(link);
                latestVersions.put(link, Long.MAX_VALUE);
                continue;
            }
            if (options.contains((Object)QueryTask.QuerySpecification.QueryOption.EXPAND_CONTENT)) {
                String json = null;
                ServiceDocument state = this.getStateFromLuceneDocument(d, link);
                if (state == null) {
                    json = d.get(LUCENE_FIELD_NAME_JSON_SERIALIZED_STATE);
                    if (json == null) {
                        continue;
                    }
                } else {
                    json = Utils.toJson(state);
                }
                if (!rsp.documents.containsKey(link)) {
                    rsp.documents.put(link, new JsonParser().parse(json).getAsJsonObject());
                }
            }
            uniques.add(link);
        }
        if (hasCountOption) {
            rsp.documentCount = uniques.size();
        } else {
            rsp.documentLinks.clear();
            rsp.documentLinks.addAll(uniques);
            rsp.documentCount = rsp.documentLinks.size();
        }
        return lastDocVisited;
    }

    private ServiceDocument getStateFromLuceneDocument(Document doc, String link) {
        BytesRef binaryStateField = doc.getBinaryValue(LUCENE_FIELD_NAME_BINARY_SERIALIZED_STATE);
        if (binaryStateField == null) {
            this.logWarning("State not found for %s", link);
            return null;
        }
        ServiceDocument state = (ServiceDocument)Utils.fromDocumentBytes(binaryStateField.bytes, binaryStateField.offset, binaryStateField.length);
        return state;
    }

    private long getLatestVersion(IndexSearcher s, String link) throws IOException {
        TopDocs td = this.searchByVersion(link, s, null);
        Document latestVersionDoc = s.getIndexReader().document(td.scoreDocs[0].doc, this.fieldsToLoadNoExpand);
        IndexableField versionField = latestVersionDoc.getField("documentVersion");
        long latestVersion = versionField.numericValue().longValue();
        return latestVersion;
    }

    private void expandLinks(Operation o, Operation get) {
        ServiceDocumentQueryResult r = o.getBody(ServiceDocumentQueryResult.class);
        if (r.documentLinks == null || r.documentLinks.isEmpty()) {
            get.setBodyNoCloning(r).complete();
            return;
        }
        r.documents = new HashMap<String, Object>();
        AtomicInteger i = new AtomicInteger(r.documentLinks.size());
        Operation.CompletionHandler c = (op, e) -> {
            try {
                if (e != null) {
                    this.logWarning("failure expanding %s: %s", op.getUri().getPath(), e.getMessage());
                    return;
                }
                Map<String, Object> map = r.documents;
                synchronized (map) {
                    r.documents.put(op.getUri().getPath(), op.getBodyRaw());
                }
            }
            finally {
                if (i.decrementAndGet() == 0) {
                    get.setBodyNoCloning(r).complete();
                }
            }
        };
        for (String selfLink : r.documentLinks) {
            this.sendRequest(Operation.createGet(this, selfLink).addPragmaDirective("xn-no-queuing").setCompletion(c));
        }
    }

    public void handleDeleteImpl(Operation delete) throws Throwable {
        this.setProcessingStage(Service.ProcessingStage.STOPPED);
        this.privateIndexingExecutor.shutdown();
        this.privateQueryExecutor.shutdown();
        IndexWriter w = this.writer;
        this.writer = null;
        this.close(w);
        this.getHost().stopService(this);
        delete.complete();
    }

    private void close(IndexWriter wr) {
        try {
            if (wr == null) {
                return;
            }
            this.logInfo("Document count: %d ", wr.maxDoc());
            wr.commit();
            wr.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static FieldType numericDocType(FieldType.NumericType type, boolean store) {
        FieldType t = new FieldType();
        t.setStored(store);
        t.setDocValuesType(DocValuesType.NUMERIC);
        t.setIndexOptions(IndexOptions.DOCS);
        t.setNumericType(type);
        t.setNumericPrecisionStep(16);
        return t;
    }

    protected void updateIndex(Operation updateOp) throws Throwable {
        UpdateIndexRequest r = updateOp.getBody(UpdateIndexRequest.class);
        ServiceDocument s = r.document;
        ServiceDocumentDescription desc = r.description;
        if (updateOp.isRemote()) {
            updateOp.fail(new IllegalStateException("Remote requests not allowed"));
            return;
        }
        if (s == null) {
            updateOp.fail(new IllegalArgumentException("document is required"));
            return;
        }
        String link = s.documentSelfLink;
        if (link == null) {
            updateOp.fail(new IllegalArgumentException("documentSelfLink is required"));
            return;
        }
        if (s.documentUpdateAction == null) {
            updateOp.fail(new IllegalArgumentException("documentUpdateAction is required"));
            return;
        }
        if (desc == null) {
            updateOp.fail(new IllegalArgumentException("description is required"));
            return;
        }
        s.documentDescription = null;
        Document doc = new Document();
        StoredField updateActionField = new StoredField("documentUpdateAction", s.documentUpdateAction);
        doc.add((IndexableField)updateActionField);
        this.addBinaryStateFieldToDocument(s, desc, doc);
        StringField selfLinkField = new StringField("documentSelfLink", link, Field.Store.YES);
        doc.add((IndexableField)selfLinkField);
        SortedDocValuesField sortedSelfLinkField = new SortedDocValuesField("documentSelfLink", new BytesRef((CharSequence)link));
        doc.add((IndexableField)sortedSelfLinkField);
        if (s.documentKind != null) {
            StringField kindField = new StringField("documentKind", s.documentKind, Field.Store.NO);
            doc.add((IndexableField)kindField);
        }
        if (s.documentAuthPrincipalLink != null) {
            StringField principalField = new StringField("documentAuthPrincipalLink", s.documentAuthPrincipalLink, Field.Store.NO);
            doc.add((IndexableField)principalField);
        }
        if (s.documentTransactionId != null) {
            StringField transactionField = new StringField("documentTransactionId", s.documentTransactionId, Field.Store.NO);
            doc.add((IndexableField)transactionField);
        }
        LongField timestampField = new LongField("documentUpdateTimeMicros", s.documentUpdateTimeMicros, this.longStoredField);
        doc.add((IndexableField)timestampField);
        if (s.documentExpirationTimeMicros > 0L) {
            LongField expirationTimeMicrosField = new LongField("documentExpirationTimeMicros", s.documentExpirationTimeMicros, this.longStoredField);
            doc.add((IndexableField)expirationTimeMicrosField);
        }
        LongField versionField = new LongField("documentVersion", s.documentVersion, this.longStoredField);
        doc.add((IndexableField)versionField);
        if (desc.propertyDescriptions == null || desc.propertyDescriptions.isEmpty()) {
            this.addDocumentToIndex(updateOp, doc, s, desc);
            return;
        }
        this.addIndexableFieldsToDocument(doc, s, desc);
        this.addDocumentToIndex(updateOp, doc, s, desc);
        if (this.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
            int fieldCount = doc.getFields().size();
            ServiceStats.ServiceStat st = this.getStat(STAT_NAME_INDEXED_FIELD_COUNT);
            this.adjustStat(st, (double)fieldCount);
            st = this.getHistogramStat(STAT_NAME_FIELD_COUNT_PER_DOCUMENT);
            this.setStat(st, (double)fieldCount);
        }
    }

    private void addBinaryStateFieldToDocument(ServiceDocument s, ServiceDocumentDescription desc, Document doc) {
        try {
            byte[] content = Utils.getBuffer(desc.serializedStateSizeLimit);
            int count = Utils.toBytes(s, content, 0);
            StoredField bodyField = new StoredField(LUCENE_FIELD_NAME_BINARY_SERIALIZED_STATE, content, 0, count);
            doc.add((IndexableField)bodyField);
        }
        catch (KryoException ke) {
            throw new IllegalArgumentException("Failure serializing state of service " + s.documentSelfLink + ", possibly due to size limit." + " Service author should override getDocumentTemplate() and adjust" + " ServiceDocumentDescription.serializedStateSizeLimit. Cause: " + ke.toString());
        }
    }

    private void addIndexableFieldsToDocument(Document doc, Object podo, ServiceDocumentDescription sd) {
        for (Map.Entry<String, ServiceDocumentDescription.PropertyDescription> e : sd.propertyDescriptions.entrySet()) {
            String name = e.getKey();
            ServiceDocumentDescription.PropertyDescription pd = e.getValue();
            if (pd.usageOptions != null && pd.usageOptions.contains((Object)ServiceDocumentDescription.PropertyUsageOption.INFRASTRUCTURE)) continue;
            Object v = ReflectionUtils.getPropertyValue(pd, podo);
            this.addIndexableFieldToDocument(doc, v, pd, name);
        }
    }

    private void addIndexableFieldToDocument(Document doc, Object podo, ServiceDocumentDescription.PropertyDescription pd, String fieldName) {
        boolean expandField;
        Object luceneField = null;
        SortedDocValuesField luceneDocValuesField = null;
        Field.Store fsv = Field.Store.NO;
        boolean isSorted = false;
        Object v = podo;
        if (v == null) {
            return;
        }
        EnumSet<ServiceDocumentDescription.PropertyIndexingOption> opts = pd.indexingOptions;
        if (opts != null && opts.contains((Object)ServiceDocumentDescription.PropertyIndexingOption.STORE_ONLY)) {
            return;
        }
        if (opts != null && opts.contains((Object)ServiceDocumentDescription.PropertyIndexingOption.SORT)) {
            isSorted = true;
        }
        boolean bl = expandField = opts != null && opts.contains((Object)ServiceDocumentDescription.PropertyIndexingOption.EXPAND);
        if (v instanceof String) {
            luceneField = opts != null && opts.contains((Object)ServiceDocumentDescription.PropertyIndexingOption.TEXT) ? new TextField(fieldName, v.toString(), fsv) : new StringField(fieldName, v.toString(), fsv);
            if (isSorted) {
                luceneDocValuesField = new SortedDocValuesField(fieldName, new BytesRef((CharSequence)v.toString()));
            }
        } else if (v instanceof URI) {
            String uriValue = QueryTask.QuerySpecification.toMatchValue((URI)v);
            luceneField = new StringField(fieldName, uriValue, fsv);
            if (isSorted) {
                luceneDocValuesField = new SortedDocValuesField(fieldName, new BytesRef((CharSequence)v.toString()));
            }
        } else if (pd.typeName.equals((Object)ServiceDocumentDescription.TypeName.ENUM)) {
            String enumValue = QueryTask.QuerySpecification.toMatchValue((Enum)v);
            luceneField = new StringField(fieldName, enumValue, fsv);
            if (isSorted) {
                luceneDocValuesField = new SortedDocValuesField(fieldName, new BytesRef((CharSequence)v.toString()));
            }
        } else if (pd.typeName.equals((Object)ServiceDocumentDescription.TypeName.LONG)) {
            if (v instanceof Integer) {
                int i = (Integer)v;
                v = (long)i * 1L;
            }
            luceneField = new LongField(fieldName, ((Long)v).longValue(), fsv == Field.Store.NO ? this.longUnStoredField : this.longStoredField);
        } else if (pd.typeName.equals((Object)ServiceDocumentDescription.TypeName.DATE)) {
            Date dt = (Date)v;
            luceneField = new LongField(fieldName, dt.getTime() * 1000L, fsv == Field.Store.NO ? this.longUnStoredField : this.longStoredField);
        } else if (pd.typeName.equals((Object)ServiceDocumentDescription.TypeName.DOUBLE)) {
            luceneField = new DoubleField(fieldName, ((Double)v).doubleValue(), fsv == Field.Store.NO ? this.doubleUnStoredField : this.doubleStoredField);
        } else if (pd.typeName.equals((Object)ServiceDocumentDescription.TypeName.BOOLEAN)) {
            String booleanValue = QueryTask.QuerySpecification.toMatchValue((Boolean)v);
            luceneField = new StringField(fieldName, booleanValue, fsv);
            if (isSorted) {
                luceneDocValuesField = new SortedDocValuesField(fieldName, new BytesRef((CharSequence)booleanValue));
            }
        } else if (!pd.typeName.equals((Object)ServiceDocumentDescription.TypeName.BYTES)) {
            if (pd.typeName.equals((Object)ServiceDocumentDescription.TypeName.PODO)) {
                if (!(v instanceof TaskState) && !expandField) {
                    return;
                }
                this.addObjectIndexableFieldToDocument(doc, v, pd, fieldName);
                return;
            }
            if (expandField && pd.typeName.equals((Object)ServiceDocumentDescription.TypeName.MAP)) {
                this.addMapIndexableFieldToDocument(doc, v, pd, fieldName);
                return;
            }
            if (expandField && (pd.typeName.equals((Object)ServiceDocumentDescription.TypeName.COLLECTION) || pd.typeName.equals((Object)ServiceDocumentDescription.TypeName.ARRAY))) {
                this.addCollectionIndexableFieldToDocument(doc, v, pd, fieldName);
                return;
            }
            luceneField = new StringField(fieldName, v.toString(), fsv);
            if (isSorted) {
                luceneDocValuesField = new SortedDocValuesField(fieldName, new BytesRef((CharSequence)v.toString()));
            }
        }
        if (luceneField != null) {
            doc.add((IndexableField)luceneField);
        }
        if (luceneDocValuesField != null) {
            doc.add(luceneDocValuesField);
        }
    }

    private void addObjectIndexableFieldToDocument(Document doc, Object v, ServiceDocumentDescription.PropertyDescription pd, String fieldNamePrefix) {
        for (Map.Entry<String, ServiceDocumentDescription.PropertyDescription> e : pd.fieldDescriptions.entrySet()) {
            ServiceDocumentDescription.PropertyDescription fieldDescription = e.getValue();
            if (pd.indexingOptions.contains((Object)ServiceDocumentDescription.PropertyIndexingOption.SORT)) {
                fieldDescription.indexingOptions.add(ServiceDocumentDescription.PropertyIndexingOption.SORT);
            }
            Object fieldValue = ReflectionUtils.getPropertyValue(fieldDescription, v);
            String fieldName = QueryTask.QuerySpecification.buildCompositeFieldName(fieldNamePrefix, e.getKey());
            this.addIndexableFieldToDocument(doc, fieldValue, fieldDescription, fieldName);
        }
    }

    private void addMapIndexableFieldToDocument(Document doc, Object v, ServiceDocumentDescription.PropertyDescription pd, String fieldNamePrefix) {
        String errorMsg = "Field not supported. Map keys must be of type String.";
        Map m = (Map)v;
        if (pd.indexingOptions.contains((Object)ServiceDocumentDescription.PropertyIndexingOption.SORT)) {
            pd.elementDescription.indexingOptions.add(ServiceDocumentDescription.PropertyIndexingOption.SORT);
        }
        for (Map.Entry o : m.entrySet()) {
            Map.Entry entry = o;
            Object mapKey = entry.getKey();
            if (!(mapKey instanceof String)) {
                throw new IllegalArgumentException("Field not supported. Map keys must be of type String.");
            }
            this.addIndexableFieldToDocument(doc, entry.getValue(), pd.elementDescription, QueryTask.QuerySpecification.buildCompositeFieldName(fieldNamePrefix, (String)mapKey));
        }
    }

    private void addCollectionIndexableFieldToDocument(Document doc, Object v, ServiceDocumentDescription.PropertyDescription pd, String fieldNamePrefix) {
        fieldNamePrefix = QueryTask.QuerySpecification.buildCollectionItemName(fieldNamePrefix);
        List<Object> c = v instanceof Collection ? (List<Object>)v : Arrays.asList((Object[])v);
        if (pd.indexingOptions.contains((Object)ServiceDocumentDescription.PropertyIndexingOption.SORT)) {
            pd.elementDescription.indexingOptions.add(ServiceDocumentDescription.PropertyIndexingOption.SORT);
        }
        for (Object e : c) {
            if (e == null) continue;
            this.addIndexableFieldToDocument(doc, e, pd.elementDescription, fieldNamePrefix);
        }
    }

    private boolean checkAndDeleteExpiratedDocuments(String link, IndexSearcher searcher, Integer docId, Document doc, long now) throws Throwable {
        long expiration = 0L;
        boolean hasExpired = false;
        IndexableField expirationValue = doc.getField("documentExpirationTimeMicros");
        if (expirationValue != null) {
            expiration = expirationValue.numericValue().longValue();
            boolean bl = hasExpired = expiration <= now;
        }
        if (!hasExpired) {
            return false;
        }
        this.adjustStat(STAT_NAME_DOCUMENT_EXPIRATION_COUNT, 1.0);
        doc = searcher.getIndexReader().document(docId.intValue(), this.fieldsToLoadWithExpand);
        ServiceDocument s = null;
        try {
            s = this.getStateFromLuceneDocument(doc, link);
        }
        catch (Throwable e) {
            this.logWarning("Error deserializing state for %s: %s", link, e.getMessage());
        }
        this.deleteAllDocumentsForSelfLink(Operation.createDelete(null), link, s);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDocumentRetentionLimit(ServiceDocument state, ServiceDocumentDescription desc) {
        Map<String, Long> map = this.linkDocumentRetentionEstimates;
        synchronized (map) {
            if (this.linkDocumentRetentionEstimates.containsKey(state.documentSelfLink)) {
                return;
            }
            long limit = Math.max(1L, desc.versionRetentionLimit);
            if (state.documentVersion < limit) {
                return;
            }
            this.linkDocumentRetentionEstimates.put(state.documentSelfLink, limit);
        }
    }

    private void checkFailureAndRecover(Throwable e) {
        if (this.writer != null) {
            this.logSevere(e);
        }
        if (!(e instanceof AlreadyClosedException)) {
            return;
        }
        this.adjustStat(STAT_NAME_WRITER_ALREADY_CLOSED_EXCEPTION_COUNT, 1.0);
        this.reOpenWriterSynchronously();
    }

    private void deleteAllDocumentsForSelfLink(Operation postOrDelete, String link, ServiceDocument state) throws Throwable {
        this.deleteDocumentsFromIndex(postOrDelete, link, 0L);
        ServiceStats.ServiceStat st = this.getStat(STAT_NAME_SERVICE_DELETE_COUNT);
        this.adjustStat(st, 1.0);
        this.logFine("%s expired", link);
        if (state == null) {
            return;
        }
        this.applyActiveQueries(state, null);
        this.sendRequest(Operation.createDelete(this, state.documentSelfLink).setBodyNoCloning(state).addPragmaDirective("xn-no-index-update"));
    }

    private void deleteDocumentsFromIndex(Operation delete, String link, long versionsToKeep) throws Throwable {
        IndexWriter wr = this.writer;
        if (wr == null) {
            delete.fail(new CancellationException());
            return;
        }
        TermQuery linkQuery = new TermQuery(new Term("documentSelfLink", link));
        IndexSearcher s = this.updateSearcher(link, Integer.MAX_VALUE, wr);
        if (s == null) {
            delete.fail(new CancellationException());
            return;
        }
        TopFieldDocs results = s.search((Query)linkQuery, Integer.MAX_VALUE, this.versionSort, false, false);
        if (results == null) {
            return;
        }
        ScoreDoc[] hits = results.scoreDocs;
        if (hits == null || hits.length == 0) {
            return;
        }
        Document hitDoc = s.doc(hits[0].doc);
        if (versionsToKeep == 0L) {
            wr.deleteDocuments(new Query[]{linkQuery});
            this.indexUpdateTimeMicros = Utils.getNowMicrosUtc();
            delete.complete();
            return;
        }
        if ((long)hits.length < versionsToKeep) {
            return;
        }
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        hitDoc = s.doc(hits[hits.length - 1].doc);
        long versionLowerBound = Long.parseLong(hitDoc.get("documentVersion"));
        hitDoc = s.doc(hits[(int)versionsToKeep - 1].doc);
        long versionUpperBound = Long.parseLong(hitDoc.get("documentVersion"));
        NumericRangeQuery versionQuery = NumericRangeQuery.newLongRange((String)"documentVersion", (Long)versionLowerBound, (Long)versionUpperBound, (boolean)true, (boolean)true);
        builder.add((Query)versionQuery, BooleanClause.Occur.MUST);
        builder.add((Query)linkQuery, BooleanClause.Occur.MUST);
        BooleanQuery bq = builder.build();
        results = s.search((Query)bq, Integer.MAX_VALUE);
        this.logInfo("trimming index for %s from %d to %d, query returned %d", link, hits.length, versionsToKeep, results.totalHits);
        wr.deleteDocuments(new Query[]{bq});
        long now = Utils.getNowMicrosUtc();
        this.updateLinkAccessTime(now, link);
        delete.complete();
    }

    private void addDocumentToIndex(Operation op, Document doc, ServiceDocument sd, ServiceDocumentDescription desc) throws IOException {
        IndexWriter wr = this.writer;
        if (wr == null) {
            op.fail(new CancellationException());
            return;
        }
        long start = Utils.getNowMicrosUtc();
        wr.addDocument((Iterable)doc);
        long end = Utils.getNowMicrosUtc();
        this.updateLinkAccessTime(end, sd.documentSelfLink);
        if (this.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
            ServiceStats.ServiceStat s = this.getHistogramStat(STAT_NAME_INDEXING_DURATION_MICROS);
            this.setStat(s, (double)(end - start));
        }
        op.setBody(null).complete();
        this.checkDocumentRetentionLimit(sd, desc);
        this.applyActiveQueries(sd, desc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLinkAccessTime(long t, String link) {
        Object object = this.searchSync;
        synchronized (object) {
            this.linkAccessTimes.put(link, t);
            if (this.indexUpdateTimeMicros < t) {
                this.indexUpdateTimeMicros = t;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexSearcher updateSearcher(String selfLink, int resultLimit, IndexWriter w) throws IOException {
        IndexSearcher s;
        boolean needNewSearcher = false;
        long now = Utils.getNowMicrosUtc();
        Object object = this.searchSync;
        synchronized (object) {
            s = this.searcher;
            if (s == null) {
                needNewSearcher = true;
            } else if (selfLink != null && resultLimit == 1) {
                Long latestUpdate = this.linkAccessTimes.get(selfLink);
                if (latestUpdate != null && latestUpdate.compareTo(this.searcherUpdateTimeMicros) >= 0) {
                    needNewSearcher = true;
                }
            } else if (this.searcherUpdateTimeMicros < this.indexUpdateTimeMicros) {
                needNewSearcher = true;
            }
            if (!needNewSearcher) {
                return s;
            }
        }
        s = new IndexSearcher((IndexReader)DirectoryReader.open((IndexWriter)w, (boolean)true));
        if (this.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
            ServiceStats.ServiceStat st = this.getStat(STAT_NAME_SEARCHER_UPDATE_COUNT);
            this.adjustStat(st, 1.0);
        }
        object = this.searchSync;
        synchronized (object) {
            if (this.searcherUpdateTimeMicros < now) {
                if (this.searcher != null) {
                    this.searchersPendingClose.add(this.searcher);
                }
                this.searcher = s;
                this.searcherUpdateTimeMicros = now;
            }
            return s;
        }
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public void handleMaintenance(Operation post) {
        this.privateIndexingExecutor.execute(() -> {
            try {
                this.writerAvailable.acquire();
                this.handleMaintenanceImpl(false);
                post.complete();
            }
            catch (Throwable e) {
                post.fail(e);
            }
            finally {
                this.writerAvailable.release();
            }
        });
    }

    private void handleMaintenanceImpl(boolean forceMerge) throws Throwable {
        try {
            long start = Utils.getNowMicrosUtc();
            IndexWriter w = this.writer;
            if (w == null) {
                return;
            }
            this.setStat(STAT_NAME_INDEXED_DOCUMENT_COUNT, (double)w.maxDoc());
            this.adjustStat(STAT_NAME_COMMIT_COUNT, 1.0);
            long end = Utils.getNowMicrosUtc();
            this.setStat(STAT_NAME_COMMIT_DURATION_MICROS, (double)(end - start));
            this.applyDocumentExpirationPolicy(w);
            this.applyDocumentVersionRetentionPolicy(w);
            w.commit();
            this.applyMemoryLimit();
            boolean reOpenWriter = this.applyIndexFileLimit();
            if (!forceMerge && !reOpenWriter) {
                return;
            }
            this.reOpenWriterSynchronously();
        }
        catch (Throwable e) {
            this.logWarning("Attempting recovery due to error: %s", e.getMessage());
            this.reOpenWriterSynchronously();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean applyIndexFileLimit() {
        File directory = new File(new File(this.getHost().getStorageSandbox()), this.indexDirectory);
        String[] list = directory.list();
        int count = list == null ? 0 : list.length;
        boolean reOpenWriter = count >= INDEX_FILE_COUNT_THRESHOLD_FOR_WRITER_REFRESH;
        int searcherCount = this.searchersPendingClose.size();
        if (searcherCount < 100 && !reOpenWriter) {
            return reOpenWriter;
        }
        int acquireReleaseCount = 6;
        try {
            if (this.getHost().isStopping()) {
                boolean bl = false;
                return bl;
            }
            this.writerAvailable.release();
            this.writerAvailable.acquire(6);
            if (this.searcher != null) {
                this.searchersPendingClose.add(this.searcher);
                this.searcher = null;
            }
            this.logInfo("Closing %d pending searchers, index file count: %d", searcherCount, count);
            for (IndexSearcher s : this.searchersPendingClose) {
                try {
                    s.getIndexReader().close();
                }
                catch (Throwable throwable) {}
            }
            this.searchersPendingClose.clear();
            IndexWriter w = this.writer;
            if (w != null) {
                try {
                    w.deleteUnusedFiles();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        catch (InterruptedException e1) {
            this.logSevere(e1);
        }
        finally {
            this.writerAvailable.release(5);
        }
        return reOpenWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reOpenWriterSynchronously() {
        int acquireReleaseCount = 6;
        try {
            if (this.getHost().isStopping()) {
                return;
            }
            this.writerAvailable.release();
            this.writerAvailable.acquire(6);
            IndexWriter w = this.writer;
            long now = Utils.getNowMicrosUtc();
            if (now - this.indexWriterCreationTimeMicros < this.getHost().getMaintenanceIntervalMicros()) {
                this.logInfo("Skipping writer re-open, it was created recently", new Object[0]);
                return;
            }
            File directory = new File(new File(this.getHost().getStorageSandbox()), this.indexDirectory);
            try {
                if (w != null) {
                    w.close();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            w = this.createWriter(directory, false);
            this.logInfo("Reopened writer, document count: %d", w.maxDoc());
        }
        catch (Throwable e) {
            this.logSevere(e);
            this.logWarning("Stopping local host since index is not accessible", new Object[0]);
            this.close(this.writer);
            this.writer = null;
            this.sendRequest(Operation.createDelete(this, "/core/management"));
        }
        finally {
            this.writerAvailable.release(5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyDocumentVersionRetentionPolicy(IndexWriter w) throws Throwable {
        IndexWriter wr = this.writer;
        if (wr == null) {
            return;
        }
        Operation dummyDelete = Operation.createDelete(null);
        int count = 0;
        HashMap<String, Long> links = new HashMap<String, Long>();
        Map<String, Long> map = this.linkDocumentRetentionEstimates;
        synchronized (map) {
            links.putAll(this.linkDocumentRetentionEstimates);
            this.linkDocumentRetentionEstimates.clear();
        }
        IndexSearcher s = this.updateSearcher(null, Integer.MAX_VALUE, wr);
        if (s == null) {
            return;
        }
        for (Map.Entry e : links.entrySet()) {
            TermQuery linkQuery = new TermQuery(new Term("documentSelfLink", (String)e.getKey()));
            int documentCount = s.count((Query)linkQuery);
            int pastRetentionLimitVersions = (int)((long)documentCount - (Long)e.getValue());
            if (pastRetentionLimitVersions <= 0) continue;
            this.deleteDocumentsFromIndex(dummyDelete, (String)e.getKey(), (Long)e.getValue());
            ++count;
        }
        if (!links.isEmpty()) {
            this.logInfo("Applied retention policy to %d links", count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyMemoryLimit() throws InterruptedException, IOException {
        if (this.getHost().isStopping()) {
            return;
        }
        Object object = this.searchSync;
        synchronized (object) {
            if (this.linkAccessTimes.isEmpty()) {
                return;
            }
            this.linkAccessTimes.clear();
            this.searcher = null;
        }
        this.updateSearcher(null, Integer.MAX_VALUE, this.writer);
    }

    private void applyDocumentExpirationPolicy(IndexWriter w) throws Throwable {
        IndexSearcher s = this.updateSearcher(null, Integer.MAX_VALUE, w);
        if (s == null) {
            return;
        }
        long expirationUpperBound = Utils.getNowMicrosUtc();
        NumericRangeQuery versionQuery = NumericRangeQuery.newLongRange((String)"documentExpirationTimeMicros", (Long)1L, (Long)expirationUpperBound, (boolean)true, (boolean)true);
        TopDocs results = s.search((Query)versionQuery, Integer.MAX_VALUE);
        if (results.totalHits == 0) {
            return;
        }
        HashSet<String> links = new HashSet<String>();
        long now = Utils.getNowMicrosUtc();
        for (ScoreDoc sd : results.scoreDocs) {
            long latestVersion;
            Document d = s.getIndexReader().document(sd.doc, this.fieldsToLoadNoExpand);
            String link = d.get("documentSelfLink");
            IndexableField versionField = d.getField("documentVersion");
            long versionExpired = versionField.numericValue().longValue();
            if (versionExpired < (latestVersion = this.getLatestVersion(s, link)) || !links.add(link)) continue;
            this.checkAndDeleteExpiratedDocuments(link, s, sd.doc, d, now);
        }
    }

    private void applyActiveQueries(ServiceDocument latestState, ServiceDocumentDescription desc) {
        if (this.activeQueries.isEmpty()) {
            return;
        }
        for (Map.Entry<String, QueryTask> taskEntry : this.activeQueries.entrySet()) {
            if (this.getHost().isStopping()) continue;
            QueryTask activeTask = taskEntry.getValue();
            QueryFilter filter = activeTask.querySpec.context.filter;
            if (desc == null ? !QueryFilterUtils.evaluate(filter, latestState, this.getHost()) : !filter.evaluate(latestState, desc)) continue;
            QueryTask patchBody = new QueryTask();
            patchBody.taskInfo.stage = TaskState.TaskStage.STARTED;
            patchBody.querySpec = null;
            patchBody.results = new ServiceDocumentQueryResult();
            patchBody.results.documentLinks.add(latestState.documentSelfLink);
            if (activeTask.querySpec.options.contains((Object)QueryTask.QuerySpecification.QueryOption.EXPAND_CONTENT)) {
                patchBody.results.documents = new HashMap<String, Object>();
                patchBody.results.documents.put(latestState.documentSelfLink, latestState);
            }
            this.sendRequest(Operation.createPatch(this, activeTask.documentSelfLink).setBodyNoCloning(patchBody));
        }
    }

    public static class RestoreRequest
    extends ServiceDocument {
        URI backupFile;
        static final String KIND = Utils.buildKind(RestoreRequest.class);
    }

    public static class BackupRequest
    extends ServiceDocument {
        URI backupFile;
        static final String KIND = Utils.buildKind(BackupRequest.class);
    }
}

