/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.OperationJoin;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceDocumentDescription;
import com.vmware.xenon.common.StatefulService;
import com.vmware.xenon.common.TaskState;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.ExampleService;
import com.vmware.xenon.services.common.QueryTask;
import com.vmware.xenon.services.common.ServiceUriPaths;
import java.net.URI;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;

public class ExampleTaskService
extends StatefulService {
    private static long DEFAULT_TASK_LIFETIME = 60L;

    public ExampleTaskService() {
        super(ExampleTaskServiceState.class);
        this.toggleOption(Service.ServiceOption.PERSISTENCE, true);
        this.toggleOption(Service.ServiceOption.REPLICATION, true);
        this.toggleOption(Service.ServiceOption.INSTRUMENTATION, true);
        this.toggleOption(Service.ServiceOption.OWNER_SELECTION, true);
    }

    @Override
    public void handleStart(Operation taskOperation) {
        ExampleTaskServiceState task = this.validateStartPost(taskOperation);
        if (task == null) {
            return;
        }
        taskOperation.complete();
        this.initializeState(task, taskOperation);
        this.sendSelfPatch(task);
    }

    private ExampleTaskServiceState validateStartPost(Operation taskOperation) {
        if (!taskOperation.hasBody()) {
            taskOperation.fail(new IllegalArgumentException("POST body is required"));
            return null;
        }
        ExampleTaskServiceState task = taskOperation.getBody(ExampleTaskServiceState.class);
        if (task.taskInfo != null) {
            taskOperation.fail(new IllegalArgumentException("Do not specify taskBody: internal use only"));
            return null;
        }
        if (task.subStage != null) {
            taskOperation.fail(new IllegalArgumentException("Do not specify subStage: internal use only"));
            return null;
        }
        if (task.exampleQueryTask != null) {
            taskOperation.fail(new IllegalArgumentException("Do not specify taskBody: internal use only"));
            return null;
        }
        if (task.taskLifetime != null && task.taskLifetime <= 0L) {
            taskOperation.fail(new IllegalArgumentException("taskLifetime must be positive"));
            return null;
        }
        return task;
    }

    private void initializeState(ExampleTaskServiceState task, Operation taskOperation) {
        task.taskInfo = new TaskState();
        task.taskInfo.stage = TaskState.TaskStage.STARTED;
        task.subStage = SubStage.QUERY_EXAMPLES;
        if (task.taskLifetime != null) {
            task.documentExpirationTimeMicros = Utils.getNowMicrosUtc() + TimeUnit.SECONDS.toMicros(task.taskLifetime);
        } else if (task.documentExpirationTimeMicros != 0L) {
            task.documentExpirationTimeMicros = Utils.getNowMicrosUtc() + TimeUnit.SECONDS.toMicros(DEFAULT_TASK_LIFETIME);
        }
        taskOperation.setBody(task);
    }

    @Override
    public void handlePatch(Operation patch) {
        ExampleTaskServiceState patchBody;
        ExampleTaskServiceState currentTask = (ExampleTaskServiceState)this.getState(patch);
        if (!this.validateTransition(patch, currentTask, patchBody = patch.getBody(ExampleTaskServiceState.class))) {
            return;
        }
        this.updateState(patch, currentTask, patchBody);
        patch.complete();
        switch (patchBody.taskInfo.stage) {
            case CREATED: {
                break;
            }
            case STARTED: {
                this.handleSubstage(patchBody);
                break;
            }
            case CANCELLED: {
                this.logInfo("Task canceled: not implemented, ignoring", new Object[0]);
                break;
            }
            case FINISHED: {
                this.logInfo("Task finished successfully", new Object[0]);
                break;
            }
            case FAILED: {
                this.logWarning("Task failed: %s", patchBody.failureMessage == null ? "No reason given" : patchBody.failureMessage);
                break;
            }
            default: {
                this.logWarning("Unexpected stage: %s", new Object[]{patchBody.taskInfo.stage});
            }
        }
    }

    private void handleSubstage(ExampleTaskServiceState task) {
        switch (task.subStage) {
            case QUERY_EXAMPLES: {
                this.handleQueryExamples(task);
                break;
            }
            case DELETE_EXAMPLES: {
                this.handleDeleteExamples(task);
                break;
            }
            default: {
                this.logWarning("Unexpected sub stage: %s", new Object[]{task.subStage});
            }
        }
    }

    private boolean validateTransition(Operation patch, ExampleTaskServiceState currentTask, ExampleTaskServiceState patchBody) {
        if (patchBody.taskInfo == null) {
            patch.fail(new IllegalArgumentException("Missing taskInfo"));
            return false;
        }
        if (patchBody.taskInfo.stage == null) {
            patch.fail(new IllegalArgumentException("Missing stage"));
            return false;
        }
        if (patchBody.taskInfo.stage == TaskState.TaskStage.STARTED && patchBody.subStage == null) {
            patch.fail(new IllegalArgumentException("Missing substage"));
            return false;
        }
        if (patchBody.taskInfo.stage == TaskState.TaskStage.CREATED) {
            patch.fail(new IllegalArgumentException("Did not expect to receive CREATED stage"));
            return false;
        }
        if (currentTask.taskInfo != null && currentTask.taskInfo.stage != null) {
            if (currentTask.taskInfo.stage.ordinal() > patchBody.taskInfo.stage.ordinal()) {
                patch.fail(new IllegalArgumentException("Task stage cannot move backwards"));
                return false;
            }
            if (currentTask.taskInfo.stage == TaskState.TaskStage.STARTED && patchBody.taskInfo.stage == TaskState.TaskStage.STARTED && currentTask.subStage.ordinal() > patchBody.subStage.ordinal()) {
                patch.fail(new IllegalArgumentException("Task substage cannot move backwards"));
                return false;
            }
        }
        return true;
    }

    private void updateState(Operation patch, ExampleTaskServiceState currentTask, ExampleTaskServiceState patchBody) {
        Utils.mergeWithState(this.getDocumentTemplate().documentDescription, currentTask, patchBody);
        if (currentTask.documentExpirationTimeMicros == 0L) {
            currentTask.documentExpirationTimeMicros = patchBody.documentExpirationTimeMicros;
        }
    }

    private void handleQueryExamples(ExampleTaskServiceState task) {
        QueryTask.Query exampleDocumentQuery = QueryTask.Query.Builder.create().setTerm("documentKind", Utils.buildKind(ExampleService.ExampleServiceState.class)).build();
        task.exampleQueryTask = QueryTask.Builder.createDirectTask().setQuery(exampleDocumentQuery).build();
        URI queryTaskUri = UriUtils.buildUri(this.getHost(), ServiceUriPaths.CORE_QUERY_TASKS);
        Operation queryRequest = Operation.createPost(queryTaskUri).setBody(task.exampleQueryTask).setCompletion((op, ex) -> {
            if (ex != null) {
                this.logWarning("Query failed, task will not finish: %s", ex.getMessage());
                return;
            }
            task.exampleQueryTask = op.getBody(QueryTask.class);
            this.sendSelfPatch(task, TaskState.TaskStage.STARTED, SubStage.DELETE_EXAMPLES);
        });
        this.sendRequest(queryRequest);
    }

    private void handleDeleteExamples(ExampleTaskServiceState task) {
        if (task.exampleQueryTask.results == null) {
            this.sendSelfFailurePatch(task, "Query task service returned null results");
            return;
        }
        if (task.exampleQueryTask.results.documentLinks == null) {
            this.sendSelfFailurePatch(task, "Query task service returned null documentLinks");
            return;
        }
        if (task.exampleQueryTask.results.documentLinks.size() == 0) {
            this.logInfo("No example service documents found, nothing to do", new Object[0]);
            this.sendSelfPatch(task, TaskState.TaskStage.FINISHED, null);
        }
        ArrayList<Operation> deleteOperations = new ArrayList<Operation>();
        for (String exampleService : task.exampleQueryTask.results.documentLinks) {
            URI exampleServiceUri = UriUtils.buildUri(this.getHost(), exampleService);
            Operation deleteOp = Operation.createDelete(exampleServiceUri);
            deleteOperations.add(deleteOp);
        }
        OperationJoin operationJoin = OperationJoin.create();
        operationJoin.setOperations(deleteOperations).setCompletion((ops, exs) -> {
            if (exs != null && !exs.isEmpty()) {
                this.sendSelfFailurePatch(task, String.format("%d deletes failed", exs.size()));
                return;
            }
            this.sendSelfPatch(task, TaskState.TaskStage.FINISHED, null);
        }).sendWith(this);
    }

    private void sendSelfFailurePatch(ExampleTaskServiceState task, String failureMessage) {
        task.failureMessage = failureMessage;
        this.sendSelfPatch(task, TaskState.TaskStage.FAILED, null);
    }

    private void sendSelfPatch(ExampleTaskServiceState task, TaskState.TaskStage stage, SubStage subStage) {
        if (task.taskInfo == null) {
            task.taskInfo = new TaskState();
        }
        task.taskInfo.stage = stage;
        task.subStage = subStage;
        this.sendSelfPatch(task);
    }

    private void sendSelfPatch(ExampleTaskServiceState task) {
        Operation patch = Operation.createPatch(this.getUri()).setBody(task).setCompletion((op, ex) -> {
            if (ex != null) {
                this.logWarning("Failed to send patch, task has failed: %s", ex.getMessage());
            }
        });
        this.sendRequest(patch);
    }

    public static class ExampleTaskServiceState
    extends ServiceDocument {
        @ServiceDocument.UsageOption(option=ServiceDocumentDescription.PropertyUsageOption.AUTO_MERGE_IF_NOT_NULL)
        public Long taskLifetime;
        @ServiceDocument.UsageOption(option=ServiceDocumentDescription.PropertyUsageOption.AUTO_MERGE_IF_NOT_NULL)
        public TaskState taskInfo;
        @ServiceDocument.UsageOption(option=ServiceDocumentDescription.PropertyUsageOption.AUTO_MERGE_IF_NOT_NULL)
        public String failureMessage;
        @ServiceDocument.UsageOption(option=ServiceDocumentDescription.PropertyUsageOption.AUTO_MERGE_IF_NOT_NULL)
        public SubStage subStage;
        @ServiceDocument.UsageOption(option=ServiceDocumentDescription.PropertyUsageOption.AUTO_MERGE_IF_NOT_NULL)
        public QueryTask exampleQueryTask;
    }

    public static enum SubStage {
        QUERY_EXAMPLES,
        DELETE_EXAMPLES;

    }
}

