/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.AuthorizationSetupHelper;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.ExampleFactoryService;
import com.vmware.xenon.services.common.ExampleService;
import com.vmware.xenon.services.common.ExampleTaskFactoryService;
import com.vmware.xenon.services.common.RootNamespaceService;
import java.util.logging.Level;

public class ExampleServiceHost
extends ServiceHost {
    private ExampleHostArguments args;

    public static void main(String[] args) throws Throwable {
        ExampleServiceHost h = new ExampleServiceHost();
        h.initialize(args);
        h.start();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            h.log(Level.WARNING, "Host stopping ...", new Object[0]);
            h.stop();
            h.log(Level.WARNING, "Host is stopped", new Object[0]);
        }));
    }

    @Override
    public ServiceHost initialize(String[] args) throws Throwable {
        this.args = new ExampleHostArguments();
        super.initialize(args, this.args);
        if (this.args.adminUser != null && this.args.adminUserPassword == null) {
            throw new IllegalStateException("adminUser specified, but not adminUserPassword");
        }
        if (this.args.exampleUser != null && this.args.exampleUserPassword == null) {
            throw new IllegalStateException("exampleUser specified, but not exampleUserPassword");
        }
        return this;
    }

    @Override
    public ServiceHost start() throws Throwable {
        super.start();
        this.startDefaultCoreServicesSynchronously();
        this.setAuthorizationContext(this.getSystemAuthorizationContext());
        super.startService(Operation.createPost(UriUtils.buildUri((ServiceHost)this, ExampleFactoryService.class)), new ExampleFactoryService());
        super.startService(Operation.createPost(UriUtils.buildUri((ServiceHost)this, ExampleTaskFactoryService.class)), new ExampleTaskFactoryService());
        super.startService(Operation.createPost(UriUtils.buildUri((ServiceHost)this, RootNamespaceService.class)), new RootNamespaceService());
        if (this.args != null) {
            if (this.args.adminUser != null) {
                AuthorizationSetupHelper.create().setHost(this).setUserEmail(this.args.adminUser).setUserPassword(this.args.adminUserPassword).setIsAdmin(true).start();
            }
            if (this.args.exampleUser != null) {
                AuthorizationSetupHelper.create().setHost(this).setUserEmail(this.args.exampleUser).setUserPassword(this.args.exampleUserPassword).setIsAdmin(false).setDocumentKind(Utils.buildKind(ExampleService.ExampleServiceState.class)).start();
            }
        }
        this.setAuthorizationContext(null);
        return this;
    }

    public static class ExampleHostArguments
    extends ServiceHost.Arguments {
        public String adminUser;
        public String adminUserPassword;
        public String exampleUser;
        public String exampleUserPassword;
    }
}

