/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.OperationProcessingChain;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceConfiguration;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.ServiceStats;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.UtilityService;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.common.jwt.Signer;
import java.net.URI;
import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StatelessService
implements Service {
    private long maintenanceIntervalMicros;
    private OperationProcessingChain opProcessingChain;
    private Service.ProcessingStage stage = Service.ProcessingStage.CREATED;
    private ServiceHost host;
    private String selfLink;
    protected EnumSet<Service.ServiceOption> options = EnumSet.noneOf(Service.ServiceOption.class);
    private UtilityService utilityService;
    protected Class<? extends ServiceDocument> stateType;

    public StatelessService(Class<? extends ServiceDocument> stateType) {
        if (stateType == null) {
            throw new IllegalArgumentException("stateType is required");
        }
        this.stateType = stateType;
        this.options.add(Service.ServiceOption.CONCURRENT_GET_HANDLING);
        this.options.add(Service.ServiceOption.CONCURRENT_UPDATE_HANDLING);
    }

    public StatelessService() {
        this.stateType = ServiceDocument.class;
    }

    @Override
    public void handleStart(Operation startPost) {
        startPost.complete();
    }

    @Override
    public void authorizeRequest(Operation op) {
        ServiceDocument doc = new ServiceDocument();
        doc.documentSelfLink = this.selfLink;
        if (this.getHost().isAuthorized(this, doc, op)) {
            op.complete();
            return;
        }
        op.fail(403);
    }

    @Override
    public boolean queueRequest(Operation op) {
        return false;
    }

    @Override
    public void sendRequest(Operation op) {
        this.prepareRequest(op);
        this.host.sendRequest(op);
    }

    protected void prepareRequest(Operation op) {
        op.setReferer(UriUtils.buildUri(this.getHost().getPublicUri(), this.getSelfLink()));
    }

    @Override
    public void handleRequest(Operation op) {
        this.handleRequest(op, Service.OperationProcessingStage.PROCESSING_FILTERS);
    }

    @Override
    public void handleRequest(Operation op, Service.OperationProcessingStage opProcessingStage) {
        try {
            if (opProcessingStage == Service.OperationProcessingStage.PROCESSING_FILTERS) {
                OperationProcessingChain opProcessingChain = this.getOperationProcessingChain();
                if (opProcessingChain != null && !opProcessingChain.processRequest(op)) {
                    return;
                }
                opProcessingStage = Service.OperationProcessingStage.EXECUTING_SERVICE_HANDLER;
            }
            if (opProcessingStage == Service.OperationProcessingStage.EXECUTING_SERVICE_HANDLER) {
                if (op.getAction() == Service.Action.GET) {
                    op.nestCompletion(o -> this.handleGetCompletion(op));
                    this.handleGet(op);
                } else if (op.getAction() == Service.Action.POST) {
                    this.handlePost(op);
                } else if (op.getAction() == Service.Action.DELETE) {
                    op.nestCompletion(o -> this.handleDeleteCompletion(op));
                    this.handleDelete(op);
                } else if (op.getAction() == Service.Action.OPTIONS) {
                    op.nestCompletion(o -> this.handleOptionsCompletion(op));
                    this.handleOptions(op);
                } else {
                    this.getHost().failRequestActionNotSupported(op);
                }
            }
        }
        catch (Throwable e) {
            op.fail(e);
        }
    }

    public void handleOptions(Operation options) {
        options.setBody(null).complete();
    }

    protected void handleOptionsCompletion(Operation options) {
        if (!options.hasBody()) {
            options.setBodyNoCloning(this.getDocumentTemplate());
        }
        options.complete();
    }

    public void handlePost(Operation post) {
        this.getHost().failRequestActionNotSupported(post);
    }

    public void handleGet(Operation get) {
        get.complete();
    }

    public void handleDelete(Operation delete) {
        delete.complete();
    }

    protected void handleDeleteCompletion(Operation delete) {
        this.getHost().stopService(this);
        delete.complete();
    }

    private void handleGetCompletion(Operation op) {
        if (!this.options.contains((Object)Service.ServiceOption.PERSISTENCE)) {
            op.complete();
            return;
        }
        URI documentQuery = UriUtils.buildDocumentQueryUri(this.getHost(), this.selfLink, true, false, this.options);
        this.sendRequest(Operation.createGet(documentQuery).setCompletion((o, e) -> {
            if (e != null) {
                op.fail(e);
                return;
            }
            op.setBodyNoCloning(o.getBodyRaw()).complete();
        }));
    }

    @Override
    public void handleMaintenance(Operation post) {
        post.complete();
    }

    @Override
    public ServiceHost getHost() {
        return this.host;
    }

    @Override
    public String getSelfLink() {
        return this.selfLink;
    }

    @Override
    public URI getUri() {
        return UriUtils.buildUri(this.host, this.selfLink);
    }

    @Override
    public OperationProcessingChain getOperationProcessingChain() {
        return this.opProcessingChain;
    }

    @Override
    public Service.ProcessingStage getProcessingStage() {
        return this.stage;
    }

    @Override
    public boolean hasOption(Service.ServiceOption cap) {
        return this.options.contains((Object)cap);
    }

    @Override
    public void toggleOption(Service.ServiceOption option, boolean enable) {
        if (enable) {
            if (option == Service.ServiceOption.REPLICATION) {
                throw new IllegalArgumentException("Option is not supported");
            }
            if (option == Service.ServiceOption.ENFORCE_QUORUM) {
                throw new IllegalArgumentException("Option is not supported");
            }
            if (option == Service.ServiceOption.IDEMPOTENT_POST) {
                throw new IllegalArgumentException("Option is not supported");
            }
        }
        if (enable) {
            this.options.add(option);
        } else {
            this.options.remove((Object)option);
        }
    }

    @Override
    public void setStat(String name, double newValue) {
        if (!this.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
            return;
        }
        this.allocateUtilityService();
        ServiceStats.ServiceStat s = this.getStat(name);
        this.utilityService.setStat(s, newValue);
    }

    @Override
    public void setStat(ServiceStats.ServiceStat s, double newValue) {
        if (!this.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
            return;
        }
        this.allocateUtilityService();
        this.utilityService.setStat(s, newValue);
    }

    @Override
    public void adjustStat(ServiceStats.ServiceStat s, double delta) {
        if (!this.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
            return;
        }
        this.allocateUtilityService();
        this.utilityService.adjustStat(s, delta);
    }

    @Override
    public void adjustStat(String name, double delta) {
        if (!this.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
            return;
        }
        this.allocateUtilityService();
        ServiceStats.ServiceStat s = this.getStat(name);
        this.utilityService.adjustStat(s, delta);
    }

    @Override
    public ServiceStats.ServiceStat getStat(String name) {
        if (!this.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
            return null;
        }
        this.allocateUtilityService();
        return this.utilityService.getStat(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceStats.ServiceStat getHistogramStat(String name) {
        ServiceStats.ServiceStat s;
        if (!this.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
            return null;
        }
        ServiceStats.ServiceStat serviceStat = s = this.getStat(name);
        synchronized (serviceStat) {
            if (s.logHistogram == null) {
                s.logHistogram = new ServiceStats.ServiceStatLogHistogram();
            }
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean allocateUtilityService() {
        EnumSet<Service.ServiceOption> enumSet = this.options;
        synchronized (enumSet) {
            if (this.utilityService == null) {
                this.utilityService = new UtilityService().setParent(this);
            }
        }
        return true;
    }

    @Override
    public void setHost(ServiceHost serviceHost) {
        this.host = serviceHost;
    }

    @Override
    public void setSelfLink(String path) {
        this.selfLink = path != null ? path.intern() : null;
    }

    @Override
    public void setOperationProcessingChain(OperationProcessingChain opProcessingChain) {
        this.opProcessingChain = opProcessingChain;
    }

    @Override
    public void setProcessingStage(Service.ProcessingStage stage) {
        if (this.stage == stage) {
            return;
        }
        this.stage = stage;
        if (stage != Service.ProcessingStage.AVAILABLE) {
            return;
        }
        this.getHost().notifyServiceAvailabilitySubscribers(this);
    }

    @Override
    public ServiceDocument setInitialState(String jsonState, Long version) {
        ServiceDocument d = Utils.fromJson(jsonState, this.stateType);
        if (version != null) {
            d.documentVersion = version;
        }
        return d;
    }

    @Override
    public Service getUtilityService(String uriPath) {
        this.allocateUtilityService();
        return this.utilityService;
    }

    @Override
    public ServiceDocument getDocumentTemplate() {
        ServiceDocument d;
        try {
            d = this.stateType.newInstance();
        }
        catch (Throwable e) {
            this.logSevere(e);
            return null;
        }
        d.documentDescription = this.getHost().buildDocumentDescription(this);
        return d;
    }

    public void logSevere(Throwable e) {
        this.log(Level.SEVERE, "%s", Utils.toString(e));
    }

    public void logSevere(String fmt, Object ... args) {
        this.log(Level.SEVERE, fmt, args);
    }

    public void logInfo(String fmt, Object ... args) {
        this.log(Level.INFO, fmt, args);
    }

    public void logFine(String fmt, Object ... args) {
        this.log(Level.FINE, fmt, args);
    }

    public void logWarning(String fmt, Object ... args) {
        this.log(Level.WARNING, fmt, args);
    }

    protected void log(Level level, String fmt, Object ... args) {
        String uri = this.host != null && this.selfLink != null ? this.getUri().toString() : this.getClass().getSimpleName();
        Logger lg = Logger.getLogger(this.getClass().getName());
        Utils.log(lg, 3, uri, level, fmt, args);
    }

    @Override
    public void setPeerNodeSelectorPath(String uriPath) {
        throw new RuntimeException("Replication is not supported");
    }

    @Override
    public String getPeerNodeSelectorPath() {
        throw new RuntimeException("Replication is not supported");
    }

    @Override
    public EnumSet<Service.ServiceOption> getOptions() {
        return this.options.clone();
    }

    public void publish(Operation op) {
        UtilityService u = this.utilityService;
        if (u == null) {
            return;
        }
        u.notifySubscribers(op);
    }

    @Override
    public void setState(Operation op, ServiceDocument state) {
        op.linkState(state);
    }

    @Override
    public <T extends ServiceDocument> T getState(Operation op) {
        return (T)op.getLinkedState();
    }

    @Override
    public void setMaintenanceIntervalMicros(long micros) {
        if (micros < 0L) {
            throw new IllegalArgumentException("micros must be positive");
        }
        this.maintenanceIntervalMicros = micros;
    }

    @Override
    public long getMaintenanceIntervalMicros() {
        return this.maintenanceIntervalMicros;
    }

    @Override
    public Operation dequeueRequest() {
        return null;
    }

    @Override
    public Class<? extends ServiceDocument> getStateType() {
        return this.stateType;
    }

    @Override
    public void handleConfigurationRequest(Operation request) {
        if (request.getAction() == Service.Action.PATCH) {
            this.allocateUtilityService();
            this.utilityService.handlePatchConfiguration(request, null);
            return;
        }
        if (request.getAction() != Service.Action.GET) {
            request.fail(new IllegalArgumentException("Action not supported: " + (Object)((Object)request.getAction())));
            return;
        }
        ServiceConfiguration cfg = new ServiceConfiguration();
        cfg.options = this.getOptions();
        cfg.maintenanceIntervalMicros = this.getMaintenanceIntervalMicros();
        request.setBody(cfg).complete();
    }

    public final void setAuthorizationContext(Operation op, Operation.AuthorizationContext ctx) {
        if (!this.getHost().isPrivilegedService(this)) {
            throw new RuntimeException("Service not allowed to set authorization context");
        }
        op.setAuthorizationContext(ctx);
    }

    public final Signer getTokenSigner() {
        if (this.getHost().isPrivilegedService(this)) {
            return this.getHost().getTokenSigner();
        }
        throw new RuntimeException("Service not allowed to get token signer");
    }

    public final Operation.AuthorizationContext getSystemAuthorizationContext() {
        if (this.getHost().isPrivilegedService(this)) {
            return this.getHost().getSystemAuthorizationContext();
        }
        throw new RuntimeException("Service not allowed to get system authorization context");
    }
}

