/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.NodeSelectorService;
import com.vmware.xenon.common.ODataQueryVisitor;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.OperationProcessingChain;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceDocumentQueryResult;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.ServiceMaintenanceRequest;
import com.vmware.xenon.common.StatelessService;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.QueryTask;
import com.vmware.xenon.services.common.ServiceUriPaths;
import java.net.URI;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class FactoryService
extends StatelessService {
    public static final int SELF_QUERY_RESULT_LIMIT = 1000;
    private static final long SELF_QUERY_TIMEOUT_MINUTES = 60L;
    private EnumSet<Service.ServiceOption> childOptions;
    private String nodeSelectorLink = "/core/node-selectors/default";
    private int selfQueryResultLimit = 1000;

    public FactoryService(Class<? extends ServiceDocument> childServiceDocumentType) {
        super(childServiceDocumentType);
        super.toggleOption(Service.ServiceOption.FACTORY, true);
        this.setSelfLink("");
        Service s = this.createChildServiceSafe();
        if (s == null) {
            throw new IllegalStateException("Could not create service of type " + childServiceDocumentType.toString());
        }
        this.setSelfLink(null);
        this.childOptions = s.getOptions();
    }

    public void setSelfQueryResultLimit(int limit) {
        this.selfQueryResultLimit = limit;
    }

    public int getSelfQueryResultLimit() {
        return this.selfQueryResultLimit;
    }

    @Override
    public final void handleStart(Operation startPost) {
        try {
            Service s = this.createChildService();
            s.setHost(this.getHost());
            this.getHost().buildDocumentDescription(s);
            if (this.childOptions.contains((Object)Service.ServiceOption.PERSISTENCE)) {
                this.toggleOption(Service.ServiceOption.PERSISTENCE, true);
            }
            Class<? extends ServiceDocument> childStateTypeDeclaredInChild = s.getStateType();
            if (!this.getStateType().equals(childStateTypeDeclaredInChild)) {
                throw new IllegalArgumentException(String.format("Child service state type %s does not match state type declared in child service class (%s)", this.getStateType(), childStateTypeDeclaredInChild));
            }
            if (s.hasOption(Service.ServiceOption.PERSISTENCE)) {
                byte[] buffer = new byte[8192];
                Utils.toBytes(s, buffer, 0);
            }
        }
        catch (Throwable e2) {
            this.logSevere(e2);
            startPost.fail(e2);
            return;
        }
        if (!ServiceHost.isServiceIndexed(this)) {
            startPost.complete();
            return;
        }
        Operation clonedOp = startPost.clone();
        startPost.complete();
        clonedOp.setCompletion((o, e) -> {
            if (e != null && !this.getHost().isStopping()) {
                this.logWarning("Failure querying index for all child services: %s", e.getMessage());
                return;
            }
            this.logFine("Finished self query for child services", new Object[0]);
        });
        if (this.childOptions.contains((Object)Service.ServiceOption.ON_DEMAND_LOAD)) {
            return;
        }
        this.startOrSynchronizeChildServices(clonedOp);
    }

    private void startOrSynchronizeChildServices(Operation op) {
        QueryTask queryTask = this.buildChildQueryTask();
        this.queryForChildren(queryTask, UriUtils.buildUri(this.getHost(), ServiceUriPaths.CORE_LOCAL_QUERY_TASKS), op);
    }

    protected void queryForChildren(QueryTask queryTask, URI queryFactoryUri, Operation parentOperation) {
        Operation queryPost = Operation.createPost(queryFactoryUri).setBody(queryTask).setCompletion((o, e) -> {
            if (this.getHost().isStopping()) {
                parentOperation.fail(new CancellationException("host is stopping"));
                return;
            }
            if (e != null) {
                if (this.getHost().isStopping()) {
                    parentOperation.fail(e);
                    return;
                }
                this.logSevere(e);
                parentOperation.complete();
                return;
            }
            ServiceDocumentQueryResult rsp = o.getBody(QueryTask.class).results;
            if (rsp.nextPageLink == null) {
                parentOperation.complete();
                return;
            }
            this.processChildQueryPage(UriUtils.buildUri(queryFactoryUri, rsp.nextPageLink), queryTask, parentOperation);
        });
        this.sendRequest(queryPost);
    }

    private QueryTask buildChildQueryTask() {
        QueryTask queryTask = new QueryTask();
        queryTask.querySpec = new QueryTask.QuerySpecification();
        queryTask.taskInfo.isDirect = true;
        QueryTask.Query uriPrefixClause = new QueryTask.Query().setTermPropertyName("documentSelfLink").setTermMatchType(QueryTask.QueryTerm.MatchType.WILDCARD).setTermMatchValue(this.getSelfLink() + "/" + "*");
        queryTask.querySpec.query.addBooleanClause(uriPrefixClause);
        QueryTask.Query kindClause = new QueryTask.Query().setTermPropertyName("documentKind").setTermMatchValue(Utils.buildKind(this.getStateType()));
        queryTask.querySpec.query.addBooleanClause(kindClause);
        long timeoutMicros = TimeUnit.MINUTES.toMicros(60L);
        timeoutMicros = Math.max(timeoutMicros, this.getHost().getOperationTimeoutMicros());
        queryTask.documentExpirationTimeMicros = Utils.getNowMicrosUtc() + timeoutMicros;
        queryTask.querySpec.resultLimit = this.selfQueryResultLimit;
        return queryTask;
    }

    private void processChildQueryPage(URI queryPage, QueryTask queryTask, Operation parentOp) {
        if (queryPage == null) {
            parentOp.complete();
            return;
        }
        if (this.getHost().isStopping()) {
            parentOp.fail(new CancellationException());
            return;
        }
        this.sendRequest(Operation.createGet(queryPage).setCompletion((o, e) -> {
            if (e != null) {
                if (!this.getHost().isStopping()) {
                    this.logWarning("Failure retrieving query results from %s: %s", queryPage, e.toString());
                }
                parentOp.complete();
                return;
            }
            ServiceDocumentQueryResult rsp = o.getBody(QueryTask.class).results;
            if (rsp.documentCount == 0L || rsp.documentLinks.isEmpty()) {
                parentOp.complete();
                return;
            }
            this.synchronizeChildrenInQueryPage(queryPage, queryTask, parentOp, rsp);
        }));
    }

    private void synchronizeChildrenInQueryPage(URI queryPage, QueryTask queryTask, Operation parentOp, ServiceDocumentQueryResult rsp) {
        AtomicInteger pendingStarts = new AtomicInteger(rsp.documentLinks.size());
        Operation.CompletionHandler c = (so, se) -> {
            int r = pendingStarts.decrementAndGet();
            if (se != null && this.getHost().isStopping()) {
                this.logWarning("Restart for children failed: %s", se.getMessage());
            }
            if (this.getHost().isStopping()) {
                parentOp.fail(new CancellationException());
                return;
            }
            if (r != 0) {
                return;
            }
            URI nextQueryPage = rsp.nextPageLink == null ? null : UriUtils.buildUri(queryPage, rsp.nextPageLink);
            this.processChildQueryPage(nextQueryPage, queryTask, parentOp);
        };
        for (String link : rsp.documentLinks) {
            if (this.getHost().isStopping()) {
                parentOp.fail(new CancellationException());
                return;
            }
            Operation post = Operation.createPost(this, link).setCompletion(c).setReferer(this.getUri());
            this.startOrSynchChildService(link, post);
        }
    }

    private void startOrSynchChildService(String link, Operation post) {
        try {
            Service child = this.createChildService();
            post.addPragmaDirective("xn-check-version");
            this.getHost().startOrSynchService(post, child);
        }
        catch (Throwable e1) {
            post.fail(e1);
        }
    }

    @Override
    public void authorizeRequest(Operation op) {
        op.complete();
    }

    @Override
    public void handleRequest(Operation op) {
        this.handleRequest(op, Service.OperationProcessingStage.PROCESSING_FILTERS);
    }

    @Override
    public void handleRequest(Operation op, Service.OperationProcessingStage opProcessingStage) {
        if (op.getAction() == Service.Action.POST) {
            if (opProcessingStage == Service.OperationProcessingStage.PROCESSING_FILTERS) {
                OperationProcessingChain opProcessingChain = this.getOperationProcessingChain();
                if (opProcessingChain != null && !opProcessingChain.processRequest(op)) {
                    return;
                }
                opProcessingStage = Service.OperationProcessingStage.EXECUTING_SERVICE_HANDLER;
            }
            if (opProcessingStage == Service.OperationProcessingStage.EXECUTING_SERVICE_HANDLER) {
                op.nestCompletion((o, e) -> {
                    if (e != null) {
                        this.logWarning("Service start failed: %s", Utils.toString(e));
                        op.fail(e);
                        return;
                    }
                    this.handlePostCompletion(op);
                });
                this.handlePost(op);
            }
        } else if (op.getAction() == Service.Action.GET) {
            if (this.getProcessingStage() != Service.ProcessingStage.AVAILABLE) {
                op.setBody(new ServiceDocumentQueryResult()).complete();
                return;
            }
            op.nestCompletion(o -> this.handleGetCompletion((Operation)o));
            this.handleGet(op);
        } else if (op.getAction() == Service.Action.DELETE) {
            op.nestCompletion(o -> this.handleDeleteCompletion((Operation)o));
            this.handleDelete(op);
        } else if (op.getAction() == Service.Action.OPTIONS) {
            op.nestCompletion(o -> this.handleOptionsCompletion((Operation)o));
            this.handleOptions(op);
        } else {
            op.fail(new IllegalArgumentException("Action not supported"));
        }
    }

    private void handlePostCompletion(Operation o) {
        Service childService;
        if (o.getStatusCode() == 202) {
            o.complete();
            return;
        }
        ServiceDocument initialState = null;
        try {
            childService = this.createChildService();
            if (o.hasBody()) {
                initialState = (ServiceDocument)o.getBody(this.stateType);
                initialState = Utils.clone(initialState);
            }
            String suffix = null;
            if (initialState == null) {
                suffix = UUID.randomUUID().toString();
                initialState = new ServiceDocument();
            } else {
                suffix = initialState.documentSelfLink == null ? UUID.randomUUID().toString() : initialState.documentSelfLink;
            }
            URI serviceUri = UriUtils.isChildPath(suffix, this.getSelfLink()) ? UriUtils.buildUri(this.getHost(), suffix) : UriUtils.extendUri(this.getUri(), suffix);
            o.setUri(serviceUri);
        }
        catch (Throwable e) {
            this.logSevere(e);
            o.fail(e);
            return;
        }
        initialState.documentSelfLink = o.getUri().getPath();
        initialState.documentKind = Utils.buildKind(this.stateType);
        initialState.documentTransactionId = o.getTransactionId();
        o.setBody(initialState);
        if (this.childOptions.contains((Object)Service.ServiceOption.OWNER_SELECTION) && !o.isFromReplication() && !o.isForwardingDisabled()) {
            this.forwardRequest(o, childService);
            return;
        }
        this.completePostRequest(o, childService);
    }

    private void completePostRequest(Operation o, Service childService) {
        if (this.getHost().getServiceStage(o.getUri().getPath()) != null) {
            this.handleServiceExistsPostCompletion(o);
            return;
        }
        if (!o.isFromReplication() && !o.isReplicationDisabled()) {
            o.nestCompletion(startOp -> {
                this.publish(o);
                if (!this.hasOption(Service.ServiceOption.REPLICATION)) {
                    o.complete();
                    return;
                }
                o.setReplicationDisabled(false);
                this.replicateRequest(o);
            });
        }
        o.setReplicationDisabled(true);
        this.getHost().startService(o, childService);
    }

    private void forwardRequest(Operation o, Service childService) {
        Operation selectOp = Operation.createPost(null).setExpiration(o.getExpirationMicrosUtc()).setCompletion((so, se) -> {
            if (se != null) {
                o.fail(se);
                return;
            }
            if (!so.hasBody()) {
                throw new IllegalStateException();
            }
            NodeSelectorService.SelectOwnerResponse rsp = so.getBody(NodeSelectorService.SelectOwnerResponse.class);
            ServiceDocument initialState = (ServiceDocument)o.getBodyRaw();
            initialState.documentOwner = rsp.ownerNodeId;
            if (rsp.isLocalHostOwner) {
                this.completePostRequest(o, childService);
                return;
            }
            URI remotePeerService = NodeSelectorService.SelectOwnerResponse.buildUriToOwner(rsp, this.getSelfLink(), null);
            Operation.CompletionHandler fc = (fo, fe) -> {
                o.setBodyNoCloning(fo.getBodyRaw());
                o.setStatusCode(fo.getStatusCode());
                o.transferResponseHeadersFrom(fo);
                if (fe != null) {
                    o.fail(fe);
                    return;
                }
                o.complete();
            };
            Operation forwardOp = o.clone().setUri(remotePeerService).setCompletion(fc);
            initialState.documentSelfLink = initialState.documentSelfLink.replace(this.getSelfLink(), "");
            this.getHost().sendRequest(forwardOp);
        });
        this.getHost().selectOwner(this.getPeerNodeSelectorPath(), o.getUri().getPath(), selectOp);
    }

    public void handleServiceExistsPostCompletion(Operation o) {
        if (!this.hasOption(Service.ServiceOption.IDEMPOTENT_POST)) {
            o.setStatusCode(409).fail(new ServiceHost.ServiceAlreadyStartedException(o.getUri().toString()));
            return;
        }
        this.logInfo("Converting POST to PUT, service already exists: %s", o.getUri());
        Operation put = o.clone().setAction(Service.Action.PUT).setCompletion((op, ex) -> {
            if (ex != null) {
                o.fail(ex);
            } else {
                o.transferResponseHeadersFrom(op).setBodyNoCloning(op.getBodyRaw()).setStatusCode(op.getStatusCode()).complete();
            }
        });
        this.sendRequest(put);
    }

    @Override
    public void handleGet(Operation get) {
        get.complete();
    }

    private void handleGetCompletion(Operation op) {
        String oDataFilter = UriUtils.getODataFilterParamValue(op.getUri());
        if (oDataFilter != null) {
            this.handleGetOdataCompletion(op, oDataFilter);
        } else {
            FactoryService.completeGetWithQuery(this, op, this.childOptions);
        }
    }

    private void handleGetOdataCompletion(Operation op, String oDataFilter) {
        QueryTask task = new QueryTask().setDirect(true);
        task.querySpec = new QueryTask.QuerySpecification();
        if (op.getUri().getQuery().contains("expand")) {
            task.querySpec.options = EnumSet.of(QueryTask.QuerySpecification.QueryOption.EXPAND_CONTENT);
        }
        String kind = Utils.buildKind(this.getStateType());
        QueryTask.Query kindClause = new QueryTask.Query().setTermPropertyName("documentKind").setTermMatchValue(kind);
        task.querySpec.query.addBooleanClause(kindClause);
        QueryTask.Query oDataFilterClause = new ODataQueryVisitor().toQuery(oDataFilter);
        task.querySpec.query.addBooleanClause(oDataFilterClause);
        this.sendRequest(Operation.createPost(this, ServiceUriPaths.CORE_QUERY_TASKS).setBody(task).setCompletion((o, e) -> {
            if (e != null) {
                op.fail(e);
                return;
            }
            QueryTask qrt = o.getBody(QueryTask.class);
            op.setBodyNoCloning(qrt.results).complete();
        }));
    }

    public static void completeGetWithQuery(Service s, Operation op, EnumSet<Service.ServiceOption> caps) {
        boolean doExpand = false;
        if (op.getUri().getQuery() != null) {
            doExpand = op.getUri().getQuery().contains("expand");
        }
        URI u = UriUtils.buildDocumentQueryUri(s.getHost(), UriUtils.buildUriPath(s.getSelfLink(), "*"), doExpand, false, caps != null ? caps : EnumSet.of(Service.ServiceOption.NONE));
        Operation query = Operation.createGet(u).setCompletion((o, e) -> {
            if (e != null) {
                op.fail(e);
                return;
            }
            op.setBodyNoCloning(o.getBodyRaw()).complete();
        });
        s.sendRequest(query);
    }

    @Override
    public void handleOptions(Operation op) {
        op.setBody(null).complete();
    }

    @Override
    public void handlePost(Operation op) {
        if (op.hasBody()) {
            ServiceDocument body = op.getBody(ServiceDocument.class);
            if (body == null) {
                op.fail(new IllegalArgumentException("structured body is required"));
                return;
            }
            if (body.documentSourceLink != null) {
                op.fail(new IllegalArgumentException("clone request not supported"));
                return;
            }
        }
        op.complete();
    }

    private Service createChildService() throws Throwable {
        Service childService = this.createServiceInstance();
        this.childOptions = childService.getOptions();
        if (childService.hasOption(Service.ServiceOption.REPLICATION)) {
            this.toggleOption(Service.ServiceOption.REPLICATION, true);
            if (!"/core/node-selectors/default".equals(childService.getPeerNodeSelectorPath())) {
                this.nodeSelectorLink = childService.getPeerNodeSelectorPath();
            } else if (!"/core/node-selectors/default".equals(this.nodeSelectorLink)) {
                childService.setPeerNodeSelectorPath(this.nodeSelectorLink);
            }
        }
        if (childService.hasOption(Service.ServiceOption.ON_DEMAND_LOAD)) {
            this.toggleOption(Service.ServiceOption.ON_DEMAND_LOAD, true);
        }
        if (childService.hasOption(Service.ServiceOption.HTML_USER_INTERFACE)) {
            this.toggleOption(Service.ServiceOption.HTML_USER_INTERFACE, true);
        }
        childService.toggleOption(Service.ServiceOption.FACTORY_ITEM, true);
        return childService;
    }

    private Service createChildServiceSafe() {
        try {
            return this.createChildService();
        }
        catch (Throwable e) {
            this.logSevere(e);
            return null;
        }
    }

    @Override
    public void toggleOption(Service.ServiceOption option, boolean enable) {
        if (!enable) {
            this.options.remove((Object)option);
        } else {
            this.options.add(option);
        }
    }

    @Override
    public String getPeerNodeSelectorPath() {
        return this.nodeSelectorLink;
    }

    @Override
    public void setPeerNodeSelectorPath(String link) {
        this.nodeSelectorLink = link;
    }

    private void replicateRequest(Operation op) {
        op.setUri(this.getUri());
        ServiceDocument initialState = (ServiceDocument)op.getBody(this.stateType);
        ServiceDocument clonedInitState = Utils.clone(initialState);
        String originalLink = clonedInitState.documentSelfLink;
        clonedInitState.documentSelfLink = clonedInitState.documentSelfLink.replace(this.getSelfLink(), "");
        op.nestCompletion(replicatedOp -> {
            clonedInitState.documentSelfLink = originalLink;
            op.linkState(null).setBodyNoCloning(clonedInitState).complete();
        });
        this.getHost().replicateRequest(this.options, clonedInitState, this.getPeerNodeSelectorPath(), originalLink, op);
    }

    @Override
    public ServiceDocument getDocumentTemplate() {
        try {
            ServiceDocumentQueryResult r = new ServiceDocumentQueryResult();
            Service s = this.createServiceInstance();
            s.setHost(this.getHost());
            ServiceDocument childTemplate = s.getDocumentTemplate();
            r.documents = new HashMap<String, Object>();
            childTemplate.documentSelfLink = UriUtils.buildUriPath(this.getSelfLink(), "child-template");
            r.documentLinks.add(childTemplate.documentSelfLink);
            r.documents.put(childTemplate.documentSelfLink, childTemplate);
            return r;
        }
        catch (Throwable e) {
            this.logSevere(e);
            return null;
        }
    }

    @Override
    public void handleMaintenance(Operation maintOp) {
        ServiceMaintenanceRequest body = maintOp.getBody(ServiceMaintenanceRequest.class);
        if (!body.reasons.contains((Object)ServiceMaintenanceRequest.MaintenanceReason.NODE_GROUP_CHANGE)) {
            maintOp.complete();
            return;
        }
        if (!this.hasOption(Service.ServiceOption.REPLICATION)) {
            maintOp.complete();
            return;
        }
        this.startOrSynchronizeChildServices(maintOp);
    }

    public abstract Service createServiceInstance() throws Throwable;
}

