/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.http.netty;

import com.vmware.xenon.common.Operation;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;

public class NettyFullHttpRequest
extends DefaultFullHttpRequest {
    private Operation operation;

    public NettyFullHttpRequest(HttpVersion httpVersion, HttpMethod method, String uri) {
        super(httpVersion, method, uri);
    }

    public NettyFullHttpRequest(HttpVersion httpVersion, HttpMethod method, String uri, ByteBuf content) {
        super(httpVersion, method, uri, content);
    }

    public NettyFullHttpRequest(HttpVersion httpVersion, HttpMethod method, String uri, ByteBuf content, boolean validateHeaders) {
        super(httpVersion, method, uri, content, validateHeaders);
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public Operation getOperation() {
        return this.operation;
    }

    private FullHttpRequest copy(boolean copyContent, ByteBuf newContent) {
        NettyFullHttpRequest copy = new NettyFullHttpRequest(this.protocolVersion(), this.method(), this.uri(), copyContent ? this.content().copy() : (newContent == null ? Unpooled.buffer((int)0) : newContent));
        copy.headers().set(this.headers());
        copy.trailingHeaders().set(this.trailingHeaders());
        return copy;
    }

    public FullHttpRequest copy(ByteBuf newContent) {
        return this.copy(false, newContent);
    }

    public FullHttpRequest copy() {
        return this.copy(true, null);
    }

    public FullHttpRequest duplicate() {
        NettyFullHttpRequest duplicate = new NettyFullHttpRequest(this.protocolVersion(), this.method(), this.uri(), this.content().duplicate());
        duplicate.headers().set(this.headers());
        duplicate.trailingHeaders().set(this.trailingHeaders());
        return duplicate;
    }

    public boolean equals(Object other) {
        if (!(other instanceof NettyFullHttpRequest)) {
            return false;
        }
        return super.equals(other);
    }
}

