/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.OperationJoin;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceClient;
import com.vmware.xenon.common.ServiceHost;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class OperationSequence {
    private final OperationJoin join;
    private volatile OperationSequence child;
    private volatile OperationSequence parent;
    private volatile Object sender;
    private volatile boolean cumulative = true;

    private OperationSequence(OperationJoin join) {
        this.join = join;
    }

    public static OperationSequence create(OperationJoin ... joins) {
        if (joins.length == 0) {
            throw new IllegalArgumentException("At least one 'operationJoin' is required.");
        }
        OperationSequence sequence = null;
        for (OperationJoin join : joins) {
            OperationSequence current = new OperationSequence(join);
            if (sequence != null) {
                sequence.child = current;
                current.parent = sequence;
            }
            sequence = current;
        }
        return sequence;
    }

    public static OperationSequence create(Operation ... ops) {
        return OperationSequence.create(OperationJoin.create(ops));
    }

    public OperationSequence next(OperationJoin ... joins) {
        OperationSequence sequence = this;
        for (OperationJoin join : joins) {
            OperationSequence current;
            sequence.child = current = new OperationSequence(join);
            current.parent = sequence;
            sequence = current;
        }
        return sequence;
    }

    public OperationSequence next(Operation ... ops) {
        return this.next(OperationJoin.create(ops));
    }

    public OperationSequence setCompletion(OperationJoin.JoinedCompletionHandler joinedCompletion) {
        return this.setCompletion(true, joinedCompletion);
    }

    public OperationSequence setCompletion(boolean cumulative, OperationJoin.JoinedCompletionHandler joinedCompletion) {
        this.cumulative = cumulative;
        this.join.setCompletion(joinedCompletion);
        return this;
    }

    public void sendWith(ServiceHost host) {
        if (this.parent != null) {
            this.parent.sendWith(host);
        } else {
            this.send(host);
        }
    }

    public void sendWith(Service service) {
        if (this.parent != null) {
            this.parent.sendWith(service);
        } else {
            this.send(service);
        }
    }

    public void sendWith(ServiceClient client) {
        if (this.parent != null) {
            this.parent.sendWith(client);
        } else {
            this.send(client);
        }
    }

    private void send(Object sender) {
        this.validateSendRequest(sender);
        this.sender = sender;
        this.setProxyCompletion();
        if (sender instanceof Service) {
            this.join.sendWith((Service)sender);
        } else if (sender instanceof ServiceHost) {
            this.join.sendWith((ServiceHost)sender);
        } else {
            this.join.sendWith((ServiceClient)sender);
        }
    }

    private void setProxyCompletion() {
        this.join.setCompletion(new CompletionHandlerSequenceProxy(this, this.join.joinedCompletion));
    }

    private Map<Long, Operation> getAllCompletedOperations() {
        ConcurrentHashMap<Long, Operation> operations = new ConcurrentHashMap<Long, Operation>();
        OperationSequence current = this;
        while (current != null) {
            for (Operation op : current.join.getOperations()) {
                operations.put(op.getId(), op);
            }
            current = current.parent;
        }
        return operations;
    }

    private Map<Long, Throwable> getAllFailures() {
        Map<Long, Throwable> failures = null;
        OperationSequence current = this;
        while (current != null) {
            Map<Long, Throwable> currentFailures = current.join.getFailures();
            if (currentFailures != null) {
                if (failures == null) {
                    failures = currentFailures;
                } else {
                    failures.putAll(currentFailures);
                }
            }
            current = current.parent;
        }
        return failures;
    }

    private void validateSendRequest(Object sender) {
        if (sender == null) {
            throw new IllegalArgumentException("'sender' must not be null.");
        }
        if (this.join == null) {
            throw new IllegalStateException("No joined operation to be sent.");
        }
    }

    private static class CompletionHandlerSequenceProxy
    implements OperationJoin.JoinedCompletionHandler {
        private final OperationJoin.JoinedCompletionHandler joinedCompletionHandler;
        private final OperationSequence sequence;
        private final AtomicBoolean completed;

        private CompletionHandlerSequenceProxy(OperationSequence sequence, OperationJoin.JoinedCompletionHandler joinedCompletionHandler) {
            this.sequence = sequence;
            this.joinedCompletionHandler = joinedCompletionHandler;
            this.completed = new AtomicBoolean();
        }

        @Override
        public void handle(Map<Long, Operation> ops, Map<Long, Throwable> failures) {
            if (!this.completed.compareAndSet(false, true)) {
                return;
            }
            AtomicBoolean errors = new AtomicBoolean();
            if (this.joinedCompletionHandler != null) {
                if (this.sequence.cumulative) {
                    Map allOps = this.sequence.getAllCompletedOperations();
                    Map allFailures = this.sequence.getAllFailures();
                    this.joinedCompletionHandler.handle(allOps, allFailures);
                    errors.set(allFailures != null && !allFailures.isEmpty());
                } else {
                    this.joinedCompletionHandler.handle(ops, failures);
                    errors.set(failures != null && !failures.isEmpty());
                }
            }
            if (this.sequence.child != null && !errors.get()) {
                try {
                    this.sequence.child.send(this.sequence.sender);
                }
                catch (Throwable t) {
                    this.sequence.child.join.fail(t);
                }
            }
        }
    }
}

