/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.serialization;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.vmware.xenon.common.serialization.ByteArrayToBase64TypeAdapter;
import com.vmware.xenon.common.serialization.InstantConverter;
import com.vmware.xenon.common.serialization.ObjectMapTypeConverter;
import com.vmware.xenon.common.serialization.RequestRouteConverter;
import com.vmware.xenon.common.serialization.ZonedDateTimeConverter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.function.Consumer;

public class JsonMapper {
    private final Gson compact;
    private final Gson pretty;

    public JsonMapper() {
        this(JsonMapper.createDefaultGson(true), JsonMapper.createDefaultGson(false));
    }

    public JsonMapper(Consumer<GsonBuilder> gsonConfigCallback) {
        this(JsonMapper.createCustomGson(true, gsonConfigCallback), JsonMapper.createCustomGson(false, gsonConfigCallback));
    }

    public JsonMapper(Gson compact, Gson pretty) {
        this.compact = compact;
        this.pretty = pretty;
    }

    public String toJson(Object body) {
        if (body instanceof String) {
            return (String)body;
        }
        return this.compact.toJson(body);
    }

    public void toJson(Object body, Appendable appendable) {
        if (body instanceof String) {
            try {
                appendable.append(body.toString());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.compact.toJson(body, appendable);
    }

    public String toJsonHtml(Object body) {
        return this.pretty.toJson(body);
    }

    public <T> T fromJson(Object json, Class<T> clazz) {
        if (clazz.isInstance(json)) {
            return clazz.cast(json);
        }
        return this.fromJson(json, (Type)clazz);
    }

    public <T> T fromJson(Object json, Type type) {
        if (json instanceof JsonElement) {
            return (T)this.compact.fromJson((JsonElement)json, type);
        }
        return (T)this.compact.fromJson(json.toString(), type);
    }

    private static Gson createDefaultGson(boolean isCompact) {
        return JsonMapper.createDefaultGsonBuilder(isCompact).create();
    }

    private static Gson createCustomGson(boolean isCompact, Consumer<GsonBuilder> gsonConfigCallback) {
        GsonBuilder bldr = JsonMapper.createDefaultGsonBuilder(isCompact);
        gsonConfigCallback.accept(bldr);
        return bldr.create();
    }

    public static GsonBuilder createDefaultGsonBuilder(boolean isCompact) {
        GsonBuilder bldr = new GsonBuilder();
        JsonMapper.registerCommonGsonTypeAdapters(bldr);
        if (isCompact) {
            bldr.disableHtmlEscaping();
        } else {
            bldr.setPrettyPrinting();
        }
        return bldr;
    }

    private static void registerCommonGsonTypeAdapters(GsonBuilder bldr) {
        bldr.registerTypeAdapter(ObjectMapTypeConverter.TYPE, (Object)ObjectMapTypeConverter.INSTANCE);
        bldr.registerTypeAdapter(InstantConverter.TYPE, (Object)InstantConverter.INSTANCE);
        bldr.registerTypeAdapter(ZonedDateTimeConverter.TYPE, (Object)ZonedDateTimeConverter.INSTANCE);
        bldr.registerTypeHierarchyAdapter(byte[].class, (Object)new ByteArrayToBase64TypeAdapter());
        bldr.registerTypeAdapter(RequestRouteConverter.TYPE, (Object)RequestRouteConverter.INSTANCE);
    }
}

