/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.http.netty;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceClient;
import com.vmware.xenon.common.ServiceErrorResponse;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.common.http.netty.CookieJar;
import com.vmware.xenon.common.http.netty.HttpRequestCallbackService;
import com.vmware.xenon.common.http.netty.NettyChannelContext;
import com.vmware.xenon.common.http.netty.NettyChannelPool;
import com.vmware.xenon.common.http.netty.NettyFullHttpRequest;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.ClientCookieDecoder;
import io.netty.handler.codec.http.Cookie;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;

public class NettyHttpServiceClient
implements ServiceClient {
    public static final int DEFAULT_CONNECTIONS_PER_HOST = 128;
    public static final int DEFAULT_HTTP2_STREAMS_PER_HOST = 1024;
    public static final Logger LOGGER = Logger.getLogger(ServiceClient.class.getName());
    private static final String ENV_VAR_NAME_HTTP_PROXY = "http_proxy";
    private static final int DEFAULT_EVENT_LOOP_THREAD_COUNT = 2;
    private URI httpProxy;
    private String userAgent;
    private NettyChannelPool sslChannelPool;
    private NettyChannelPool channelPool;
    private NettyChannelPool http2ChannelPool;
    private ScheduledExecutorService scheduledExecutor;
    private ExecutorService executor;
    private SSLContext sslContext;
    private ServiceHost host;
    private HttpRequestCallbackService callbackService;
    CookieJar cookieJar = new CookieJar();
    private boolean isStarted;

    public static ServiceClient create(String userAgent, ExecutorService executor, ScheduledExecutorService scheduledExecutor) throws URISyntaxException {
        return NettyHttpServiceClient.create(userAgent, executor, scheduledExecutor, null);
    }

    public static ServiceClient create(String userAgent, ExecutorService executor, ScheduledExecutorService scheduledExecutor, ServiceHost host) throws URISyntaxException {
        NettyHttpServiceClient sc = new NettyHttpServiceClient();
        sc.userAgent = userAgent;
        sc.executor = executor;
        sc.scheduledExecutor = scheduledExecutor;
        sc.host = host;
        sc.channelPool = new NettyChannelPool(executor);
        sc.http2ChannelPool = new NettyChannelPool(executor);
        String proxy = System.getenv(ENV_VAR_NAME_HTTP_PROXY);
        if (proxy != null) {
            sc.setHttpProxy(new URI(proxy));
        }
        return sc.setConnectionLimitPerHost(128);
    }

    private String buildThreadTag() {
        if (this.host != null) {
            return UriUtils.extendUri(this.host.getUri(), "netty-client").toString();
        }
        return this.getClass().getSimpleName() + ":" + Utils.getNowMicrosUtc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        NettyHttpServiceClient nettyHttpServiceClient = this;
        synchronized (nettyHttpServiceClient) {
            if (this.isStarted) {
                return;
            }
            this.isStarted = true;
        }
        this.channelPool.setThreadTag(this.buildThreadTag());
        this.channelPool.setThreadCount(2);
        this.channelPool.start();
        this.http2ChannelPool.setThreadTag(this.buildThreadTag());
        this.http2ChannelPool.setThreadCount(2);
        this.http2ChannelPool.setConnectionLimitPerHost(1024);
        this.http2ChannelPool.setHttp2Only();
        this.http2ChannelPool.start();
        if (this.sslContext != null) {
            this.sslChannelPool = new NettyChannelPool(this.executor);
            this.sslChannelPool.setThreadTag(this.buildThreadTag());
            this.sslChannelPool.setThreadCount(2);
            this.sslChannelPool.setSSLContext(this.sslContext);
            this.sslChannelPool.start();
        }
        if (this.host != null) {
            Operation startCallbackPost = Operation.createPost(UriUtils.buildUri(this.host, "/core/callbacks")).setCompletion((o, e) -> {
                if (e != null) {
                    this.host.log(Level.WARNING, "Failed to start %s: %s", "/core/callbacks", e.toString());
                }
            });
            this.callbackService = new HttpRequestCallbackService();
            this.host.startService(startCallbackPost, this.callbackService);
        }
    }

    @Override
    public void stop() {
        this.channelPool.stop();
        if (this.sslChannelPool != null) {
            this.sslChannelPool.stop();
        }
        if (this.http2ChannelPool != null) {
            this.http2ChannelPool.stop();
        }
        this.isStarted = false;
        if (this.host != null) {
            this.host.stopService(this.callbackService);
        }
    }

    public ServiceClient setHttpProxy(URI proxy) {
        this.httpProxy = proxy;
        return this;
    }

    @Override
    public void send(Operation op) {
        this.sendSingleRequest(op);
    }

    private void sendSingleRequest(Operation op) {
        Operation clone = NettyHttpServiceClient.clone(op);
        if (clone == null) {
            return;
        }
        this.setCookies(clone);
        if (!op.isRemote() && this.host != null && this.host.handleRequest(clone)) {
            return;
        }
        this.addAuthorizationContextHeader(clone);
        this.sendRemote(clone);
    }

    private void addAuthorizationContextHeader(Operation op) {
        Operation.AuthorizationContext ctx = op.getAuthorizationContext();
        if (ctx == null) {
            return;
        }
        String token = ctx.getToken();
        if (token == null) {
            return;
        }
        op.addRequestHeader("x-xenon-auth-token", token);
    }

    private void sendRemote(Operation op) {
        this.connect(op);
    }

    @Override
    public void sendWithCallback(Operation op) {
        this.sendWithCallbackSingleRequest(op);
    }

    private void sendWithCallbackSingleRequest(Operation req) {
        Operation op;
        if (req.getExpirationMicrosUtc() == 0L) {
            req.setExpiration(Utils.getNowMicrosUtc() + this.host.getOperationTimeoutMicros());
        }
        if ((op = NettyHttpServiceClient.clone(req)) == null) {
            return;
        }
        if (!req.isRemote() && this.host != null && this.host.handleRequest(op)) {
            return;
        }
        URI u = this.callbackService.queueUntilCallback(op);
        Operation remoteOp = op.clone();
        remoteOp.setRequestCallbackLocation(u);
        remoteOp.setCompletion((o, e) -> {
            if (e != null) {
                op.setExpiration(0L).fail(e);
                return;
            }
            op.setBody(null);
        });
        this.sendRemote(remoteOp);
    }

    private void setCookies(Operation clone) {
        clone.nestCompletion((o, e) -> {
            if (e != null) {
                clone.fail(e);
                return;
            }
            this.handleSetCookieHeaders(clone);
            clone.complete();
        });
        if (this.cookieJar.isEmpty()) {
            return;
        }
        clone.setCookies(this.cookieJar.list(clone.getUri()));
    }

    private void handleSetCookieHeaders(Operation op) {
        String value = op.getResponseHeader("set-cookie");
        if (value == null) {
            return;
        }
        Cookie cookie = ClientCookieDecoder.decode((String)value);
        if (cookie == null) {
            return;
        }
        this.cookieJar.add(op.getUri(), cookie);
    }

    private void connect(Operation op) {
        URI uri;
        Object originalBody = op.getBodyRaw();
        URI uRI = uri = this.httpProxy == null ? op.getUri() : this.httpProxy;
        if (op.getUri().getHost().equals("127.0.0.1")) {
            uri = op.getUri();
        }
        op.nestCompletion((o, e) -> {
            if (e != null) {
                op.setBody(ServiceErrorResponse.create(e, 400, EnumSet.of(ServiceErrorResponse.ErrorDetail.SHOULD_RETRY)));
                this.fail(e, op, originalBody);
                return;
            }
            this.sendRequest(op);
        });
        int port = uri.getPort();
        NettyChannelPool pool = this.channelPool;
        if (op.hasPragmaDirective("xn-use-http2")) {
            pool = this.http2ChannelPool;
        }
        if (uri.getScheme().equals("http")) {
            if (port == -1) {
                port = 80;
            }
        } else if (uri.getScheme().equals("https")) {
            if (port == -1) {
                port = 443;
            }
            pool = this.sslChannelPool;
            if (this.getSSLContext() == null || pool == null) {
                op.setRetryCount(0);
                this.fail(new IllegalArgumentException("HTTPS not enabled, set SSL context before starting client:" + op.getUri().getScheme()), op, originalBody);
                return;
            }
        } else {
            op.setRetryCount(0);
            this.fail(new IllegalArgumentException("Scheme is not supported: " + op.getUri().getScheme()), op, originalBody);
            return;
        }
        pool.connectOrReuse(uri.getHost(), port, op);
    }

    private void sendRequest(Operation op) {
        Object originalBody = op.getBodyRaw();
        try {
            byte[] body = Utils.encodeBody(op);
            String path = op.getUri().getPath();
            String query = op.getUri().getQuery();
            path = path == null || path.isEmpty() ? "/" : path;
            String pathAndQuery = query != null ? path + "?" + query : path;
            if (this.httpProxy != null) {
                pathAndQuery = op.getUri().toString();
            }
            NettyFullHttpRequest request = null;
            HttpMethod method = HttpMethod.valueOf((String)op.getAction().toString());
            boolean useHttp2 = op.hasPragmaDirective("xn-use-http2");
            if (body == null || body.length == 0) {
                request = new NettyFullHttpRequest(HttpVersion.HTTP_1_1, method, pathAndQuery);
            } else {
                ByteBuf content = Unpooled.wrappedBuffer((byte[])body);
                request = new NettyFullHttpRequest(HttpVersion.HTTP_1_1, method, pathAndQuery, content, false);
            }
            if (useHttp2) {
                op.removePragmaDirective("xn-use-http2");
                request.setOperation(op);
            }
            for (Map.Entry entry : op.getRequestHeaders().entrySet()) {
                request.headers().set((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
            }
            request.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)Long.toString(op.getContentLength()));
            request.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)op.getContentType());
            request.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)HttpHeaderValues.KEEP_ALIVE);
            if (op.getContextId() != null) {
                request.headers().set((CharSequence)"x-xenon-ctx-id", (CharSequence)op.getContextId());
            }
            if (op.getReferer() != null) {
                request.headers().set((CharSequence)HttpHeaderNames.REFERER, (CharSequence)op.getReferer().toString());
            }
            if (op.getCookies() != null) {
                String header = CookieJar.encodeCookies(op.getCookies());
                request.headers().set((CharSequence)HttpHeaderNames.COOKIE, (CharSequence)header);
            }
            request.headers().set((CharSequence)HttpHeaderNames.USER_AGENT, (CharSequence)this.userAgent);
            if (!op.getRequestHeaders().containsKey("accept")) {
                request.headers().set((CharSequence)HttpHeaderNames.ACCEPT, (CharSequence)"*/*");
            }
            request.headers().set((CharSequence)HttpHeaderNames.HOST, (CharSequence)((useHttp2 ? op.getUri().getScheme() + "://" : "") + op.getUri().getHost() + (op.getUri().getPort() != -1 ? ":" + op.getUri().getPort() : "")));
            op.nestCompletion((o, e) -> {
                if (e != null) {
                    this.fail(e, op, originalBody);
                    return;
                }
                op.complete();
            });
            op.getSocketContext().writeHttpRequest((Object)request);
        }
        catch (Throwable e2) {
            op.setBody(ServiceErrorResponse.create(e2, 400, EnumSet.of(ServiceErrorResponse.ErrorDetail.SHOULD_RETRY)));
            this.fail(e2, op, originalBody);
        }
    }

    private void fail(Throwable e, Operation op, Object originalBody) {
        boolean isRetryRequested;
        NettyChannelContext ctx = (NettyChannelContext)op.getSocketContext();
        NettyChannelPool pool = this.channelPool;
        if (this.sslChannelPool != null && this.sslChannelPool.isContextInUse(ctx)) {
            pool = this.sslChannelPool;
        }
        op.setSocketContext(null);
        pool.returnOrClose(ctx, !op.isKeepAlive());
        if (this.scheduledExecutor.isShutdown()) {
            op.fail(new CancellationException());
            return;
        }
        boolean bl = isRetryRequested = op.getRetryCount() > 0 && op.decrementRetriesRemaining() >= 0;
        if (isRetryRequested) {
            if (op.getStatusCode() >= 500) {
                isRetryRequested = false;
            }
            if (op.getStatusCode() == 409) {
                isRetryRequested = false;
            }
            if (op.getStatusCode() == 401) {
                isRetryRequested = false;
            }
            if (op.getStatusCode() == 404) {
                isRetryRequested = false;
            }
        }
        if (!isRetryRequested) {
            LOGGER.warning(String.format("(%d) Send of %d, from %s to %s failed with %s", pool.getPendingRequestCount(op), op.getId(), op.getReferer(), op.getUri(), e.toString()));
            op.fail(e);
            return;
        }
        LOGGER.info(String.format("(%d) Retry %d of request %d from %s to %s due to %s", pool.getPendingRequestCount(op), op.getRetryCount() - op.getRetriesRemaining(), op.getId(), op.getReferer(), op.getUri(), e.toString()));
        int delaySeconds = op.getRetryCount() - op.getRetriesRemaining();
        op.setStatusCode(200).setBodyNoCloning(originalBody);
        this.scheduledExecutor.schedule(() -> this.connect(op), (long)delaySeconds, TimeUnit.SECONDS);
    }

    private static Operation clone(Operation op) {
        boolean needsBody;
        IllegalArgumentException e = null;
        if (op == null) {
            throw new IllegalArgumentException("Operation is required");
        }
        Operation.CompletionHandler c = op.getCompletion();
        if (op.getUri() == null) {
            e = new IllegalArgumentException("Uri is required");
        }
        if (op.getAction() == null) {
            e = new IllegalArgumentException("Action is required");
        }
        if (op.getReferer() == null) {
            e = new IllegalArgumentException("Referer is required");
        }
        boolean bl = needsBody = op.getAction() != Service.Action.GET && op.getAction() != Service.Action.DELETE && op.getAction() != Service.Action.POST;
        if (!op.hasBody() && needsBody) {
            e = new IllegalArgumentException("Body is required");
        }
        if (e != null) {
            if (c != null) {
                c.handle(op, e);
                return null;
            }
            throw new RuntimeException(e);
        }
        return op.clone();
    }

    @Override
    public void handleMaintenance(Operation op) {
        if (this.sslChannelPool != null) {
            this.sslChannelPool.handleMaintenance(Operation.createPost(op.getUri()));
        }
        if (this.http2ChannelPool != null) {
            this.http2ChannelPool.handleMaintenance(Operation.createPost(op.getUri()));
        }
        this.channelPool.handleMaintenance(op);
    }

    @Override
    public ServiceClient setConnectionLimitPerHost(int limit) {
        this.channelPool.setConnectionLimitPerHost(limit);
        if (this.sslChannelPool != null) {
            this.sslChannelPool.setConnectionLimitPerHost(limit);
        }
        return this;
    }

    @Override
    public int getConnectionLimitPerHost() {
        return this.channelPool.getConnectionLimitPerHost();
    }

    @Override
    public ServiceClient setSSLContext(SSLContext context) {
        this.sslContext = context;
        return this;
    }

    @Override
    public SSLContext getSSLContext() {
        return this.sslContext;
    }
}

