/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.http.netty;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.common.http.netty.NettyChannelContext;
import com.vmware.xenon.common.http.netty.NettyChannelPool;
import com.vmware.xenon.common.http.netty.NettyHttp2UserEventLogger;
import com.vmware.xenon.common.http.netty.NettyHttpServerResponseHandler;
import com.vmware.xenon.common.http.netty.NettyHttpToHttp2Handler;
import com.vmware.xenon.common.http.netty.NettyLoggingUtil;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DefaultHttp2FrameReader;
import io.netty.handler.codec.http2.DefaultHttp2FrameWriter;
import io.netty.handler.codec.http2.DelegatingDecompressorFrameListener;
import io.netty.handler.codec.http2.Http2ClientUpgradeCodec;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2FrameReader;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2InboundFrameLogger;
import io.netty.handler.codec.http2.Http2OutboundFrameLogger;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandler;
import io.netty.handler.codec.http2.InboundHttp2ToHttpAdapter;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.internal.logging.InternalLogLevel;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.logging.Level;
import javax.net.ssl.SSLEngine;

public class NettyHttpClientRequestInitializer
extends ChannelInitializer<SocketChannel> {
    public static final String SSL_HANDLER = "ssl";
    public static final String HTTP1_CODEC = "http1-codec";
    public static final String UPGRADE_HANDLER = "upgrade-handler";
    public static final String UPGRADE_REQUEST = "upgrade-request";
    public static final String AGGREGATOR_HANDLER = "aggregator";
    public static final String XENON_HANDLER = "xenon";
    public static final String EVENT_LOGGER = "event-logger";
    private final NettyChannelPool pool;
    private boolean isHttp2Only = false;
    private boolean debugLogging = false;

    public NettyHttpClientRequestInitializer(NettyChannelPool nettyChannelPool, boolean isHttp2Only) {
        this.pool = nettyChannelPool;
        this.isHttp2Only = isHttp2Only;
        NettyLoggingUtil.setupNettyLogging();
    }

    public void initChannel(SocketChannel ch) {
        ChannelPipeline p = ch.pipeline();
        ch.config().setAllocator((ByteBufAllocator)NettyChannelContext.ALLOCATOR);
        ch.config().setSendBufferSize(65536);
        ch.config().setReceiveBufferSize(65536);
        if (this.pool.getSSLContext() != null) {
            if (this.isHttp2Only) {
                throw new IllegalArgumentException("HTTP/2 with SSL is not supported");
            }
            SSLEngine engine = this.pool.getSSLContext().createSSLEngine();
            engine.setUseClientMode(true);
            p.addLast(SSL_HANDLER, (ChannelHandler)new SslHandler(engine));
        }
        HttpClientCodec http1_codec = new HttpClientCodec(4096, 65536, 65536, false);
        p.addLast(HTTP1_CODEC, (ChannelHandler)http1_codec);
        if (this.isHttp2Only) {
            try {
                HttpToHttp2ConnectionHandler connectionHandler = this.makeHttp2ConnectionHandler();
                Http2ClientUpgradeCodec upgradeCodec = new Http2ClientUpgradeCodec((Http2ConnectionHandler)connectionHandler);
                HttpClientUpgradeHandler upgradeHandler = new HttpClientUpgradeHandler((HttpClientUpgradeHandler.SourceCodec)http1_codec, (HttpClientUpgradeHandler.UpgradeCodec)upgradeCodec, Operation.SocketContext.getMaxClientRequestSize());
                p.addLast(UPGRADE_HANDLER, (ChannelHandler)upgradeHandler);
                p.addLast(UPGRADE_REQUEST, (ChannelHandler)new UpgradeRequestHandler());
                ChannelPromise settingsPromise = ch.newPromise();
                p.addLast("settings-handler", (ChannelHandler)new Http2SettingsHandler(settingsPromise));
                ch.attr(NettyChannelContext.SETTINGS_PROMISE_KEY).set((Object)settingsPromise);
                p.addLast(EVENT_LOGGER, (ChannelHandler)new NettyHttp2UserEventLogger(this.debugLogging));
            }
            catch (Throwable ex) {
                Utils.log(NettyHttpClientRequestInitializer.class, NettyHttpClientRequestInitializer.class.getSimpleName(), Level.WARNING, "Channel Initializer exception: %s", ex);
                throw ex;
            }
        } else {
            p.addLast(AGGREGATOR_HANDLER, (ChannelHandler)new HttpObjectAggregator(Operation.SocketContext.getMaxClientRequestSize()));
        }
        p.addLast(XENON_HANDLER, (ChannelHandler)new NettyHttpServerResponseHandler(this.pool));
    }

    private HttpToHttp2ConnectionHandler makeHttp2ConnectionHandler() {
        DefaultHttp2Connection connection = new DefaultHttp2Connection(false);
        InboundHttp2ToHttpAdapter inboundAdapter = new InboundHttp2ToHttpAdapter.Builder((Http2Connection)connection).maxContentLength(65536).propagateSettings(true).build();
        DelegatingDecompressorFrameListener frameListener = new DelegatingDecompressorFrameListener((Http2Connection)connection, (Http2FrameListener)inboundAdapter);
        Http2FrameReader frameReader = NettyHttpClientRequestInitializer.makeFrameReader(this.debugLogging);
        Http2FrameWriter frameWriter = NettyHttpClientRequestInitializer.makeFrameWriter(this.debugLogging);
        NettyHttpToHttp2Handler connectionHandler = new NettyHttpToHttp2Handler((Http2Connection)connection, frameReader, frameWriter, (Http2FrameListener)frameListener);
        Http2Settings settings = connectionHandler.decoder().localSettings();
        settings.maxConcurrentStreams((long)this.pool.getConnectionLimitPerHost());
        try {
            connectionHandler.decoder().localSettings(settings);
        }
        catch (Http2Exception ex) {
            Utils.log(NettyHttpClientRequestInitializer.class, NettyHttpClientRequestInitializer.class.getSimpleName(), Level.WARNING, "Failed to set maximum HTTP/2 concurrent streams: %s", ex.getMessage());
        }
        return connectionHandler;
    }

    public static Http2FrameReader makeFrameReader(boolean debugLogging) {
        DefaultHttp2FrameReader frameReader = new DefaultHttp2FrameReader();
        try {
            frameReader.maxFrameSize(65536);
        }
        catch (Http2Exception ex) {
            Utils.log(NettyHttpClientRequestInitializer.class, NettyHttpClientRequestInitializer.class.getSimpleName(), Level.WARNING, "Failed to set HTTP/2 maximum frame size to %s: %s", 65536, ex.getMessage());
        }
        if (debugLogging) {
            Http2FrameLogger logger = new Http2FrameLogger(InternalLogLevel.INFO, InternalLoggerFactory.getInstance(NettyHttpClientRequestInitializer.class));
            return new Http2InboundFrameLogger((Http2FrameReader)frameReader, logger);
        }
        return frameReader;
    }

    public static Http2FrameWriter makeFrameWriter(boolean debugLogging) {
        DefaultHttp2FrameWriter frameWriter = new DefaultHttp2FrameWriter();
        try {
            frameWriter.maxFrameSize(65536);
        }
        catch (Http2Exception ex) {
            Utils.log(NettyHttpClientRequestInitializer.class, NettyHttpClientRequestInitializer.class.getSimpleName(), Level.WARNING, "Failed to set HTTP/2 maximum frame size to %s", 65536);
        }
        if (debugLogging) {
            Http2FrameLogger logger = new Http2FrameLogger(InternalLogLevel.INFO, InternalLoggerFactory.getInstance(NettyHttpClientRequestInitializer.class));
            return new Http2OutboundFrameLogger((Http2FrameWriter)frameWriter, logger);
        }
        return frameWriter;
    }

    private static class Http2SettingsHandler
    extends SimpleChannelInboundHandler<Http2Settings> {
        private ChannelPromise promise;

        public Http2SettingsHandler(ChannelPromise promise) {
            this.promise = promise;
        }

        protected void messageReceived(ChannelHandlerContext ctx, Http2Settings msg) throws Exception {
            this.promise.setSuccess();
            ctx.pipeline().remove((ChannelHandler)this);
        }
    }

    private static final class UpgradeRequestHandler
    extends ChannelHandlerAdapter {
        private UpgradeRequestHandler() {
        }

        public void channelActive(ChannelHandlerContext context) throws Exception {
            DefaultFullHttpRequest upgradeRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/");
            context.writeAndFlush((Object)upgradeRequest);
            super.channelActive(context);
            context.pipeline().remove((ChannelHandler)this);
        }
    }
}

