/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.http.netty;

import com.vmware.xenon.common.Utils;
import com.vmware.xenon.common.http.netty.NettyHttpClientRequestInitializer;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import java.util.logging.Level;

public class NettyHttp2UserEventLogger
extends ChannelHandlerAdapter {
    private boolean debugLogging = false;

    public NettyHttp2UserEventLogger(boolean debugLogging) {
        this.debugLogging = debugLogging;
    }

    public void userEventTriggered(ChannelHandlerContext context, Object eventRaw) throws Exception {
        if (!(eventRaw instanceof HttpClientUpgradeHandler.UpgradeEvent)) {
            super.userEventTriggered(context, eventRaw);
            return;
        }
        HttpClientUpgradeHandler.UpgradeEvent event = (HttpClientUpgradeHandler.UpgradeEvent)eventRaw;
        if (event == HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_REJECTED) {
            Utils.log(NettyHttpClientRequestInitializer.class, NettyHttpClientRequestInitializer.class.getSimpleName(), Level.WARNING, "Failed to upgrade to HTTP/2: throughput will be slow", new Object[0]);
        } else if (this.debugLogging) {
            Utils.log(NettyHttpClientRequestInitializer.class, NettyHttpClientRequestInitializer.class.getSimpleName(), Level.INFO, "HTTP/2 channel pipeline user event: %s", event);
        }
        super.userEventTriggered(context, eventRaw);
    }
}

