/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.http.netty;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.common.http.netty.NettyChannelContext;
import com.vmware.xenon.common.http.netty.NettyHttpClientRequestInitializer;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLContext;

public class NettyChannelPool {
    private static final long CHANNEL_EXPIRATION_MICROS = ServiceHost.ServiceHostState.DEFAULT_OPERATION_TIMEOUT_MICROS * 2L;
    private final ExecutorService executor;
    private EventLoopGroup eventGroup;
    private String threadTag = NettyChannelPool.class.getSimpleName();
    private int threadCount;
    private boolean isHttp2Only = false;
    private Bootstrap bootStrap;
    private final Map<String, NettyChannelGroup> channelGroups = new ConcurrentSkipListMap<String, NettyChannelGroup>();
    private int connectionLimit = 1;
    private SSLContext sslContext;

    public static String toConnectionKey(String host, int port) {
        return host + port;
    }

    public NettyChannelPool(ExecutorService executor) {
        this.executor = executor;
    }

    public NettyChannelPool setThreadTag(String tag) {
        this.threadTag = tag;
        return this;
    }

    public NettyChannelPool setThreadCount(int count) {
        this.threadCount = count;
        return this;
    }

    public NettyChannelPool setHttp2Only() {
        this.isHttp2Only = true;
        return this;
    }

    public boolean isHttp2Only() {
        return this.isHttp2Only;
    }

    public void start() {
        if (this.bootStrap != null) {
            return;
        }
        this.eventGroup = new NioEventLoopGroup(this.threadCount, t -> Executors.newFixedThreadPool(t, r -> new Thread(r, this.threadTag)));
        this.bootStrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)this.bootStrap.group(this.eventGroup)).channel(NioSocketChannel.class)).handler((ChannelHandler)new NettyHttpClientRequestInitializer(this, this.isHttp2Only));
    }

    public boolean isStarted() {
        return this.bootStrap != null;
    }

    public NettyChannelPool setConnectionLimitPerHost(int limit) {
        this.connectionLimit = limit;
        return this;
    }

    public int getConnectionLimitPerHost() {
        return this.connectionLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NettyChannelGroup getChannelGroup(String key) {
        NettyChannelGroup group;
        Map<String, NettyChannelGroup> map = this.channelGroups;
        synchronized (map) {
            group = this.channelGroups.get(key);
            if (group == null) {
                group = new NettyChannelGroup();
                this.channelGroups.put(key, group);
            }
        }
        return group;
    }

    public long getPendingRequestCount(Operation op) {
        String key = NettyChannelPool.toConnectionKey(op.getUri().getHost(), op.getUri().getPort());
        NettyChannelGroup group = this.getChannelGroup(key);
        return group.pendingRequests.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectOrReuse(String host, int port, final Operation request) {
        if (request == null) {
            throw new IllegalArgumentException("request is required");
        }
        if (host == null) {
            request.fail(new IllegalArgumentException("host is required"));
            return;
        }
        if (port <= 0) {
            port = 80;
        }
        try {
            String key = NettyChannelPool.toConnectionKey(host, port);
            final NettyChannelGroup group = this.getChannelGroup(key);
            final NettyChannelContext context = this.selectContext(group, host, port, key);
            if (context == null) {
                NettyChannelGroup nettyChannelGroup = group;
                synchronized (nettyChannelGroup) {
                    group.pendingRequests.add(request);
                }
                return;
            }
            if (context.getChannel() != null) {
                context.setOperation(request);
                request.complete();
                return;
            }
            ChannelFuture connectFuture = this.bootStrap.connect(context.host, context.port);
            connectFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        Channel channel = future.channel();
                        if (NettyChannelPool.this.isHttp2Only) {
                            channel.attr(NettyChannelContext.CHANNEL_CONTEXT_KEY).set((Object)context);
                            channel.attr(NettyChannelContext.HTTP2_KEY).set((Object)true);
                            NettyChannelPool.this.waitForSettings(channel, context, request, group);
                        } else {
                            NettyChannelPool.this.sendAfterConnect(channel, context, request, null);
                        }
                    } else {
                        NettyChannelPool.this.returnOrClose(context, true);
                        NettyChannelPool.this.fail(request, future.cause());
                    }
                }
            });
        }
        catch (Throwable e) {
            this.fail(request, e);
        }
    }

    private NettyChannelContext selectContext(NettyChannelGroup group, String host, int port, String key) {
        if (this.isHttp2Only) {
            return this.selectHttp2Context(group, host, port, key);
        }
        return this.selectHttp11Context(group, host, port, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NettyChannelContext selectHttp2Context(NettyChannelGroup group, String host, int port, String key) {
        NettyChannelContext http2Channel = null;
        NettyChannelGroup nettyChannelGroup = group;
        synchronized (nettyChannelGroup) {
            for (NettyChannelContext channel : group.http2Channels) {
                if (!channel.isValid()) continue;
                http2Channel = channel;
                break;
            }
            if (http2Channel != null && http2Channel.getOpenInProgress()) {
                return null;
            }
            if (http2Channel == null) {
                http2Channel = new NettyChannelContext(host, port, key, NettyChannelContext.Protocol.HTTP2);
                http2Channel.setOpenInProgress(true);
                group.http2Channels.add(http2Channel);
            } else if (http2Channel.getChannel() != null && !http2Channel.getChannel().isOpen()) {
                http2Channel.close();
                group.http2Channels.remove(http2Channel);
                http2Channel = new NettyChannelContext(host, port, key, NettyChannelContext.Protocol.HTTP2);
                http2Channel.setOpenInProgress(true);
                group.http2Channels.add(http2Channel);
            }
            http2Channel.updateLastUseTime();
        }
        return http2Channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NettyChannelContext selectHttp11Context(NettyChannelGroup group, String host, int port, String key) {
        NettyChannelContext context = null;
        NettyChannelGroup nettyChannelGroup = group;
        synchronized (nettyChannelGroup) {
            if (!group.availableChannels.isEmpty()) {
                context = group.availableChannels.remove(group.availableChannels.size() - 1);
                context.updateLastUseTime();
            } else {
                if (group.inUseChannels.size() >= this.connectionLimit) {
                    return null;
                }
                context = new NettyChannelContext(host, port, key, NettyChannelContext.Protocol.HTTP11);
            }
            if (context.getChannel() != null && !context.getChannel().isOpen()) {
                context.close();
                context = new NettyChannelContext(host, port, key, NettyChannelContext.Protocol.HTTP11);
            }
            group.inUseChannels.add(context);
        }
        return context;
    }

    private void waitForSettings(Channel ch, final NettyChannelContext contextFinal, final Operation request, final NettyChannelGroup group) {
        ChannelPromise settingsPromise = (ChannelPromise)ch.attr(NettyChannelContext.SETTINGS_PROMISE_KEY).get();
        settingsPromise.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    NettyChannelPool.this.sendAfterConnect(future.channel(), contextFinal, request, group);
                } else {
                    NettyChannelPool.this.returnOrClose(contextFinal, true);
                    NettyChannelPool.this.fail(request, future.cause());
                }
            }
        });
    }

    private void sendAfterConnect(Channel ch, NettyChannelContext contextFinal, Operation request, NettyChannelGroup group) {
        if (this.isHttp2Only) {
            contextFinal.setOpenInProgress(false);
        }
        contextFinal.setChannel(ch).setOperation(request);
        request.complete();
    }

    private void fail(Operation request, Throwable e) {
        request.fail(e, 400);
    }

    public void returnOrClose(NettyChannelContext context, boolean isClose) {
        ExecutorService e = this.executor;
        if (e == null) {
            return;
        }
        if (e.isShutdown()) {
            return;
        }
        if (context == null) {
            return;
        }
        e.execute(() -> this.returnOrCloseDirect(context, isClose));
    }

    boolean isContextInUse(NettyChannelContext context) {
        if (context == null) {
            return false;
        }
        NettyChannelGroup group = this.channelGroups.get(context.getKey());
        return group != null && group.inUseChannels.contains(context);
    }

    private void returnOrCloseDirect(NettyChannelContext context, boolean isClose) {
        Channel ch = context.getChannel();
        isClose = isClose || !ch.isWritable() || !ch.isOpen();
        NettyChannelGroup group = this.channelGroups.get(context.getKey());
        if (group == null) {
            context.close();
            return;
        }
        if (this.isHttp2Only) {
            this.returnOrCloseDirectHttp2(context, group, isClose);
        } else {
            this.returnOrCloseDirectHttp1(context, group, isClose);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnOrCloseDirectHttp1(NettyChannelContext context, NettyChannelGroup group, boolean isClose) {
        Operation pendingOp = null;
        NettyChannelGroup nettyChannelGroup = group;
        synchronized (nettyChannelGroup) {
            if (!group.pendingRequests.isEmpty()) {
                pendingOp = group.pendingRequests.remove(group.pendingRequests.size() - 1);
            }
            if (isClose) {
                group.inUseChannels.remove(context);
            } else if (pendingOp == null) {
                group.availableChannels.add(context);
                group.inUseChannels.remove(context);
            }
        }
        if (isClose) {
            context.close();
        }
        if (pendingOp == null) {
            return;
        }
        if (isClose) {
            this.connectOrReuse(context.host, context.port, pendingOp);
        } else {
            context.setOperation(pendingOp);
            pendingOp.complete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnOrCloseDirectHttp2(NettyChannelContext context, NettyChannelGroup group, boolean isClose) {
        boolean havePending;
        NettyChannelGroup nettyChannelGroup = group;
        synchronized (nettyChannelGroup) {
            if (isClose) {
                context.setOpenInProgress(false);
                group.http2Channels.remove(context);
            }
            havePending = !group.pendingRequests.isEmpty();
        }
        if (isClose) {
            context.close();
        }
        if (!havePending) {
            return;
        }
        Operation pendingOp = null;
        if (isClose) {
            NettyChannelGroup nettyChannelGroup2 = group;
            synchronized (nettyChannelGroup2) {
                pendingOp = group.pendingRequests.remove(group.pendingRequests.size() - 1);
            }
            this.connectOrReuse(context.host, context.port, pendingOp);
        } else {
            for (int i = 0; havePending && i < this.connectionLimit; ++i) {
                NettyChannelGroup nettyChannelGroup3 = group;
                synchronized (nettyChannelGroup3) {
                    pendingOp = group.pendingRequests.remove(group.pendingRequests.size() - 1);
                    havePending = !group.pendingRequests.isEmpty();
                }
                pendingOp.setSocketContext(context);
                pendingOp.complete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            Iterator<NettyChannelGroup> iterator = this.channelGroups.values().iterator();
            while (iterator.hasNext()) {
                NettyChannelGroup g;
                NettyChannelGroup nettyChannelGroup = g = iterator.next();
                synchronized (nettyChannelGroup) {
                    for (NettyChannelContext c : g.availableChannels) {
                        c.close();
                    }
                    for (NettyChannelContext c : g.inUseChannels) {
                        c.close();
                    }
                    for (NettyChannelContext c : g.http2Channels) {
                        c.close();
                    }
                    g.availableChannels.clear();
                    g.inUseChannels.clear();
                    g.http2Channels.clear();
                }
            }
            this.eventGroup.shutdownGracefully();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.bootStrap = null;
    }

    public void handleMaintenance(Operation op) {
        if (this.isHttp2Only) {
            this.handleHttp2Maintenance(op);
        } else {
            this.handleHttp1Maintenance(op);
        }
        op.complete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleHttp1Maintenance(Operation op) {
        Iterator<NettyChannelGroup> iterator = this.channelGroups.values().iterator();
        while (iterator.hasNext()) {
            NettyChannelGroup g;
            NettyChannelGroup nettyChannelGroup = g = iterator.next();
            synchronized (nettyChannelGroup) {
                this.closeContexts(g.availableChannels, false);
                this.closeExpiredInUseContext(g.inUseChannels);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleHttp2Maintenance(Operation op) {
        Iterator<NettyChannelGroup> iterator = this.channelGroups.values().iterator();
        while (iterator.hasNext()) {
            NettyChannelGroup g;
            NettyChannelGroup nettyChannelGroup = g = iterator.next();
            synchronized (nettyChannelGroup) {
                this.expireHttp2Operations(g);
                this.closeHttp2Context(g);
            }
        }
    }

    private void closeExpiredInUseContext(Collection<NettyChannelContext> contexts) {
        long now = Utils.getNowMicrosUtc();
        for (NettyChannelContext c : contexts) {
            Operation activeOp = c.getOperation();
            if (activeOp == null || activeOp.getExpirationMicrosUtc() > now) continue;
            this.executor.execute(() -> activeOp.fail(new TimeoutException(activeOp.toString())));
        }
    }

    private void closeContexts(Collection<NettyChannelContext> contexts, boolean forceClose) {
        long now = Utils.getNowMicrosUtc();
        ArrayList<NettyChannelContext> items = new ArrayList<NettyChannelContext>();
        for (NettyChannelContext c : contexts) {
            try {
                if (c.getChannel() == null || !c.getChannel().isOpen()) {
                    continue;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            long delta = now - c.getLastUseTimeMicros();
            if (!forceClose && delta < CHANNEL_EXPIRATION_MICROS) continue;
            c.close();
            items.add(c);
        }
        for (NettyChannelContext c : items) {
            contexts.remove(c);
        }
    }

    private void expireHttp2Operations(NettyChannelGroup group) {
        long now = Utils.getNowMicrosUtc();
        for (NettyChannelContext c : group.http2Channels) {
            Iterator<Map.Entry<Integer, Operation>> it = c.streamIdMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Integer, Operation> entry = it.next();
                Operation activeOp = entry.getValue();
                if (activeOp == null || activeOp.getExpirationMicrosUtc() > now) continue;
                it.remove();
                this.executor.execute(() -> activeOp.fail(new TimeoutException(activeOp.toString())));
            }
        }
    }

    private void closeHttp2Context(NettyChannelGroup group) {
        long now = Utils.getNowMicrosUtc();
        ArrayList<NettyChannelContext> items = new ArrayList<NettyChannelContext>();
        for (NettyChannelContext http2Channel : group.http2Channels) {
            Channel channel = http2Channel.getChannel();
            if (channel == null || !channel.isOpen()) {
                return;
            }
            if (http2Channel.haveStreamsInUse()) {
                return;
            }
            long delta = now - http2Channel.getLastUseTimeMicros();
            if (delta < CHANNEL_EXPIRATION_MICROS || !http2Channel.isValid()) {
                return;
            }
            channel.close();
            items.add(http2Channel);
        }
        for (NettyChannelContext c : items) {
            group.http2Channels.remove(c);
        }
    }

    public void setSSLContext(SSLContext context) {
        if (this.isStarted()) {
            throw new IllegalStateException("Already started");
        }
        this.sslContext = context;
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    public static class NettyChannelGroup {
        public List<NettyChannelContext> availableChannels = new ArrayList<NettyChannelContext>();
        public Set<NettyChannelContext> inUseChannels = new HashSet<NettyChannelContext>();
        public List<NettyChannelContext> http2Channels = new ArrayList<NettyChannelContext>();
        public List<Operation> pendingRequests = new ArrayList<Operation>();
    }
}

