/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import java.lang.reflect.Field;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public class CommandLineArgumentParser {
    private static final Logger LOGGER = Logger.getLogger(CommandLineArgumentParser.class.getSimpleName());
    public static final String PROPERTY_PREFIX = "xenon.";
    public static final String ARGUMENT_PREFIX = "--";
    public static final String ARGUMENT_ASSIGNMENT = "=";

    public static void parse(Object objectToBind, String[] args) {
        Map<String, String> argumentValuePairs = CommandLineArgumentParser.parsePairsFromProperties();
        CommandLineArgumentParser.bindPairs(objectToBind, argumentValuePairs);
        argumentValuePairs = CommandLineArgumentParser.parsePairsFromArguments(args);
        CommandLineArgumentParser.bindPairs(objectToBind, argumentValuePairs);
    }

    public static void parseFromProperties(Object objectToBind) {
        Map<String, String> argumentValuePairs = CommandLineArgumentParser.parsePairsFromProperties();
        CommandLineArgumentParser.bindPairs(objectToBind, argumentValuePairs);
    }

    public static void parseFromArguments(Object objectToBind, String[] args) {
        Map<String, String> argumentValuePairs = CommandLineArgumentParser.parsePairsFromArguments(args);
        CommandLineArgumentParser.bindPairs(objectToBind, argumentValuePairs);
    }

    public static void bindPairs(Object objectToBind, Map<String, String> pairs) {
        Class<?> type = objectToBind.getClass();
        for (Map.Entry<String, String> parsedArgument : pairs.entrySet()) {
            try {
                Field field = type.getField(parsedArgument.getKey());
                if (field == null) continue;
                LOGGER.info(String.format("Found field for argument %s:%s", parsedArgument.getKey(), parsedArgument.getValue()));
                String v = parsedArgument.getValue();
                if (field.getType().equals(Boolean.TYPE) || field.getType().equals(Boolean.class)) {
                    field.set(objectToBind, CommandLineArgumentParser.safeConvertToBoolean(v));
                    continue;
                }
                if (field.getType().equals(Integer.TYPE) || field.getType().equals(Integer.class)) {
                    field.set(objectToBind, CommandLineArgumentParser.safeConvertToInteger(v));
                    continue;
                }
                if (field.getType().equals(Long.TYPE) || field.getType().equals(Long.class)) {
                    field.set(objectToBind, CommandLineArgumentParser.safeConvertToLong(v));
                    continue;
                }
                if (field.getType().equals(Double.TYPE) || field.getType().equals(Double.class)) {
                    field.set(objectToBind, CommandLineArgumentParser.safeConvertToDouble(v));
                    continue;
                }
                if (field.getType().equals(Path.class)) {
                    field.set(objectToBind, CommandLineArgumentParser.safeConvertToPath(v));
                    continue;
                }
                if (field.getType().equals(String.class)) {
                    if (v.equals("null")) {
                        v = null;
                    }
                    field.set(objectToBind, v);
                    continue;
                }
                if (field.getType().equals(String[].class)) {
                    if (v.equals("null")) {
                        v = null;
                        field.set(objectToBind, null);
                        continue;
                    }
                    field.set(objectToBind, CommandLineArgumentParser.safeConvertToStringArray(v));
                    continue;
                }
                if (field.getType().isEnum()) {
                    if (v.equals("null")) {
                        v = null;
                        field.set(objectToBind, null);
                        continue;
                    }
                    field.set(objectToBind, CommandLineArgumentParser.safeConvertToEnumValue(field.getType(), v));
                    continue;
                }
                LOGGER.severe(String.format("Unsupported type %s for field %s", field.getType().toString(), field.getName()));
            }
            catch (Throwable e) {
                if (e instanceof NoSuchFieldException) {
                    LOGGER.fine(String.format("Field not present for arg %s in type %s", parsedArgument.getKey(), objectToBind.getClass().getSimpleName()));
                    continue;
                }
                LOGGER.severe(String.format("Error setting field for arg %s:%s", parsedArgument.getValue(), e.toString()));
            }
        }
    }

    public static Map<String, String> parsePairsFromProperties() {
        HashMap<String, String> pairs = new HashMap<String, String>();
        Properties properties = System.getProperties();
        for (String name : properties.stringPropertyNames()) {
            if (!name.startsWith(PROPERTY_PREFIX)) continue;
            String key = name.substring(PROPERTY_PREFIX.length());
            pairs.put(key, properties.getProperty(name));
        }
        return pairs;
    }

    public static Map<String, String> parsePairsFromArguments(String[] args) {
        HashMap<String, String> pairs = new HashMap<String, String>();
        for (String arg : args) {
            if (!arg.startsWith(ARGUMENT_PREFIX)) {
                throw new IllegalArgumentException("Arguments must start with --");
            }
            int spaceIndex = arg.indexOf(ARGUMENT_ASSIGNMENT);
            if (spaceIndex == -1 || spaceIndex == arg.length() - 1) {
                throw new IllegalArgumentException("Arguments must be followed by an equals sign and a value:" + arg);
            }
            String argName = arg.substring(ARGUMENT_PREFIX.length(), spaceIndex);
            String value = arg.substring(spaceIndex + 1, arg.length());
            pairs.put(argName, value);
        }
        return pairs;
    }

    public static Integer safeConvertToInteger(String argumentValue) {
        try {
            return Integer.decode(argumentValue);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Long safeConvertToLong(String argumentValue) {
        try {
            return Long.decode(argumentValue);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Double safeConvertToDouble(String argumentValue) {
        try {
            return Double.parseDouble(argumentValue);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Boolean safeConvertToBoolean(String argumentValue) {
        try {
            return Boolean.parseBoolean(argumentValue);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static String[] safeConvertToStringArray(String value) {
        String[] segments = value.split(",");
        return segments;
    }

    private static Object safeConvertToEnumValue(Class<?> type, String v) {
        try {
            return Enum.valueOf(type.asSubclass(Enum.class), v);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Path safeConvertToPath(String v) {
        return Paths.get(v, new String[0]);
    }
}

