/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.OperationJoin;
import com.vmware.xenon.common.OperationSequence;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.StatefulService;
import com.vmware.xenon.common.TaskState;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.services.common.TransactionResolutionService;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.stream.Collectors;

public class TransactionService
extends StatefulService {
    public TransactionService() {
        super(TransactionServiceState.class);
        super.toggleOption(Service.ServiceOption.REPLICATION, true);
        super.toggleOption(Service.ServiceOption.PERSISTENCE, true);
        super.toggleOption(Service.ServiceOption.OWNER_SELECTION, true);
    }

    @Override
    public void handleStart(Operation start) {
        TransactionServiceState s = start.getBody(TransactionServiceState.class);
        s.taskSubStage = s.taskSubStage == null ? SubStage.COLLECTING : s.taskSubStage;
        s.options = s.options == null ? new Options() : s.options;
        s.servicesToCoordinators = s.servicesToCoordinators == null ? new LinkedHashMap<String, Set<String>>() : s.servicesToCoordinators;
        s.readLinks = s.readLinks == null ? new HashSet() : s.readLinks;
        s.modifiedLinks = s.modifiedLinks == null ? new HashSet() : s.modifiedLinks;
        s.dependentLinks = s.dependentLinks == null ? new HashSet() : s.dependentLinks;
        s.failedLinks = new HashSet<String>();
        this.setState(start, s);
        this.allocateResolutionService(start);
    }

    private void allocateResolutionService(Operation op) {
        Operation startResolutionService = Operation.createPost(UriUtils.extendUri(this.getUri(), "/resolve")).setCompletion((o, e) -> {
            if (e != null) {
                op.fail(e);
                return;
            }
            op.complete();
        });
        this.getHost().startService(startResolutionService, new TransactionResolutionService(this));
    }

    @Override
    public void handlePut(Operation put) {
        if (!put.hasBody()) {
            put.fail(new IllegalArgumentException("Body is required"));
            return;
        }
        Operation.TransactionContext record = put.getBody(Operation.TransactionContext.class);
        TransactionServiceState existing = (TransactionServiceState)this.getState(put);
        if (record.action == Service.Action.GET) {
            existing.readLinks.add(put.getReferer().toString());
        } else {
            existing.modifiedLinks.add(put.getReferer().toString());
        }
        if (record.coordinatorLinks != null) {
            existing.servicesToCoordinators.put(put.getReferer().toString(), record.coordinatorLinks);
        }
        if (!record.isSuccessful) {
            if (existing.failedLinks == null) {
                existing.failedLinks = new HashSet<String>();
            }
            existing.failedLinks.add(put.getReferer().toString());
        }
        this.setState(put, existing);
        put.complete();
    }

    @Override
    public void handlePatch(Operation patch) {
        if (!patch.hasBody()) {
            patch.fail(new IllegalArgumentException("Body is required"));
            return;
        }
        if (patch.getRequestHeader("x-xenon-tx-phase") != null) {
            if (patch.getRequestHeader("x-xenon-tx-phase").equals("try-commit")) {
                this.handleTryCommit(patch);
            } else if (patch.getRequestHeader("x-xenon-tx-phase").equals("ensure-commit")) {
                this.handleEnsureCommit(patch);
            }
        } else {
            ResolutionRequest resolution = patch.getBody(ResolutionRequest.class);
            if (resolution.kind == ResolutionKind.ABORT) {
                this.updateStage(patch, SubStage.ABORTED);
                patch.complete();
                this.handleAbort(patch);
            } else if (resolution.kind == ResolutionKind.COMMIT) {
                this.updateStage(patch, SubStage.RESOLVING);
                patch.complete();
                this.handleCommit(patch);
            } else if (resolution.kind == ResolutionKind.COMMITTED) {
                this.updateStage(patch, SubStage.COMMITTED);
                patch.complete();
            } else if (resolution.kind == ResolutionKind.ABORTED) {
                this.updateStage(patch, SubStage.ABORTED);
                patch.complete();
            } else {
                this.getHost().failRequestActionNotSupported(patch);
                patch.fail(new IllegalArgumentException("Unrecognized resolution kind: " + (Object)((Object)resolution.kind)));
            }
        }
    }

    private void handleCommit(Operation op) {
        TransactionServiceState existing = (TransactionServiceState)this.getState(op);
        if (existing.options.allowErrorsCauseAbort && !existing.failedLinks.isEmpty()) {
            this.handleAbort(op);
            return;
        }
        ArrayList<OperationJoin> operationJoins = new ArrayList<OperationJoin>();
        if (!this.setOfTryPreceedOps(existing).isEmpty()) {
            operationJoins.add(OperationJoin.create(this.setOfTryPreceedOps(existing)));
        }
        if (!this.setOfEnsurePreceedOps(existing).isEmpty()) {
            operationJoins.add(OperationJoin.create(this.setOfEnsurePreceedOps(existing)));
        }
        if (!this.createNotifyServicesToCommit(existing).isEmpty()) {
            operationJoins.add(OperationJoin.create(this.createNotifyServicesToCommit(existing)));
        }
        OperationSequence os = OperationSequence.create(operationJoins.toArray(new OperationJoin[operationJoins.size()]));
        os.setCompletion((operations, failures) -> {
            if (failures != null) {
                this.handleAbort(op);
                return;
            }
            this.selfPatch(ResolutionKind.COMMITTED);
        });
        os.sendWith(this.getHost());
    }

    private void updateStage(Operation op, SubStage stage) {
        TransactionServiceState existing = (TransactionServiceState)this.getState(op);
        existing.taskSubStage = stage;
        this.setState(op, existing);
    }

    private void selfPatch(ResolutionKind resolution) {
        ResolutionRequest resolve = new ResolutionRequest();
        resolve.kind = resolution;
        Operation operation = Operation.createPatch(this.getUri()).setCompletion((o, e) -> {
            if (e != null) {
                this.logWarning("Failure self patching: %s", e.getMessage());
            }
        }).setBody(resolve);
        this.sendRequest(operation);
    }

    private void handleAbort(Operation op) {
        TransactionServiceState existing = (TransactionServiceState)this.getState(op);
        OperationJoin.create(this.createNotifyServicesToAbort(existing)).setCompletion((operations, failures) -> {
            if (failures != null) {
                this.logWarning("Transaction failed to abort: %s", failures.toString());
                return;
            }
            this.selfPatch(ResolutionKind.ABORTED);
        }).sendWith(this);
    }

    private void handleTryCommit(Operation op) {
        TransactionServiceState existing = (TransactionServiceState)this.getState(op);
        TransactionServiceState exchangeState = new TransactionServiceState();
        for (Set<String> serviceSet : existing.servicesToCoordinators.values()) {
            if (!serviceSet.contains(op.getReferer().toString())) continue;
            exchangeState.taskSubStage = SubStage.RESOLVING_CIRCULAR;
            if (this.compareTo(op.getReferer())) continue;
            existing.taskSubStage = SubStage.ABORTED;
        }
        this.setState(op, existing);
        op.setBodyNoCloning(exchangeState);
        op.complete();
    }

    private void handleEnsureCommit(Operation op) {
        TransactionServiceState existing = (TransactionServiceState)this.getState(op);
        TransactionServiceState exchangeState = new TransactionServiceState();
        existing.dependentLinks.add(op.getReferer().toString());
        this.setState(op, existing);
        op.setBodyNoCloning(exchangeState);
        op.complete();
    }

    private Collection<Operation> setOfTryPreceedOps(TransactionServiceState state) {
        HashSet<String> cache = new HashSet<String>();
        HashSet<Operation> operations = new HashSet<Operation>();
        for (String service : state.readLinks) {
            if (!state.servicesToCoordinators.containsKey(service)) continue;
            for (String coordinator : state.servicesToCoordinators.get(service)) {
                if (cache.contains(coordinator) || coordinator.equals(this.getUri().toString())) continue;
                cache.add(coordinator);
                operations.add(this.createNotifyOp(UriUtils.buildUri(coordinator), "try-commit", null, (o, e) -> {
                    if (e == null) {
                        SubStage s = o.getBody(SubStage.class);
                        if (s == SubStage.COMMITTED) {
                            state.dependentLinks.add(coordinator);
                        } else if (s == SubStage.RESOLVING_CIRCULAR && !this.compareTo(o.getReferer())) {
                            state.taskSubStage = SubStage.ABORTED;
                        }
                    }
                }));
            }
        }
        return operations;
    }

    private Collection<Operation> setOfEnsurePreceedOps(TransactionServiceState state) {
        HashSet<String> cache = new HashSet<String>();
        HashSet<Operation> operations = new HashSet<Operation>();
        for (String service : state.modifiedLinks) {
            if (!state.servicesToCoordinators.containsKey(service)) continue;
            for (String coordinator : state.servicesToCoordinators.get(service)) {
                if (cache.contains(coordinator) || coordinator.equals(this.getUri().toString())) continue;
                cache.add(coordinator);
                operations.add(this.createNotifyOp(UriUtils.buildUri(coordinator), "ensure-commit", null, (o, e) -> {
                    SubStage s;
                    if (e == null && (s = o.getBody(SubStage.class)) == SubStage.COMMITTED) {
                        state.taskSubStage = SubStage.ABORTED;
                    }
                }));
            }
        }
        return operations;
    }

    private boolean compareTo(URI remote) {
        return this.getUri().compareTo(remote) < 0;
    }

    private Collection<Operation> createNotifyServicesToAbort(TransactionServiceState state) {
        HashSet<Operation> operations = new HashSet<Operation>();
        for (String service : state.readLinks) {
            operations.add(this.createNotifyOp(UriUtils.buildUri(service), "abort"));
        }
        for (String service : state.modifiedLinks) {
            operations.add(this.createNotifyOp(UriUtils.buildUri(service), "abort"));
        }
        return operations;
    }

    private Collection<Operation> createNotifyServicesToCommit(TransactionServiceState state) {
        Collection operations = state.readLinks.stream().map(service -> this.createNotifyOp(UriUtils.buildUri(service), "commit")).collect(Collectors.toSet());
        operations.addAll(state.modifiedLinks.stream().map(service -> this.createNotifyOp(UriUtils.buildUri(service), "commit")).collect(Collectors.toList()));
        return operations;
    }

    private Operation createNotifyOp(URI service, String header) {
        return Operation.createPatch(service).addRequestHeader("x-xenon-tx-phase", header).setBody(new TransactionServiceState()).setReferer(this.getUri());
    }

    private Operation createNotifyOp(URI service, String header, Object body, Operation.CompletionHandler callback) {
        return Operation.createPatch(service).addRequestHeader("x-xenon-tx-phase", header).setReferer(this.getUri()).setBody(body).setCompletion(callback);
    }

    public static class TransactionServiceState
    extends ServiceDocument {
        public Set<String> readLinks;
        public Set<String> modifiedLinks;
        public LinkedHashMap<String, Set<String>> servicesToCoordinators;
        public TaskState taskInfo = new TaskState();
        public SubStage taskSubStage;
        public Set<String> dependentLinks;
        public Options options;
        public Set<String> failedLinks;
    }

    public static class ResolutionRequest {
        public ResolutionKind kind;
        public int pendingOperations;
    }

    public static class Options {
        public boolean allowErrorsCauseAbort = true;
    }

    public static enum ResolutionKind {
        COMMIT,
        ABORT,
        COMMITTED,
        ABORTED;

    }

    public static enum SubStage {
        COLLECTING,
        RESOLVING,
        RESOLVING_CIRCULAR,
        COMMITTED,
        ABORTED;

    }
}

