/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceDocumentDescription;
import com.vmware.xenon.common.StatefulService;

public class TenantService
extends StatefulService {
    public TenantService() {
        super(TenantState.class);
        super.toggleOption(Service.ServiceOption.PERSISTENCE, true);
        super.toggleOption(Service.ServiceOption.REPLICATION, true);
        super.toggleOption(Service.ServiceOption.OWNER_SELECTION, true);
    }

    @Override
    public void handlePatch(Operation patch) {
        TenantState currentState = (TenantState)this.getState(patch);
        TenantState newState = patch.getBody(TenantState.class);
        this.mergeState(currentState, newState);
        patch.complete();
    }

    private void mergeState(TenantState currentState, TenantState newState) {
        if (newState.name != null) {
            currentState.name = newState.name;
        }
        if (newState.parentLink != null) {
            currentState.parentLink = newState.parentLink;
        }
    }

    public static class TenantState
    extends ServiceDocument {
        @ServiceDocument.UsageOption(option=ServiceDocumentDescription.PropertyUsageOption.ID)
        public String id;
        @ServiceDocument.Documentation(exampleString="VMware Inc.")
        public String name;
        @ServiceDocument.UsageOption(option=ServiceDocumentDescription.PropertyUsageOption.OPTIONAL)
        @ServiceDocument.Documentation(description="The parent (if any) of this tenant")
        public String parentLink;
    }
}

