/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.http.netty;

import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.http.netty.NettyChannelContext;
import com.vmware.xenon.common.http.netty.NettyHttpClientRequestHandler;
import com.vmware.xenon.common.http.netty.NettyWebSocketRequestHandler;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;

public class NettyHttpServerInitializer
extends ChannelInitializer<SocketChannel> {
    public static final String AGGREGATOR_HANDLER = "aggregator";
    public static final String HTTP_REQUEST_HANDLER = "http-request-handler";
    public static final String WEBSOCKET_HANDLER = "websocket-request-handler";
    public static final String DECODER_HANDLER = "decoder";
    public static final String ENCODER_HANDLER = "encoder";
    public static final String SSL_HANDLER = "ssl";
    private final SslContext sslContext;
    private ServiceHost host;

    public NettyHttpServerInitializer(ServiceHost host, SslContext sslContext) {
        this.sslContext = sslContext;
        this.host = host;
    }

    public void initChannel(SocketChannel ch) {
        ChannelPipeline p = ch.pipeline();
        ch.config().setAllocator((ByteBufAllocator)NettyChannelContext.ALLOCATOR);
        ch.config().setSendBufferSize(65536);
        ch.config().setReceiveBufferSize(65536);
        SslHandler sslHandler = null;
        if (this.sslContext != null) {
            sslHandler = this.sslContext.newHandler(ch.alloc());
            ServiceHost.ServiceHostState.SslClientAuthMode mode = this.host.getState().sslClientAuthMode;
            if (mode != null) {
                switch (mode) {
                    case NEED: {
                        sslHandler.engine().setNeedClientAuth(true);
                        break;
                    }
                    case WANT: {
                        sslHandler.engine().setWantClientAuth(true);
                        break;
                    }
                }
            }
            p.addLast(SSL_HANDLER, (ChannelHandler)sslHandler);
        }
        p.addLast(DECODER_HANDLER, (ChannelHandler)new HttpRequestDecoder(4096, 65536, 65536, false));
        p.addLast(ENCODER_HANDLER, (ChannelHandler)new HttpResponseEncoder());
        p.addLast(AGGREGATOR_HANDLER, (ChannelHandler)new HttpObjectAggregator(NettyChannelContext.getMaxRequestSize()));
        p.addLast(WEBSOCKET_HANDLER, (ChannelHandler)new NettyWebSocketRequestHandler(this.host, "/core/ws-endpoint", "/ws-service"));
        p.addLast(HTTP_REQUEST_HANDLER, (ChannelHandler)new NettyHttpClientRequestHandler(this.host, sslHandler));
    }
}

