/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.http.netty;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.http.netty.NettyChannelContext;
import com.vmware.xenon.common.http.netty.NettyChannelPool;
import com.vmware.xenon.common.http.netty.NettyHttpServerResponseHandler;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestEncoder;
import io.netty.handler.codec.http.HttpResponseDecoder;
import io.netty.handler.ssl.SslHandler;
import javax.net.ssl.SSLEngine;

public class NettyHttpClientRequestInitializer
extends ChannelInitializer<SocketChannel> {
    public static final String AGGREGATOR_HANDLER = "aggregator";
    public static final String DCP_HANDLER = "dcp";
    public static final String DECODER_HANDLER = "decoder";
    public static final String ENCODER_HANDLER = "encoder";
    public static final String SSL_HANDLER = "ssl";
    private final NettyChannelPool pool;

    public NettyHttpClientRequestInitializer(NettyChannelPool nettyChannelPool) {
        this.pool = nettyChannelPool;
    }

    public void initChannel(SocketChannel ch) {
        ChannelPipeline p = ch.pipeline();
        ch.config().setAllocator((ByteBufAllocator)NettyChannelContext.ALLOCATOR);
        ch.config().setSendBufferSize(65536);
        ch.config().setReceiveBufferSize(65536);
        if (this.pool.getSSLContext() != null) {
            SSLEngine engine = this.pool.getSSLContext().createSSLEngine();
            engine.setUseClientMode(true);
            p.addLast(SSL_HANDLER, (ChannelHandler)new SslHandler(engine));
        }
        p.addLast(ENCODER_HANDLER, (ChannelHandler)new HttpRequestEncoder());
        p.addLast(DECODER_HANDLER, (ChannelHandler)new HttpResponseDecoder(4096, 65536, 65536, false));
        p.addLast(AGGREGATOR_HANDLER, (ChannelHandler)new HttpObjectAggregator(Operation.SocketContext.getMaxClientRequestSize()));
        p.addLast(DCP_HANDLER, (ChannelHandler)new NettyHttpServerResponseHandler(this.pool));
    }
}

