/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.Utils;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public class ServiceErrorResponse {
    public static final String KIND = Utils.buildKind(ServiceErrorResponse.class);
    public String message;
    public String messageId;
    public List<String> stackTrace;
    public int statusCode;
    public EnumSet<ErrorDetail> details;
    public String documentKind = KIND;

    public static ServiceErrorResponse create(Throwable e, int statusCode) {
        return ServiceErrorResponse.create(e, statusCode, null);
    }

    public static ServiceErrorResponse create(Throwable e, int statusCode, EnumSet<ErrorDetail> details) {
        ServiceErrorResponse rsp = new ServiceErrorResponse();
        rsp.message = e.getLocalizedMessage();
        rsp.stackTrace = new ArrayList<String>();
        for (StackTraceElement se : e.getStackTrace()) {
            rsp.stackTrace.add(se.toString());
        }
        rsp.details = details;
        rsp.statusCode = statusCode;
        return rsp;
    }

    public static enum ErrorDetail {
        SHOULD_RETRY;

    }
}

