/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.OperationProcessingChain;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.ServiceStats;
import java.net.URI;
import java.util.EnumSet;

public interface Service {
    public static final String STAT_NAME_REQUEST_COUNT = "requestCount";
    public static final String STAT_NAME_PRE_AVAILABLE_OP_COUNT = "preAvailableReceivedOperationCount";
    public static final String STAT_NAME_FAILURE_COUNT = "failureCount";
    public static final String STAT_NAME_REQUEST_OUT_OF_ORDER_COUNT = "requestOutOfOrderCount";
    public static final String STAT_NAME_STATE_PERSIST_LATENCY = "statePersistLatencyMicros";
    public static final String STAT_NAME_OPERATION_QUEUEING_LATENCY = "operationQueueingLatencyMicros";
    public static final String STAT_NAME_SERVICE_HANDLER_LATENCY = "operationHandlerProcessingLatencyMicros";
    public static final String STAT_NAME_OPERATION_DURATION = "operationDuration";
    public static final String STAT_NAME_MAINTENANCE_COUNT = "maintenanceCount";
    public static final String STAT_NAME_NODE_GROUP_CHANGE_MAINTENANCE_COUNT = "maintenanceForNodeGroupChangeCount";
    public static final String STAT_NAME_NODE_GROUP_CHANGE_PENDING_MAINTENANCE_COUNT = "pendingMaintenanceForNodeGroupChangeCount";
    public static final String STAT_NAME_MAINTENANCE_COMPLETION_DELAYED_COUNT = "maintenanceCompletionDelayedCount";
    public static final String STAT_NAME_CACHE_MISS_COUNT = "stateCacheMissCount";
    public static final String STAT_NAME_CACHE_CLEAR_COUNT = "stateCacheClearCount";
    public static final String STAT_NAME_VERSION_CONFLICT_COUNT = "stateVersionConflictCount";
    public static final String STAT_NAME_VERSION_IN_CONFLICT = "stateVersionInConflict";
    public static final String STAT_NAME_PAUSE_COUNT = "pauseCount";
    public static final String STAT_NAME_RESUME_COUNT = "resumeCount";
    public static final int MAX_SERIALIZED_SIZE_BYTES = 8192;
    public static final int OPERATION_QUEUE_DEFAULT_LIMIT = 10000;

    public void handleStart(Operation var1);

    public boolean queueRequest(Operation var1);

    public Operation dequeueRequest();

    public void handleRequest(Operation var1);

    public void handleRequest(Operation var1, OperationProcessingStage var2);

    public void sendRequest(Operation var1);

    public void handleConfigurationRequest(Operation var1);

    public void handleMaintenance(Operation var1);

    public void setMaintenanceIntervalMicros(long var1);

    public long getMaintenanceIntervalMicros();

    public ServiceHost getHost();

    public String getSelfLink();

    public URI getUri();

    public OperationProcessingChain getOperationProcessingChain();

    public ProcessingStage getProcessingStage();

    public EnumSet<ServiceOption> getOptions();

    public boolean hasOption(ServiceOption var1);

    public void toggleOption(ServiceOption var1, boolean var2);

    public void setPeerNodeSelectorPath(String var1);

    public String getPeerNodeSelectorPath();

    public ServiceStats.ServiceStat getStat(String var1);

    public void adjustStat(String var1, double var2);

    public void adjustStat(ServiceStats.ServiceStat var1, double var2);

    public void setStat(String var1, double var2);

    public void setStat(ServiceStats.ServiceStat var1, double var2);

    public void setHost(ServiceHost var1);

    public void setSelfLink(String var1);

    public void setOperationProcessingChain(OperationProcessingChain var1);

    public void setProcessingStage(ProcessingStage var1);

    public ServiceDocument setInitialState(String var1, Long var2);

    public void setState(Operation var1, ServiceDocument var2);

    public <T extends ServiceDocument> T getState(Operation var1);

    public Service getUtilityService(String var1);

    public Class<? extends ServiceDocument> getStateType();

    public ServiceDocument getDocumentTemplate();

    public static enum OperationProcessingStage {
        LOADING_STATE,
        PROCESSING_FILTERS,
        EXECUTING_SERVICE_HANDLER;

    }

    public static enum ProcessingStage {
        CREATED,
        INITIALIZING,
        LOADING_INITIAL_STATE,
        SYNCHRONIZING,
        EXECUTING_START_HANDLER,
        INDEXING_INITIAL_STATE,
        AVAILABLE,
        PAUSED,
        STOPPED;

    }

    public static enum ServiceOption {
        INSTRUMENTATION,
        PERIODIC_MAINTENANCE,
        PERSISTENCE,
        REPLICATION,
        OWNER_SELECTION,
        ENFORCE_QUORUM,
        STRICT_UPDATE_CHECKING,
        HTML_USER_INTERFACE,
        CONCURRENT_UPDATE_HANDLING,
        IDEMPOTENT_POST,
        UTILITY,
        FACTORY,
        FACTORY_ITEM,
        DOCUMENT_OWNER,
        LIFO_QUEUE,
        NONE;

    }

    public static enum Action {
        GET,
        POST,
        PATCH,
        PUT,
        DELETE,
        OPTIONS;

    }
}

