/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.TaskState;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.QueryTask;
import com.vmware.xenon.services.common.ServiceUriPaths;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class QueryTaskClientHelper<T extends ServiceDocument> {
    public static final long QUERY_RETRIEVAL_RETRY_INTERVAL_MILLIS = Long.getLong("xenon.querytaskclienthelper.query.retry.interval.millis", 300L);
    public static final long DEFAULT_EXPIRATION_TIME_IN_MICROS = Long.getLong("xenon.querytaskclienthelper.query.documents.default.expiration.millis", TimeUnit.SECONDS.toMicros(120L));
    public static final Integer DEFAULT_QUERY_RESULT_LIMIT = Integer.getInteger("xenon.querytaskclienthelper.query.documents.default.resultLimit", 50);
    private final Class<T> type;
    private ServiceHost host;
    private QueryTask queryTask;
    private ResultHandler<T> resultHandler;

    private QueryTaskClientHelper(Class<T> type) {
        this.type = type;
    }

    public static <T extends ServiceDocument> QueryTaskClientHelper<T> create(Class<T> type) {
        return new QueryTaskClientHelper<T>(type);
    }

    public QueryTaskClientHelper<T> setDocumentLink(String documentSelfLink) {
        this.setUpdatedDocumentSince(-1L, documentSelfLink);
        return this;
    }

    public QueryTaskClientHelper<T> setUpdatedDocumentSince(long documentSinceUpdateTimeMicros, String documentSelfLink) {
        QueryTaskClientHelper.assertNotNull(documentSelfLink, "documentSelfLink");
        QueryTask.Query query = QueryTask.Query.Builder.create().addKindFieldClause(this.type).addFieldClause("documentSelfLink", documentSelfLink).build();
        QueryTask q = QueryTask.Builder.createDirectTask().addOption(QueryTask.QuerySpecification.QueryOption.EXPAND_CONTENT).setQuery(query).build();
        if (documentSinceUpdateTimeMicros != -1L) {
            q.querySpec.options.add(QueryTask.QuerySpecification.QueryOption.INCLUDE_DELETED);
            q.querySpec.query.addBooleanClause(this.createUpdatedSinceTimeRange(documentSinceUpdateTimeMicros));
        }
        this.setQueryTask(q);
        return this;
    }

    public QueryTaskClientHelper<T> setUpdatedSince(long documentSinceUpdateTimeMicros) {
        long nowMicrosUtc = Utils.getNowMicrosUtc();
        if (nowMicrosUtc < documentSinceUpdateTimeMicros) {
            throw new IllegalArgumentException("'documentSinceUpdateTimeMicros' must be in the past.");
        }
        QueryTask.Query query = QueryTask.Query.Builder.create().addKindFieldClause(this.type).addClause(this.createUpdatedSinceTimeRange(documentSinceUpdateTimeMicros)).build();
        QueryTask q = QueryTask.Builder.createDirectTask().addOption(QueryTask.QuerySpecification.QueryOption.EXPAND_CONTENT).addOption(QueryTask.QuerySpecification.QueryOption.INCLUDE_DELETED).setResultLimit(DEFAULT_QUERY_RESULT_LIMIT).setQuery(query).build();
        this.setQueryTask(q);
        return this;
    }

    public QueryTaskClientHelper<T> sendWith(ServiceHost serviceHost) {
        QueryTaskClientHelper.assertNotNull(serviceHost, "'serviceHost' must not be null.");
        this.host = serviceHost;
        this.sendQueryRequest();
        return this;
    }

    public QueryTaskClientHelper<T> setQueryTask(QueryTask queryTask) {
        QueryTaskClientHelper.assertNotNull(queryTask, "'queryTask' must not be null.");
        if (queryTask.documentExpirationTimeMicros == 0L) {
            queryTask.documentExpirationTimeMicros = QueryTaskClientHelper.getDefaultQueryExpiration();
        }
        this.queryTask = queryTask;
        return this;
    }

    public QueryTaskClientHelper<T> setResultHandler(ResultHandler<T> resultHandler) {
        QueryTaskClientHelper.assertNotNull(resultHandler, "'resultHandler' must not be null.");
        this.resultHandler = resultHandler;
        return this;
    }

    public static long getDefaultQueryExpiration() {
        return Utils.getNowMicrosUtc() + DEFAULT_EXPIRATION_TIME_IN_MICROS;
    }

    private void sendQueryRequest() {
        QueryTaskClientHelper.assertNotNull(this.queryTask, "'queryTask' must be set first.");
        QueryTaskClientHelper.assertNotNull(this.resultHandler, "'resultHandler' must be set first.");
        this.host.sendRequest(Operation.createPost(UriUtils.buildUri(this.host, ServiceUriPaths.CORE_QUERY_TASKS)).setBody(this.queryTask).setReferer(this.host.getUri()).setCompletion((o, e) -> {
            if (e != null) {
                this.resultHandler.handle(QueryTaskClientHelper.noResult(), e);
                return;
            }
            QueryTask qrt = o.getBody(QueryTask.class);
            this.processQuery(qrt, this.resultHandler);
        }));
    }

    private void processQuery(QueryTask q, ResultHandler<T> handler) {
        if (TaskState.isFailed(q.taskInfo)) {
            handler.handle(QueryTaskClientHelper.noResult(), new IllegalStateException(q.taskInfo.failure.message));
            return;
        }
        if (q.taskInfo.isDirect || TaskState.isFinished(q.taskInfo)) {
            this.processQueryResult(q, handler);
            return;
        }
        this.host.sendRequest(Operation.createGet(UriUtils.buildUri(this.host, q.documentSelfLink)).setReferer(this.host.getUri()).setCompletion((o, e) -> {
            if (e != null) {
                handler.handle(QueryTaskClientHelper.noResult(), e);
                return;
            }
            QueryTask rsp = o.getBody(QueryTask.class);
            if (!TaskState.isFinished(rsp.taskInfo)) {
                this.host.log(Level.FINE, "Resource query not complete yet, retrying...", new Object[0]);
                this.host.schedule(() -> this.processQuery(rsp, handler), QUERY_RETRIEVAL_RETRY_INTERVAL_MILLIS, TimeUnit.MILLISECONDS);
                return;
            }
            this.processQueryResult(rsp, handler);
        }));
    }

    private void processQueryResult(QueryTask rsp, ResultHandler<T> handler) {
        if (rsp.querySpec.resultLimit != null && rsp.querySpec.resultLimit != Integer.MAX_VALUE) {
            this.getNextPageLinks(rsp.results.nextPageLink, rsp.querySpec.resultLimit, handler);
            return;
        }
        this.processResults(rsp, handler);
    }

    private void processResults(QueryTask rsp, ResultHandler<T> handler) {
        List<String> links = rsp.results.documentLinks;
        if (this.isExpandQuery(rsp)) {
            if (rsp.results.documents.isEmpty()) {
                handler.handle(QueryTaskClientHelper.noResult(), null);
            } else {
                long count = links.size();
                for (String documentLink : links) {
                    handler.handle(this.result(rsp.results.documents.get(documentLink), count), null);
                }
                handler.handle(QueryTaskClientHelper.noResult(), null);
            }
        } else if (this.isCountQuery(rsp)) {
            handler.handle(QueryTaskClientHelper.countResult(rsp.results.documentCount), null);
            handler.handle(QueryTaskClientHelper.noResult(), null);
        } else if (links == null || links.isEmpty()) {
            handler.handle(QueryTaskClientHelper.noResult(), null);
        } else {
            for (String selfLink : links) {
                handler.handle(QueryTaskClientHelper.resultLink(selfLink, links.size()), null);
            }
            handler.handle(QueryTaskClientHelper.noResult(), null);
        }
    }

    private void getNextPageLinks(String nextPageLink, int resultLimit, ResultHandler<T> handler) {
        try {
            if (nextPageLink == null) {
                handler.handle(QueryTaskClientHelper.noResult(), null);
                return;
            }
            this.host.sendRequest(Operation.createGet(UriUtils.buildUri(this.host, nextPageLink)).setReferer(this.host.getUri()).setCompletion((o, e) -> {
                if (e != null) {
                    handler.handle(QueryTaskClientHelper.noResult(), e);
                    return;
                }
                try {
                    QueryTask page = o.getBody(QueryTask.class);
                    if (this.isExpandQuery(page)) {
                        Collection<Object> values = page.results.documents.values();
                        for (Object json : values) {
                            handler.handle(this.result(json, values.size()), null);
                        }
                    } else if (this.isCountQuery(page)) {
                        handler.handle(QueryTaskClientHelper.countResult(page.results.documentCount), null);
                    } else {
                        List<String> links = page.results.documentLinks;
                        for (String link : links) {
                            handler.handle(QueryTaskClientHelper.resultLink(link, links.size()), null);
                        }
                    }
                    this.getNextPageLinks(page.results.nextPageLink, resultLimit, handler);
                }
                catch (Throwable ex) {
                    handler.handle(QueryTaskClientHelper.noResult(), ex);
                }
            }));
        }
        catch (Throwable ex) {
            handler.handle(QueryTaskClientHelper.noResult(), ex);
        }
    }

    private boolean isExpandQuery(QueryTask q) {
        return q.querySpec.options != null && q.querySpec.options.contains((Object)QueryTask.QuerySpecification.QueryOption.EXPAND_CONTENT);
    }

    private boolean isCountQuery(QueryTask q) {
        return q.querySpec.options != null && q.querySpec.options.contains((Object)QueryTask.QuerySpecification.QueryOption.COUNT);
    }

    private QueryTask.Query createUpdatedSinceTimeRange(long timeInMicros) {
        long limitToNowInMicros = Utils.getNowMicrosUtc() + TimeUnit.SECONDS.toMicros(10L);
        QueryTask.NumericRange<Long> range = QueryTask.NumericRange.createLongRange(timeInMicros, limitToNowInMicros, true, false);
        range.precisionStep = 64;
        QueryTask.Query latestSinceCondition = new QueryTask.Query().setTermPropertyName("documentUpdateTimeMicros").setNumericRange(range).setTermMatchType(QueryTask.QueryTerm.MatchType.TERM);
        latestSinceCondition.occurance = QueryTask.Query.Occurance.MUST_OCCUR;
        return latestSinceCondition;
    }

    private static void assertNotNull(Object value, String propertyName) {
        if (value == null) {
            throw new IllegalArgumentException("'" + propertyName + "' is required");
        }
    }

    public QueryElementResult<T> result(Object json, long count) {
        QueryElementResult r = new QueryElementResult();
        r.result = (ServiceDocument)Utils.fromJson(json, this.type);
        r.documentSelfLink = r.result.documentSelfLink;
        r.count = count;
        return r;
    }

    public static <S extends ServiceDocument> QueryElementResult<S> resultLink(String selfLink, long count) {
        QueryElementResult r = new QueryElementResult();
        r.documentSelfLink = selfLink;
        r.count = count;
        return r;
    }

    public static <S extends ServiceDocument> QueryElementResult<S> countResult(long count) {
        QueryElementResult r = new QueryElementResult();
        r.count = count;
        return r;
    }

    public static <S extends ServiceDocument> QueryElementResult<S> noResult() {
        return new QueryElementResult();
    }

    @FunctionalInterface
    public static interface ResultHandler<T extends ServiceDocument> {
        public void handle(QueryElementResult<T> var1, Throwable var2);
    }

    public static class QueryElementResult<T extends ServiceDocument> {
        private T result;
        private String documentSelfLink;
        private long count;

        public boolean hasResult() {
            return this.result != null || this.documentSelfLink != null || this.count > 0L;
        }

        public T getResult() {
            return this.result;
        }

        public String getDocumentSelfLink() {
            return this.documentSelfLink;
        }

        public long getCount() {
            return this.count;
        }
    }
}

