/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.StatefulService;
import com.vmware.xenon.common.StatelessService;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.services.common.TransactionService;
import java.net.UnknownHostException;

public class TransactionResolutionService
extends StatelessService {
    public static final String RESOLUTION_SUFFIX = "/resolve";
    StatefulService parent;

    public TransactionResolutionService(StatefulService parent) {
        this.parent = parent;
    }

    @Override
    public void handleRequest(Operation op) {
        if (op.getUri().getPath().endsWith(RESOLUTION_SUFFIX)) {
            this.handleResolutionRequest(op);
        } else {
            op.fail(new UnknownHostException());
        }
    }

    public void handleResolutionRequest(Operation op) {
        Operation subscribeToCoordinator = Operation.createPost(UriUtils.buildSubscriptionUri(this.parent.getUri())).setCompletion((o, e) -> {
            if (e != null) {
                op.fail(e);
                return;
            }
        }).setReferer(this.getUri());
        this.getHost().startSubscriptionService(subscribeToCoordinator, notifyOp -> {
            TransactionService.ResolutionRequest resolve = notifyOp.getBody(TransactionService.ResolutionRequest.class);
            notifyOp.complete();
            if (this.isNotComplete(resolve.kind)) {
                return;
            }
            op.setBodyNoCloning(notifyOp.getBodyRaw());
            op.setStatusCode(notifyOp.getStatusCode());
            op.complete();
        });
        TransactionService.ResolutionRequest resolve = op.getBody(TransactionService.ResolutionRequest.class);
        Operation operation = Operation.createPatch(this.parent.getUri()).setBody(resolve);
        this.sendRequest(operation);
    }

    private boolean isNotComplete(TransactionService.ResolutionKind kind) {
        return kind != TransactionService.ResolutionKind.COMMITTED && kind != TransactionService.ResolutionKind.ABORTED;
    }
}

