/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.OperationJoin;
import com.vmware.xenon.common.OperationProcessingChain;
import com.vmware.xenon.common.RequestRouter;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.StatefulService;
import com.vmware.xenon.common.TaskState;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.SimpleTransactionFactoryService;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.logging.Level;

public class SimpleTransactionService
extends StatefulService {
    static final String PRAGMA_DIRECTIVE_DELETE_ON_TRANSACTION_END = "dcp-simpletx-delete-on-transaction-end";

    public static URI buildTransactionUri(ServiceHost host, String selfLink) {
        return UriUtils.extendUri(UriUtils.buildUri(host, SimpleTransactionFactoryService.SELF_LINK), selfLink);
    }

    public SimpleTransactionService() {
        super(SimpleTransactionServiceState.class);
        this.toggleOption(Service.ServiceOption.PERSISTENCE, true);
        this.toggleOption(Service.ServiceOption.REPLICATION, true);
        this.toggleOption(Service.ServiceOption.INSTRUMENTATION, true);
        this.toggleOption(Service.ServiceOption.OWNER_SELECTION, true);
    }

    @Override
    public OperationProcessingChain getOperationProcessingChain() {
        if (super.getOperationProcessingChain() != null) {
            return super.getOperationProcessingChain();
        }
        RequestRouter myRouter = new RequestRouter();
        myRouter.register(Service.Action.PATCH, new RequestRouter.RequestBodyMatcher<EnrollRequest>(EnrollRequest.class, "kind", EnrollRequest.KIND), this::handlePatchForEnroll, "Register service");
        myRouter.register(Service.Action.PATCH, new RequestRouter.RequestBodyMatcher<EndTransactionRequest>(EndTransactionRequest.class, "kind", EndTransactionRequest.KIND), this::handlePatchForEndTransaction, "Commit or abort transaction");
        OperationProcessingChain opProcessingChain = new OperationProcessingChain(this);
        opProcessingChain.add(myRouter);
        this.setOperationProcessingChain(opProcessingChain);
        return opProcessingChain;
    }

    @Override
    public void handleStart(Operation start) {
        SimpleTransactionServiceState state;
        SimpleTransactionServiceState simpleTransactionServiceState = state = start.hasBody() ? start.getBody(SimpleTransactionServiceState.class) : new SimpleTransactionServiceState();
        if (state == null) {
            start.fail(new IllegalArgumentException("faild to parse provided state"));
            return;
        }
        if (state.taskInfo == null) {
            state.taskInfo = new TaskState();
            state.taskInfo.stage = TaskState.TaskStage.STARTED;
        }
        if (state.enrolledServices == null) {
            state.enrolledServices = new HashMap<String, EnrollmentInfo>();
        }
        if (state.createdServicesLinks == null) {
            state.createdServicesLinks = new HashSet<String>();
        }
        if (state.deletedServicesLinks == null) {
            state.deletedServicesLinks = new HashSet<String>();
        }
        start.setBody(state).complete();
    }

    void handlePatchForEnroll(Operation patch) {
        SimpleTransactionServiceState currentState = (SimpleTransactionServiceState)this.getState(patch);
        EnrollRequest body = patch.getBody(EnrollRequest.class);
        if (TaskState.TaskStage.STARTED != currentState.taskInfo.stage) {
            patch.fail(new IllegalArgumentException(String.format("Transaction stage %s is not in the right stage", new Object[]{currentState.taskInfo.stage})));
            return;
        }
        if (body.serviceSelfLink == null) {
            patch.fail(new IllegalArgumentException("Cannot register null service selfLink"));
            return;
        }
        EnrollmentInfo enrollmentInfo = currentState.enrolledServices.get(body.serviceSelfLink);
        if (enrollmentInfo == null) {
            enrollmentInfo = new EnrollmentInfo();
            enrollmentInfo.isUpdated = body.action != Service.Action.GET;
            enrollmentInfo.originalVersion = body.previousVersion;
            currentState.enrolledServices.put(body.serviceSelfLink, enrollmentInfo);
        } else {
            boolean bl = enrollmentInfo.isUpdated = enrollmentInfo.isUpdated || body.action != Service.Action.GET;
        }
        if (body.action == Service.Action.POST) {
            currentState.createdServicesLinks.add(body.serviceSelfLink);
        }
        if (body.action == Service.Action.DELETE) {
            currentState.deletedServicesLinks.add(body.serviceSelfLink);
        }
        patch.complete();
    }

    void handlePatchForEndTransaction(Operation patch) {
        SimpleTransactionServiceState currentState = (SimpleTransactionServiceState)this.getState(patch);
        EndTransactionRequest body = patch.getBody(EndTransactionRequest.class);
        if (TaskState.TaskStage.STARTED != currentState.taskInfo.stage) {
            patch.fail(new IllegalArgumentException(String.format("Transaction stage %s is not in the right stage", new Object[]{currentState.taskInfo.stage})));
            return;
        }
        switch (body.transactionOutcome) {
            case COMMIT: {
                currentState.taskInfo.stage = TaskState.TaskStage.FINISHED;
                break;
            }
            case ABORT: {
                currentState.taskInfo.stage = TaskState.TaskStage.CANCELLED;
                break;
            }
            default: {
                patch.fail(new IllegalArgumentException(String.format("Unrecognized transaction outcome: %s", new Object[]{body.transactionOutcome})));
                return;
            }
        }
        String transactionId = this.getSelfLink().substring(this.getSelfLink().lastIndexOf("/") + 1);
        Collection<Operation> deleteRequests = this.createDeleteRequests(currentState, body.transactionOutcome);
        Collection<Operation> clearTransactionRequests = this.createClearTransactionRequests(currentState, transactionId, body.transactionOutcome);
        if (deleteRequests != null && !deleteRequests.isEmpty()) {
            this.deleteServicesAndClearTransactions(patch, transactionId, deleteRequests, clearTransactionRequests);
        } else if (clearTransactionRequests != null && !clearTransactionRequests.isEmpty()) {
            this.clearTransactions(patch, transactionId, clearTransactionRequests);
        } else {
            patch.complete();
        }
    }

    private void deleteServicesAndClearTransactions(Operation patch, String transactionId, Collection<Operation> deleteRequests, Collection<Operation> clearTransactionRequests) {
        OperationJoin.create(deleteRequests).setCompletion((ops, exs) -> {
            if (exs != null) {
                patch.fail(new IllegalStateException(String.format("Transaction %s failed to delete some services", transactionId)));
                return;
            }
            if (clearTransactionRequests != null && !clearTransactionRequests.isEmpty()) {
                this.clearTransactions(patch, transactionId, clearTransactionRequests);
            } else {
                patch.complete();
            }
        }).sendWith(this);
    }

    private void clearTransactions(Operation patch, String transactionId, Collection<Operation> clearTransactionRequests) {
        OperationJoin.create(clearTransactionRequests).setCompletion((ops, exs) -> {
            if (exs != null) {
                patch.fail(new IllegalStateException(String.format("Transaction %s failed to clear from some services", transactionId)));
                return;
            }
            patch.complete();
        }).sendWith(this);
    }

    private Collection<Operation> createClearTransactionRequests(SimpleTransactionServiceState currentState, String transactionId, EndTransactionRequest.TransactionOutcome transactionOutcome) {
        if (currentState.enrolledServices.isEmpty()) {
            return null;
        }
        ArrayList<Operation> requests = new ArrayList<Operation>(currentState.enrolledServices.size());
        for (String serviceSelfLink : currentState.enrolledServices.keySet()) {
            EnrollmentInfo enrollmentInfo = currentState.enrolledServices.get(serviceSelfLink);
            ClearTransactionRequest body = new ClearTransactionRequest();
            body.kind = ClearTransactionRequest.KIND;
            body.transactionOutcome = transactionOutcome;
            body.isUpdated = enrollmentInfo.isUpdated;
            body.originalVersion = enrollmentInfo.originalVersion;
            Operation op = Operation.createPatch(UriUtils.buildUri(this.getHost(), serviceSelfLink)).setTransactionId(transactionId).setBody(body);
            requests.add(op);
        }
        return requests;
    }

    private Collection<Operation> createDeleteRequests(SimpleTransactionServiceState currentState, EndTransactionRequest.TransactionOutcome transactionOutcome) {
        Set<String> servicesToBDeleted;
        Set<String> set = servicesToBDeleted = transactionOutcome == EndTransactionRequest.TransactionOutcome.COMMIT ? currentState.deletedServicesLinks : currentState.createdServicesLinks;
        if (servicesToBDeleted.isEmpty()) {
            return null;
        }
        ArrayList<Operation> requests = new ArrayList<Operation>(servicesToBDeleted.size());
        for (String serviceSelfLink : servicesToBDeleted) {
            Operation op = Operation.createDelete(UriUtils.buildUri(this.getHost(), serviceSelfLink));
            op.addPragmaDirective(PRAGMA_DIRECTIVE_DELETE_ON_TRANSACTION_END);
            requests.add(op);
            currentState.enrolledServices.remove(serviceSelfLink);
        }
        return requests;
    }

    public static class TransactionalRequestFilter
    implements Predicate<Operation> {
        private Service service;

        public TransactionalRequestFilter(Service service) {
            this.service = service;
        }

        @Override
        public boolean test(Operation request) {
            ClearTransactionRequest clearTransactionRequest = this.getIfClearTransactionRequest(request);
            if (clearTransactionRequest != null) {
                this.handleClearTransaction(request, (ServiceDocument)this.service.getState(request), clearTransactionRequest);
                return false;
            }
            if (this.validateTransactionConflictsAndMarkState(request, (ServiceDocument)this.service.getState(request))) {
                request.fail(new IllegalStateException("transactional conflict"));
                return false;
            }
            if (request.getTransactionId() != null) {
                this.handleEnrollInTransaction(request);
                return false;
            }
            return true;
        }

        private ClearTransactionRequest getIfClearTransactionRequest(Operation request) {
            if (request.getTransactionId() == null || !request.hasBody()) {
                return null;
            }
            try {
                ClearTransactionRequest op = request.getBody(ClearTransactionRequest.class);
                if (op == null || op.kind != ClearTransactionRequest.KIND) {
                    return null;
                }
                return op;
            }
            catch (Exception ex) {
                return null;
            }
        }

        private boolean validateTransactionConflictsAndMarkState(Operation request, ServiceDocument currentState) {
            if (currentState == null) {
                return false;
            }
            String requestTransactionId = request.getTransactionId();
            String currentStateTransactionId = currentState.documentTransactionId;
            if (request.getAction() == Service.Action.GET) {
                if (requestTransactionId == null) {
                    if (currentStateTransactionId == null) {
                        return false;
                    }
                    this.logTransactionConflict(request, currentState);
                    return true;
                }
                if (currentStateTransactionId == null) {
                    currentState.documentTransactionId = requestTransactionId;
                    return false;
                }
                if (requestTransactionId.equals(currentStateTransactionId)) {
                    return false;
                }
                this.logTransactionConflict(request, currentState);
                return true;
            }
            if (requestTransactionId == null) {
                if (currentStateTransactionId == null || request.hasPragmaDirective(SimpleTransactionService.PRAGMA_DIRECTIVE_DELETE_ON_TRANSACTION_END)) {
                    return false;
                }
                this.logTransactionConflict(request, currentState);
                return true;
            }
            if (currentStateTransactionId == null) {
                currentState.documentTransactionId = requestTransactionId;
                return false;
            }
            if (requestTransactionId.equals(currentStateTransactionId)) {
                return false;
            }
            this.logTransactionConflict(request, currentState);
            return true;
        }

        private void handleClearTransaction(Operation request, ServiceDocument currentState, ClearTransactionRequest clearTransactionRequest) {
            if (currentState == null) {
                request.complete();
                return;
            }
            if (!request.getTransactionId().equals(currentState.documentTransactionId)) {
                request.fail(new IllegalStateException(String.format("Request to clear transaction %s from service %s but current transaction is: %s", request.getTransactionId(), this.service.getSelfLink(), currentState.documentTransactionId)));
                return;
            }
            if (clearTransactionRequest.transactionOutcome == EndTransactionRequest.TransactionOutcome.ABORT && clearTransactionRequest.isUpdated) {
                URI previousStateQueryUri = UriUtils.buildDocumentQueryUri(this.service.getHost(), this.service.getSelfLink(), false, false, Service.ServiceOption.PERSISTENCE);
                previousStateQueryUri = UriUtils.appendQueryParam(previousStateQueryUri, "documentVersion", Long.toString(clearTransactionRequest.originalVersion));
                Operation previousStateGet = Operation.createGet(previousStateQueryUri).setCompletion((o, e) -> {
                    if (e != null) {
                        request.fail(e);
                        return;
                    }
                    ServiceDocument previousState = (ServiceDocument)o.getBody(currentState.getClass());
                    this.service.getHost().log(Level.INFO, "Aborting transaction %s on service %s, current version %d, restoring version %d", request.getTransactionId(), this.service.getSelfLink(), currentState.documentVersion, clearTransactionRequest.originalVersion);
                    previousState.documentTransactionId = null;
                    this.service.setState(request, previousState);
                    request.complete();
                });
                this.service.sendRequest(previousStateGet);
            } else {
                currentState.documentTransactionId = null;
                request.complete();
            }
        }

        private void handleEnrollInTransaction(Operation request) {
            String serviceSelfLink = this.service.getSelfLink();
            if (Service.Action.POST == request.getAction()) {
                ServiceDocument body = request.getBody(ServiceDocument.class);
                if (body.documentSelfLink == null) {
                    body.documentSelfLink = UUID.randomUUID().toString();
                }
                serviceSelfLink = UriUtils.buildUriPath(serviceSelfLink, body.documentSelfLink);
            }
            long servicePreviousVersion = this.service.getState(request) == null ? -1L : ((ServiceDocument)this.service.getState((Operation)request)).documentVersion;
            Operation enrollRequest = TxUtils.buildEnrollRequest(this.service.getHost(), request.getTransactionId(), serviceSelfLink, request.getAction(), servicePreviousVersion).setCompletion((o, e) -> {
                if (e != null) {
                    request.fail(e);
                    return;
                }
                this.service.getOperationProcessingChain().resumeProcessingRequest(request, this);
            });
            this.service.sendRequest(enrollRequest);
        }

        private void logTransactionConflict(Operation request, ServiceDocument currentState) {
            this.service.getHost().log(Level.INFO, "Transaction %s conflicts on service %s: operation: %s, current state transaction: %s", new Object[]{request.getTransactionId(), this.service.getSelfLink(), request.getAction(), currentState.documentTransactionId});
        }
    }

    public static class ClearTransactionRequest {
        public static final String KIND = Utils.buildKind(ClearTransactionRequest.class);
        public String kind;
        public EndTransactionRequest.TransactionOutcome transactionOutcome;
        public boolean isUpdated;
        public long originalVersion;
    }

    public static class TxUtils {
        public static Operation buildEnrollRequest(ServiceHost host, String transactionId, String serviceSelfLink, Service.Action action, long previousVersion) {
            EnrollRequest body = new EnrollRequest();
            body.serviceSelfLink = serviceSelfLink;
            body.action = action;
            body.previousVersion = previousVersion;
            return Operation.createPatch(SimpleTransactionService.buildTransactionUri(host, transactionId)).setBody(body);
        }

        public static Operation buildCommitRequest(ServiceHost host, String transactionId) {
            EndTransactionRequest body = new EndTransactionRequest();
            body.transactionOutcome = EndTransactionRequest.TransactionOutcome.COMMIT;
            return Operation.createPatch(SimpleTransactionService.buildTransactionUri(host, transactionId)).setBody(body);
        }

        public static Operation buildAbortRequest(ServiceHost host, String transactionId) {
            EndTransactionRequest body = new EndTransactionRequest();
            body.transactionOutcome = EndTransactionRequest.TransactionOutcome.ABORT;
            return Operation.createPatch(SimpleTransactionService.buildTransactionUri(host, transactionId)).setBody(body);
        }
    }

    public static class EndTransactionRequest {
        public static final String KIND = Utils.buildKind(EndTransactionRequest.class);
        public String kind = KIND;
        public TransactionOutcome transactionOutcome;

        public static enum TransactionOutcome {
            COMMIT,
            ABORT;

        }
    }

    public static class EnrollRequest {
        public static final String KIND = Utils.buildKind(EnrollRequest.class);
        public String kind = KIND;
        public String serviceSelfLink;
        public Service.Action action;
        public long previousVersion;
    }

    public static class SimpleTransactionServiceState
    extends ServiceDocument {
        public TaskState taskInfo;
        public Map<String, EnrollmentInfo> enrolledServices;
        public Set<String> createdServicesLinks;
        public Set<String> deletedServicesLinks;
    }

    public static class EnrollmentInfo {
        public boolean isUpdated;
        public long originalVersion;
    }
}

