/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.StatefulService;
import com.vmware.xenon.common.Utils;
import java.util.Set;

public class RoleService
extends StatefulService {
    public RoleService() {
        super(RoleState.class);
        super.toggleOption(Service.ServiceOption.PERSISTENCE, true);
        super.toggleOption(Service.ServiceOption.REPLICATION, true);
        super.toggleOption(Service.ServiceOption.OWNER_SELECTION, true);
    }

    @Override
    public void handleStart(Operation op) {
        if (!op.hasBody()) {
            op.fail(new IllegalArgumentException("body is required"));
            return;
        }
        RoleState state = op.getBody(RoleState.class);
        if (!this.validate(op, state)) {
            return;
        }
        op.complete();
    }

    private boolean validate(Operation op, RoleState state) {
        if (state.userGroupLink == null) {
            op.fail(new IllegalArgumentException("userGroupLink is required"));
            return false;
        }
        if (state.resourceGroupLink == null) {
            op.fail(new IllegalArgumentException("resourceGroupLink is required"));
            return false;
        }
        if (state.verbs == null) {
            op.fail(new IllegalArgumentException("verbs is required"));
            return false;
        }
        if (state.policy == null) {
            op.fail(new IllegalArgumentException("policy is required"));
            return false;
        }
        if (state.policy == Policy.DENY) {
            op.fail(new IllegalArgumentException("DENY policy is not supported"));
            return false;
        }
        return true;
    }

    public static class RoleState
    extends ServiceDocument {
        public static final String KIND = Utils.buildKind(RoleState.class);
        public static final String FIELD_NAME_USER_GROUP_LINK = "userGroupLink";
        public static final String FIELD_NAME_RESOURCE_GROUP_LINK = "resourceGroupLink";
        public String userGroupLink;
        public String resourceGroupLink;
        public Set<Service.Action> verbs;
        public Policy policy;
        public int priority;
    }

    public static enum Policy {
        ALLOW,
        DENY;

    }
}

