/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.StatefulService;
import com.vmware.xenon.services.common.QueryTask;

public class ResourceGroupService
extends StatefulService {
    public ResourceGroupService() {
        super(ResourceGroupState.class);
        super.toggleOption(Service.ServiceOption.PERSISTENCE, true);
        super.toggleOption(Service.ServiceOption.REPLICATION, true);
        super.toggleOption(Service.ServiceOption.OWNER_SELECTION, true);
    }

    @Override
    public void handleStart(Operation op) {
        this.handleOp(op);
    }

    @Override
    public void handlePut(Operation put) {
        this.handleOp(put);
    }

    private void handleOp(Operation op) {
        if (!op.hasBody()) {
            op.fail(new IllegalArgumentException("body is required"));
            return;
        }
        ResourceGroupState state = op.getBody(ResourceGroupState.class);
        if (!this.validate(op, state)) {
            return;
        }
        op.complete();
    }

    private boolean validate(Operation op, ResourceGroupState state) {
        if (state.query == null) {
            op.fail(new IllegalArgumentException("query is required"));
            return false;
        }
        return true;
    }

    public static class ResourceGroupState
    extends ServiceDocument {
        public QueryTask.Query query;
    }
}

