/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.NodeSelectorState;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceSubscriptionState;
import com.vmware.xenon.common.StatelessService;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.NodeGroupService;
import com.vmware.xenon.services.common.NodeState;
import java.net.URI;
import java.util.function.Consumer;

public class ReliableSubscriptionService
extends StatelessService {
    private Operation subscribeOp;
    private ServiceSubscriptionState.ServiceSubscriber subscribeRequest;
    private Consumer<Operation> consumer;
    private String peerNodeSelectorPath = "/core/node-selectors/default";

    public static ReliableSubscriptionService create(Operation subscribe, ServiceSubscriptionState.ServiceSubscriber sr, Consumer<Operation> notificationConsumer) {
        if (subscribe == null) {
            throw new IllegalArgumentException("subscribe operation is required");
        }
        if (sr == null) {
            throw new IllegalArgumentException("subscribe request is required");
        }
        if (notificationConsumer == null) {
            throw new IllegalArgumentException("notificationConsumer is required");
        }
        ReliableSubscriptionService rss = new ReliableSubscriptionService(subscribe, sr, notificationConsumer);
        return rss;
    }

    private ReliableSubscriptionService(Operation subscribeOp, ServiceSubscriptionState.ServiceSubscriber sr, Consumer<Operation> notificationConsumer) {
        this.subscribeOp = subscribeOp.clone();
        this.subscribeRequest = Utils.clone(sr);
        this.consumer = notificationConsumer;
    }

    @Override
    public String getPeerNodeSelectorPath() {
        return this.peerNodeSelectorPath;
    }

    @Override
    public void setPeerNodeSelectorPath(String path) {
        this.peerNodeSelectorPath = path;
    }

    @Override
    public void handleStart(Operation startPost) {
        this.subscribeRequest.reference = UriUtils.buildPublicUri(this.getHost(), this.getSelfLink());
        this.sendRequest(Operation.createGet(this, this.getPeerNodeSelectorPath()).setCompletion((o, e) -> {
            if (e != null) {
                startPost.fail(e);
                return;
            }
            NodeSelectorState nss = o.getBody(NodeSelectorState.class);
            this.getHost().startSubscriptionService(Operation.createPost(this, nss.nodeGroupLink).setReferer(this.getUri()), notifyOp -> this.handleNodeGroupNotification((Operation)notifyOp));
            startPost.complete();
        }));
    }

    @Override
    public void handleRequest(Operation op) {
        if (!op.isNotification()) {
            super.handleRequest(op);
            return;
        }
        this.consumer.accept(op);
    }

    private void handleNodeGroupNotification(Operation notifyOp) {
        NodeGroupService.NodeGroupState ngs = notifyOp.getBody(NodeGroupService.NodeGroupState.class);
        notifyOp.complete();
        if (ngs.nodes == null || ngs.nodes.isEmpty()) {
            return;
        }
        if (this.getHost().isStopping()) {
            return;
        }
        boolean isConverged = true;
        URI healthyPeerUri = null;
        for (NodeState ns : ngs.nodes.values()) {
            boolean isAvailable = NodeState.isAvailable(ns, this.getHost().getId(), false);
            if (isAvailable) {
                healthyPeerUri = ns.groupReference;
            }
            if (isAvailable || NodeState.isUnAvailable(ns)) continue;
            isConverged = false;
            break;
        }
        if (!isConverged) {
            this.logInfo("group update notification but not group not converged", new Object[0]);
            return;
        }
        if (!this.subscribeOp.getUri().getPath().endsWith("/subscriptions")) {
            this.subscribeOp.setUri(UriUtils.buildUri(healthyPeerUri, this.subscribeOp.getUri().getPath(), "/subscriptions"));
        } else {
            this.subscribeOp.setUri(UriUtils.buildUri(healthyPeerUri, this.subscribeOp.getUri().getPath()));
        }
        this.checkAndReSubscribe();
    }

    private void checkAndReSubscribe() {
        if (this.getHost().isStopping()) {
            return;
        }
        Operation getSubscriptions = this.subscribeOp.clone().setAction(Service.Action.GET);
        this.sendRequest(getSubscriptions.setCompletion((o, e) -> {
            if (e != null) {
                this.selfDeleteDueToFailure(o, e);
                return;
            }
            this.resubscribe(o);
        }));
    }

    private void resubscribe(Operation o) {
        if (this.getHost().isStopping()) {
            return;
        }
        ServiceSubscriptionState rsp = o.getBody(ServiceSubscriptionState.class);
        for (ServiceSubscriptionState.ServiceSubscriber item : rsp.subscribers.values()) {
            if (item.reference == null || !item.reference.getPath().equals(this.getSelfLink())) continue;
            return;
        }
        this.logWarning("Subscription missing from %s, resubscribing", o.getUri());
        Operation reSubscribe = this.subscribeOp.clone().setBody(this.subscribeRequest).setCompletion((subOp, subE) -> {
            if (subE != null) {
                this.selfDeleteDueToFailure(subOp, subE);
            }
        });
        this.sendRequest(reSubscribe);
    }

    private void selfDeleteDueToFailure(Operation o, Throwable e) {
        if (this.getHost().isStopping()) {
            return;
        }
        this.logSevere("%s to %s failed with %s :", new Object[]{o.getAction(), o.getUri(), e.toString()});
        this.sendRequest(Operation.createDelete(this.getUri()).addPragmaDirective("xn-nt-skipped"));
    }
}

