/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.ServiceDocument;
import java.net.URI;
import java.util.EnumSet;

public class NodeState
extends ServiceDocument {
    public static final EnumSet<NodeOption> DEFAULT_OPTIONS = EnumSet.of(NodeOption.PEER);
    public URI groupReference;
    public NodeStatus status = NodeStatus.UNKNOWN;
    public EnumSet<NodeOption> options = DEFAULT_OPTIONS;
    public String id;
    public int membershipQuorum = 1;
    public int synchQuorum = 1;

    public static boolean isUnAvailable(NodeState ns) {
        return ns.status == NodeStatus.UNAVAILABLE || ns.status == NodeStatus.REPLACED || ns.options.contains((Object)NodeOption.OBSERVER);
    }

    public static boolean isAvailable(NodeState m, String hostId, boolean excludeThisHost) {
        if (m.status != NodeStatus.AVAILABLE) {
            return false;
        }
        return !excludeThisHost || !m.id.equals(hostId);
    }

    public static enum NodeOption {
        PEER,
        OBSERVER;

    }

    public static enum NodeStatus {
        UNKNOWN,
        UNAVAILABLE,
        AVAILABLE,
        SYNCHRONIZING,
        REPLACED;

    }
}

