/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.NodeSelectorService;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.StatelessService;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.NodeGroupService;
import com.vmware.xenon.services.common.NodeState;
import java.net.URI;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;

public class NodeSelectorReplicationService
extends StatelessService {
    private Service parent;

    public NodeSelectorReplicationService(Service parent) {
        this.parent = parent;
        super.setHost(parent.getHost());
        super.setSelfLink(UriUtils.buildUriPath(parent.getSelfLink(), "/replication"));
        super.setProcessingStage(Service.ProcessingStage.AVAILABLE);
    }

    @Override
    public void handleRequest(Operation op) {
        String header = "x-xenon-rpl-target";
        String path = op.getRequestHeader("x-xenon-rpl-target");
        if (path == null) {
            op.fail(new IllegalArgumentException("x-xenon-rpl-target is required"));
            return;
        }
        this.handleRemoteUpdate(op.setUri(UriUtils.buildUri(this.getHost(), path, op.getUri().getQuery())));
    }

    void replicateUpdate(NodeGroupService.NodeGroupState localState, Operation outboundOp, NodeSelectorService.SelectAndForwardRequest req, NodeSelectorService.SelectOwnerResponse rsp) {
        Collection<NodeState> members = localState.nodes.values();
        NodeState localNode = localState.nodes.get(this.getHost().getId());
        AtomicInteger successCount = new AtomicInteger(0);
        if (this.options.contains((Object)Service.ServiceOption.ENFORCE_QUORUM) && localNode.membershipQuorum > members.size()) {
            outboundOp.fail(new IllegalStateException("Not enough peers: " + members.size()));
            return;
        }
        if (members.size() == 1) {
            outboundOp.complete();
            return;
        }
        AtomicInteger requestsSent = new AtomicInteger();
        AtomicInteger failureCount = new AtomicInteger();
        int successThreshold = Math.min(2, members.size() - 1);
        int failureThreshold = members.size();
        if (this.options.contains((Object)Service.ServiceOption.ENFORCE_QUORUM)) {
            failureThreshold = members.size() - localNode.membershipQuorum;
            successThreshold = Math.max(2, localNode.membershipQuorum);
        }
        int successThresholdFinal = successThreshold;
        int failureThresholdFinal = failureThreshold;
        Operation.CompletionHandler c = (o, e) -> {
            if (e == null && o != null && o.getStatusCode() >= 400) {
                e = new IllegalStateException("Request failed: " + o.toString());
            }
            int sCount = 0;
            if (e != null) {
                this.logInfo("Request failed for %s: %s", o.getUri(), e.toString());
                failureCount.incrementAndGet();
            } else {
                sCount = successCount.incrementAndGet();
            }
            if (sCount == successThresholdFinal) {
                outboundOp.complete();
                return;
            }
            if (failureCount.get() > 0) {
                String error = String.format("request %d failed. Fail count: %d,  sent count: %d, quorum: %d", outboundOp.getId(), failureCount.get(), requestsSent.get(), localNode.membershipQuorum);
                this.logWarning("%s", error);
                if (failureCount.get() >= failureThresholdFinal) {
                    outboundOp.fail(new IllegalStateException(error));
                }
            }
        };
        String body = Utils.toJson(req.linkedState);
        String phase = outboundOp.getRequestHeaders().get("x-xenon-rpl-phase");
        Operation update = Operation.createPost(null).setAction(outboundOp.getAction()).setBodyNoCloning(body).setCompletion(c).setRetryCount(1).setExpiration(outboundOp.getExpirationMicrosUtc()).addRequestHeader("x-xenon-rpl-target", outboundOp.getUri().getPath()).transferRequestHeadersFrom(outboundOp).setReferer(outboundOp.getReferer());
        if (phase != null) {
            update.addRequestHeader("x-xenon-rpl-phase", phase);
        }
        for (NodeState m : rsp.selectedNodes) {
            if (m.id.equals(this.getHost().getId())) {
                c.handle(null, null);
                continue;
            }
            if (m.options.contains((Object)NodeState.NodeOption.OBSERVER)) continue;
            URI remoteGroupReplicationService = UriUtils.buildUri(m.groupReference.getScheme(), m.groupReference.getHost(), m.groupReference.getPort(), this.getSelfLink(), outboundOp.getUri().getQuery());
            update.setUri(remoteGroupReplicationService);
            if (NodeState.isUnAvailable(m)) {
                c.handle(update, new IllegalStateException("node is not available"));
                continue;
            }
            requestsSent.incrementAndGet();
            this.getHost().getClient().send(update);
        }
    }

    private void handleRemoteUpdate(Operation op) {
        Operation.CompletionHandler c = (o, e) -> {
            if (e != null) {
                op.setStatusCode(o.getStatusCode()).fail(e);
                return;
            }
            op.setBody(null).complete();
        };
        op.nestCompletion(c);
        this.getHost().getClient().send(op);
    }

    @Override
    public void sendRequest(Operation op) {
        this.parent.sendRequest(op);
    }

    @Override
    public ServiceHost getHost() {
        return this.parent.getHost();
    }
}

