/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.jwt;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.vmware.xenon.common.jwt.Algorithm;
import com.vmware.xenon.common.jwt.Constants;
import com.vmware.xenon.common.jwt.Header;
import com.vmware.xenon.common.jwt.Rfc7519Claims;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Base64;

public class Verifier {
    protected Base64.Decoder decoder = Base64.getUrlDecoder();
    private byte[] secret;
    protected Gson gson;

    public Verifier(byte[] secret) {
        this(secret, new GsonBuilder().create());
    }

    public Verifier(byte[] secret, Gson gson) {
        this.secret = Arrays.copyOf(secret, secret.length);
        this.gson = gson;
    }

    public Rfc7519Claims verify(String jwt) throws TokenException, GeneralSecurityException {
        return this.verify(jwt, Rfc7519Claims.class);
    }

    public <T extends Rfc7519Claims> T verify(String jwt, Class<T> klass) throws TokenException, GeneralSecurityException {
        Rfc7519Claims payload;
        Algorithm algorithm;
        int headerIndex = jwt.indexOf(46, 0);
        if (headerIndex == -1 || headerIndex == 0) {
            throw new InvalidTokenException("Separator for header not found");
        }
        int payloadIndex = jwt.indexOf(46, headerIndex + 1);
        if (payloadIndex == -1 || payloadIndex == headerIndex + 1) {
            throw new InvalidTokenException("Separator for payload not found");
        }
        String encodedHeader = jwt.substring(0, headerIndex);
        String encodedPayload = jwt.substring(headerIndex + 1, payloadIndex);
        String encodedSignature = jwt.substring(payloadIndex + 1);
        Header header = null;
        try {
            header = this.decode(encodedHeader, Header.class);
        }
        catch (JsonSyntaxException ex) {
            throw new InvalidTokenException(String.format("Invalid header JSON: %s", ex.getMessage()));
        }
        if (header == null) {
            throw new InvalidTokenException("Invalid header: null");
        }
        if (header.type == null) {
            throw new InvalidTokenException("Invalid header: no type");
        }
        if (!header.type.equals("JWT")) {
            throw new InvalidTokenException(String.format("Header type: %s", header.type));
        }
        try {
            algorithm = Algorithm.fromString(header.algorithm);
        }
        catch (Algorithm.UnknownAlgorithmException ex) {
            throw new InvalidTokenException(ex.getMessage());
        }
        byte[] bytesToSign = jwt.substring(0, payloadIndex).getBytes(Constants.DEFAULT_CHARSET);
        byte[] expectedSignature = algorithm.sign(bytesToSign, this.secret);
        byte[] actualSignature = this.decode(encodedSignature);
        if (!MessageDigest.isEqual(expectedSignature, actualSignature)) {
            throw new InvalidSignatureException("Signature does not match");
        }
        try {
            payload = (Rfc7519Claims)this.decode(encodedPayload, klass);
        }
        catch (JsonSyntaxException ex) {
            throw new InvalidTokenException(String.format("Invalid payload JSON: %s", ex.getMessage()));
        }
        if (payload == null) {
            throw new InvalidTokenException("Invalid payload: null");
        }
        return (T)payload;
    }

    protected byte[] decode(String payload) {
        return this.decoder.decode(payload.getBytes(Constants.DEFAULT_CHARSET));
    }

    protected <T> T decode(String payload, Class<T> klass) {
        String json = new String(this.decode(payload), Constants.DEFAULT_CHARSET);
        return (T)this.gson.fromJson(json, klass);
    }

    public class InvalidSignatureException
    extends TokenException {
        private static final long serialVersionUID = -8683380846847289365L;

        InvalidSignatureException(String message) {
            super(message);
        }
    }

    public class InvalidTokenException
    extends TokenException {
        private static final long serialVersionUID = -1387613440530397711L;

        InvalidTokenException(String message) {
            super(message);
        }
    }

    public class TokenException
    extends Exception {
        private static final long serialVersionUID = 1640724864336370400L;

        TokenException(String message) {
            super(message);
        }
    }
}

