/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.jwt;

import com.google.gson.annotations.SerializedName;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class Rfc7519Claims {
    @SerializedName(value="iss")
    private String issuer;
    @SerializedName(value="sub")
    private String subject;
    @SerializedName(value="aud")
    private Set<String> audience;
    @SerializedName(value="exp")
    private Long expirationTime;
    @SerializedName(value="nbf")
    private Long notBefore;
    @SerializedName(value="iat")
    private Long issuedAt;
    @SerializedName(value="jti")
    private String jwtId;

    public String getIssuer() {
        return this.issuer;
    }

    public String getSubject() {
        return this.subject;
    }

    public Set<String> getAudience() {
        return Collections.unmodifiableSet(this.audience);
    }

    public Long getExpirationTime() {
        return this.expirationTime;
    }

    public Long getNotBefore() {
        return this.notBefore;
    }

    public Long getIssuedAt() {
        return this.issuedAt;
    }

    public String getJwtId() {
        return this.jwtId;
    }

    public static class Rfc7519Builder<T extends Rfc7519Claims> {
        private Class<T> clazz;
        private Rfc7519Claims claims;

        public Rfc7519Builder(Class<T> clazz) {
            this.clazz = clazz;
            this.initialize();
        }

        protected void initialize() {
            this.claims = null;
            try {
                this.claims = (Rfc7519Claims)this.clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }

        protected T getInstance() {
            return (T)this.claims;
        }

        public T getResult() {
            T result = this.getInstance();
            this.initialize();
            return result;
        }

        public Rfc7519Builder<T> setIssuer(String issuer) {
            this.claims.issuer = issuer;
            return this;
        }

        public Rfc7519Builder<T> setSubject(String subject) {
            this.claims.subject = subject;
            return this;
        }

        public Rfc7519Builder<T> setAudience(Set<String> audience) {
            this.claims.audience = new HashSet<String>(audience);
            return this;
        }

        public Rfc7519Builder<T> setExpirationTime(Long expirationTime) {
            this.claims.expirationTime = expirationTime;
            return this;
        }

        public Rfc7519Builder<T> setNotBefore(Long notBefore) {
            this.claims.notBefore = notBefore;
            return this;
        }

        public Rfc7519Builder<T> setIssuedAt(Long issuedAt) {
            this.claims.issuedAt = issuedAt;
            return this;
        }

        public Rfc7519Builder<T> setJwtId(String jwtId) {
            this.claims.jwtId = jwtId;
            return this;
        }
    }
}

