/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.http.netty;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.ServiceErrorResponse;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.common.http.netty.NettyChannelContext;
import com.vmware.xenon.common.http.netty.NettyChannelPool;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderUtil;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpResponse;
import java.net.ProtocolException;
import java.util.EnumSet;
import java.util.Map;
import java.util.logging.Logger;

public class NettyHttpServerResponseHandler
extends SimpleChannelInboundHandler<HttpObject> {
    private NettyChannelPool pool;

    public NettyHttpServerResponseHandler(NettyChannelPool pool) {
        this.pool = pool;
    }

    public void messageReceived(ChannelHandlerContext ctx, HttpObject msg) {
        Operation request = (Operation)ctx.channel().attr(NettyChannelContext.OPERATION_KEY).get();
        if (msg instanceof FullHttpResponse) {
            FullHttpResponse response = (FullHttpResponse)msg;
            request.setStatusCode(response.status().code());
            this.parseResponseHeaders(request, (HttpResponse)response);
            this.completeRequest(ctx, request, response.content());
        }
    }

    private void parseResponseHeaders(Operation request, HttpResponse nettyResponse) {
        HttpHeaders headers = nettyResponse.headers();
        if (headers.isEmpty()) {
            return;
        }
        request.setKeepAlive(HttpHeaderUtil.isKeepAlive((HttpMessage)nettyResponse));
        if (HttpHeaderUtil.isContentLengthSet((HttpMessage)nettyResponse)) {
            request.setContentLength(HttpHeaderUtil.getContentLength((HttpMessage)nettyResponse));
        }
        for (Map.Entry h : headers.entriesConverted()) {
            String key = (String)h.getKey();
            String value = (String)h.getValue();
            if (key.equalsIgnoreCase(HttpHeaderNames.CONTENT_TYPE.toString())) {
                request.setContentType(value);
                continue;
            }
            request.addResponseHeader(key, value);
        }
    }

    private void completeRequest(ChannelHandlerContext ctx, Operation request, ByteBuf content) {
        this.decodeResponseBody(request, content);
        this.pool.returnOrClose((NettyChannelContext)request.getSocketContext(), !request.isKeepAlive());
    }

    private void decodeResponseBody(Operation request, ByteBuf content) {
        if (!content.isReadable()) {
            if (this.checkResponseForError(request)) {
                return;
            }
            request.setContentLength(0L).setContentType("application/json");
            request.complete();
            return;
        }
        request.nestCompletion((o, e) -> {
            if (e != null) {
                request.fail(e);
                return;
            }
            this.completeRequest(request);
        });
        Utils.decodeBody(request, content.nioBuffer());
    }

    private void completeRequest(Operation request) {
        if (this.checkResponseForError(request)) {
            return;
        }
        request.complete();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        Logger.getAnonymousLogger().warning(Utils.toString(cause));
        Operation request = (Operation)ctx.channel().attr(NettyChannelContext.OPERATION_KEY).get();
        if (request == null) {
            Logger.getAnonymousLogger().info("no request associated with channel");
            return;
        }
        request.setStatusCode(400);
        request.setBody(ServiceErrorResponse.create(cause, request.getStatusCode(), EnumSet.of(ServiceErrorResponse.ErrorDetail.SHOULD_RETRY)));
        request.fail(cause);
    }

    private boolean checkResponseForError(Operation op) {
        if (op.getStatusCode() < 400) {
            return false;
        }
        String errorMsg = String.format("Service %s returned error %d for %s", new Object[]{op.getUri(), op.getStatusCode(), op.getAction()});
        if (!op.hasBody()) {
            ServiceErrorResponse rsp = ServiceErrorResponse.create(new ProtocolException(errorMsg), op.getStatusCode());
            op.setBodyNoCloning(rsp);
        }
        op.fail(new ProtocolException(errorMsg));
        return true;
    }
}

