/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.http.netty;

import com.vmware.xenon.common.Operation;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.util.AttributeKey;

public class NettyChannelContext
extends Operation.SocketContext {
    static final AttributeKey<Operation> OPERATION_KEY = AttributeKey.valueOf((String)"operation");
    public static final int BUFFER_SIZE = 65536;
    public static final int MAX_INITIAL_LINE_LENGTH = 4096;
    public static final int MAX_HEADER_SIZE = 65536;
    public static final int MAX_CHUNK_SIZE = 65536;
    public static final PooledByteBufAllocator ALLOCATOR = NettyChannelContext.createAllocator();
    int port;
    String host;
    private Channel channel;
    private final String key;

    static PooledByteBufAllocator createAllocator() {
        int maxOrder = 4;
        return new PooledByteBufAllocator(true, 2, 2, 8192, maxOrder, 64, 32, 16);
    }

    public NettyChannelContext(String host, int port, String key) {
        this.host = host;
        this.port = port;
        this.key = key;
    }

    public NettyChannelContext setChannel(Channel c) {
        this.channel = c;
        return this;
    }

    public NettyChannelContext setOperation(Operation request) {
        this.channel.attr(OPERATION_KEY).set((Object)request);
        request.setSocketContext(this);
        return this;
    }

    public Operation getOperation() {
        Channel ch = this.channel;
        if (ch == null) {
            return null;
        }
        return (Operation)ch.attr(OPERATION_KEY).get();
    }

    public String getKey() {
        return this.key;
    }

    public Channel getChannel() {
        return this.channel;
    }

    @Override
    public void writeHttpRequest(Object request) {
        this.channel.writeAndFlush(request);
        this.updateLastUseTime();
    }

    @Override
    public void close() {
        Channel c = this.channel;
        if (c == null) {
            return;
        }
        if (!c.isOpen()) {
            return;
        }
        try {
            c.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

