/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.OperationContext;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.ServiceMaintenanceRequest;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.logging.Level;

class ServiceHostMaintenanceTracker {
    private ServiceHost host;
    private ConcurrentSkipListMap<Long, Set<String>> nextExpiration = new ConcurrentSkipListMap();

    ServiceHostMaintenanceTracker() {
    }

    public static ServiceHostMaintenanceTracker create(ServiceHost host) {
        ServiceHostMaintenanceTracker smt = new ServiceHostMaintenanceTracker();
        smt.host = host;
        return smt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(Service s) {
        long interval = s.getMaintenanceIntervalMicros();
        if (interval == 0L) {
            interval = this.host.getMaintenanceIntervalMicros();
        }
        long nextExpirationMicros = Utils.getNowMicrosUtc() + interval;
        ServiceHostMaintenanceTracker serviceHostMaintenanceTracker = this;
        synchronized (serviceHostMaintenanceTracker) {
            Set<String> services = this.nextExpiration.get(nextExpirationMicros);
            if (services == null) {
                services = new HashSet<String>();
                this.nextExpiration.put(nextExpirationMicros, services);
            }
            services.add(s.getSelfLink());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performMaintenance(Operation op, long deadline) {
        while (Utils.getNowMicrosUtc() < deadline) {
            if (this.host.isStopping()) {
                op.fail(new CancellationException("Host is stopping"));
                return;
            }
            Set<String> services = null;
            ServiceHostMaintenanceTracker serviceHostMaintenanceTracker = this;
            synchronized (serviceHostMaintenanceTracker) {
                Map.Entry<Long, Set<String>> e = this.nextExpiration.firstEntry();
                if (e == null || e.getKey() > deadline) {
                    return;
                }
                services = e.getValue();
                this.nextExpiration.remove(e.getKey());
            }
            for (String servicePath : services) {
                Service s = this.host.findService(servicePath);
                if (s == null || s.getProcessingStage() != Service.ProcessingStage.AVAILABLE || !s.hasOption(Service.ServiceOption.PERIODIC_MAINTENANCE) || s.hasOption(Service.ServiceOption.OWNER_SELECTION) && !s.hasOption(Service.ServiceOption.DOCUMENT_OWNER)) continue;
                this.performServiceMaintenance(servicePath, s);
            }
        }
    }

    private void performServiceMaintenance(String servicePath, Service s) {
        long[] start = new long[1];
        ServiceMaintenanceRequest body = ServiceMaintenanceRequest.create();
        body.reasons.add(ServiceMaintenanceRequest.MaintenanceReason.PERIODIC_SCHEDULE);
        Operation servicePost = Operation.createPost(UriUtils.buildUri(this.host, servicePath)).setReferer(this.host.getUri()).setBody(body).setCompletion((o, ex) -> {
            long actual = Utils.getNowMicrosUtc() - start[0];
            long limit = Math.max(this.host.getMaintenanceIntervalMicros(), s.getMaintenanceIntervalMicros());
            if (limit * 2L < actual) {
                this.host.log(Level.WARNING, "Service %s exceeded maint. interval %d. Actual: %d", servicePath, limit, actual);
                s.adjustStat("maintenanceCompletionDelayedCount", 1.0);
            }
            this.schedule(s);
            if (ex != null) {
                this.host.log(Level.WARNING, "Service %s failed maintenance: %s", servicePath, Utils.toString(ex));
            }
        });
        this.host.run(() -> {
            try {
                OperationContext.setAuthorizationContext(this.host.getSystemAuthorizationContext());
                if (s.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
                    s.adjustStat("maintenanceCount", 1.0);
                }
                start[0] = Utils.getNowMicrosUtc();
                s.handleMaintenance(servicePost);
            }
            catch (Throwable ex) {
                servicePost.fail(ex);
            }
        });
    }

    public synchronized void close() {
        this.nextExpiration.clear();
    }
}

