/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.OperationContext;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceClient;
import com.vmware.xenon.common.ServiceHost;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class OperationJoin {
    private static final int APPROXIMATE_EXPECTED_CAPACITY = 4;
    public static final String ERROR_MSG_BATCH_LIMIT_VIOLATED = "batch limit violated";
    public static final String ERROR_MSG_INVALID_BATCH_SIZE = "batch size must be greater than 0";
    public static final String ERROR_MSG_OPERATIONS_ALREADY_SET = "operations have already been set";
    private final ConcurrentHashMap<Long, Operation> operations;
    private ConcurrentHashMap<Long, Throwable> failures;
    volatile JoinedCompletionHandler joinedCompletion;
    private OperationContext opContext;
    private AtomicInteger pendingCount = new AtomicInteger();
    private AtomicInteger batchSizeGuard = new AtomicInteger();
    private int batchSize = 0;
    private Iterator<Operation> operationIterator;
    private Consumer<Operation> sendOperation;

    private OperationJoin() {
        this.operations = new ConcurrentHashMap(4);
        this.opContext = OperationContext.getOperationContext();
    }

    public static OperationJoin create() {
        return new OperationJoin();
    }

    public static OperationJoin create(Operation ... ops) {
        OperationJoin joinOp = new OperationJoin();
        joinOp.setOperations(ops);
        return joinOp;
    }

    public static OperationJoin create(Collection<Operation> ops) {
        OperationJoin joinOp = new OperationJoin();
        joinOp.setOperations(ops);
        return joinOp;
    }

    public static OperationJoin create(Stream<Operation> ops) {
        OperationJoin joinOp = new OperationJoin();
        joinOp.setOperations(ops);
        return joinOp;
    }

    public OperationJoin setOperations(Operation ... ops) {
        if (ops.length == 0) {
            throw new IllegalArgumentException("At least one operation to join expected");
        }
        if (this.operationIterator != null) {
            throw new IllegalStateException(ERROR_MSG_OPERATIONS_ALREADY_SET);
        }
        Operation.CompletionHandler nestedParentHandler = this.createParentCompletion();
        for (Operation op : ops) {
            this.prepareOperation(nestedParentHandler, op);
        }
        this.operationIterator = this.operations.values().iterator();
        return this;
    }

    public OperationJoin setOperations(Collection<Operation> ops) {
        if (ops.isEmpty()) {
            throw new IllegalArgumentException("At least one operation to join expected");
        }
        if (this.operationIterator != null) {
            throw new IllegalStateException(ERROR_MSG_OPERATIONS_ALREADY_SET);
        }
        Operation.CompletionHandler nestedParentHandler = this.createParentCompletion();
        for (Operation op : ops) {
            this.prepareOperation(nestedParentHandler, op);
        }
        this.operationIterator = this.operations.values().iterator();
        return this;
    }

    public OperationJoin setOperations(Stream<Operation> ops) {
        if (this.operationIterator != null) {
            throw new IllegalStateException(ERROR_MSG_OPERATIONS_ALREADY_SET);
        }
        Operation.CompletionHandler nestedParentHandler = this.createParentCompletion();
        ops.forEach(op -> this.prepareOperation(nestedParentHandler, (Operation)op));
        this.operationIterator = this.operations.values().iterator();
        if (this.isEmpty()) {
            throw new IllegalArgumentException("At least one operation to join expected");
        }
        return this;
    }

    private void prepareOperation(Operation.CompletionHandler nestedParentHandler, Operation op) {
        this.operations.put(op.getId(), op);
        op.nestCompletion(nestedParentHandler);
        this.pendingCount.incrementAndGet();
    }

    private Operation.CompletionHandler createParentCompletion() {
        Operation.CompletionHandler nestedParentHandler = (o, e) -> {
            if (e != null) {
                AtomicInteger atomicInteger = this.pendingCount;
                synchronized (atomicInteger) {
                    if (this.failures == null) {
                        this.failures = new ConcurrentHashMap();
                    }
                }
                this.failures.put(o.getId(), e);
            }
            Operation originalOp = this.operations.get(o.getId());
            originalOp.setStatusCode(o.getStatusCode()).transferResponseHeadersFrom(o).setBodyNoCloning(o.getBodyRaw());
            this.batchSizeGuard.decrementAndGet();
            this.sendNext();
            if (this.pendingCount.decrementAndGet() != 0) {
                return;
            }
            OperationContext.restoreOperationContext(this.opContext);
            for (Operation op : this.operations.values()) {
                Throwable t = null;
                if (this.failures != null) {
                    t = this.failures.get(op.getId());
                }
                if (t != null) {
                    op.fail(t);
                    continue;
                }
                op.complete();
            }
            if (this.joinedCompletion != null) {
                this.joinedCompletion.handle(this.operations, this.failures);
            }
        };
        return nestedParentHandler;
    }

    private void sendWithBatch() {
        if (this.operationIterator == null || !this.operationIterator.hasNext()) {
            throw new IllegalStateException("No operations to be sent");
        }
        ArrayList<Operation> localOperationList = new ArrayList<Operation>();
        int count = 0;
        while (this.operationIterator.hasNext()) {
            localOperationList.add(this.operationIterator.next());
            if (this.batchSize <= 0 || ++count != this.batchSize) continue;
        }
        for (Operation op : localOperationList) {
            this.sendOperation.accept(op);
            if (this.batchSize <= 0 || this.batchSizeGuard.incrementAndGet() <= this.batchSize) continue;
            throw new IllegalStateException(ERROR_MSG_BATCH_LIMIT_VIOLATED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendNext() {
        if (this.sendOperation == null) {
            return;
        }
        Operation op = null;
        Iterator<Operation> iterator = this.operationIterator;
        synchronized (iterator) {
            if (this.operationIterator.hasNext()) {
                op = this.operationIterator.next();
            }
        }
        if (op != null) {
            if (this.batchSize > 0 && this.batchSizeGuard.incrementAndGet() > this.batchSize) {
                throw new IllegalStateException(ERROR_MSG_BATCH_LIMIT_VIOLATED);
            }
            this.sendOperation.accept(op);
        }
    }

    public void sendWith(ServiceHost host, int batchSize) {
        if (batchSize <= 0) {
            throw new IllegalArgumentException(ERROR_MSG_INVALID_BATCH_SIZE);
        }
        this.batchSize = batchSize;
        this.sendWith(host);
    }

    public void sendWith(ServiceHost host) {
        if (host == null) {
            throw new IllegalArgumentException("host must not be null.");
        }
        this.sendOperation = host::sendRequest;
        this.sendWithBatch();
    }

    public void sendWith(Service service, int batchSize) {
        if (batchSize <= 0) {
            throw new IllegalArgumentException(ERROR_MSG_INVALID_BATCH_SIZE);
        }
        this.batchSize = batchSize;
        this.sendWith(service);
    }

    public void sendWith(Service service) {
        if (service == null) {
            throw new IllegalArgumentException("service must not be null.");
        }
        this.sendOperation = service::sendRequest;
        this.sendWithBatch();
    }

    public void sendWith(ServiceClient client, int batchSize) {
        if (batchSize <= 0) {
            throw new IllegalArgumentException(ERROR_MSG_INVALID_BATCH_SIZE);
        }
        this.batchSize = batchSize;
        this.sendWith(client);
    }

    public void sendWith(ServiceClient client) {
        if (client == null) {
            throw new IllegalArgumentException("client must not be null.");
        }
        this.sendOperation = client::send;
        this.sendWithBatch();
    }

    public OperationJoin setCompletion(JoinedCompletionHandler joinedCompletion) {
        this.joinedCompletion = joinedCompletion;
        return this;
    }

    OperationContext getOperationContext() {
        return this.opContext;
    }

    void setOperationContext(OperationContext opContext) {
        this.opContext = opContext;
    }

    public boolean isEmpty() {
        return this.operations.isEmpty();
    }

    public Collection<Operation> getOperations() {
        return this.operations.values();
    }

    public Map<Long, Throwable> getFailures() {
        return this.failures;
    }

    public Operation getOperation(long id) {
        return this.operations.get(id);
    }

    public void fail(Throwable t) {
        this.failures = new ConcurrentHashMap();
        this.failures.put(this.operations.keys().nextElement(), t);
        OperationContext origContext = OperationContext.getOperationContext();
        OperationContext.restoreOperationContext(this.opContext);
        for (Operation op : this.operations.values()) {
            op.fail(t);
        }
        OperationContext.restoreOperationContext(origContext);
    }

    @FunctionalInterface
    public static interface JoinedCompletionHandler {
        public void handle(Map<Long, Operation> var1, Map<Long, Throwable> var2);
    }
}

