/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcac.code.stream.jenkins.plugin.util;

import com.vmware.vcac.code.stream.jenkins.plugin.model.ExecutionInfo;
import com.vmware.vcac.code.stream.jenkins.plugin.model.ExecutionStatus;
import com.vmware.vcac.code.stream.jenkins.plugin.model.ReleasePipelineExecutionInfo;
import com.vmware.vcac.code.stream.jenkins.plugin.model.StageExecutionInfo;
import com.vmware.vcac.code.stream.jenkins.plugin.model.TaskExecutionInfo;
import java.io.IOException;
import java.util.List;
import org.codehaus.jackson.map.ObjectMapper;

public class ReleasePipelineExecutionInfoParser {
    ReleasePipelineExecutionInfo executionResponse;
    String executionResponseJson;
    ObjectMapper mapper = new ObjectMapper();

    public ReleasePipelineExecutionInfoParser(ReleasePipelineExecutionInfo executionResponse) {
        this.executionResponse = executionResponse;
    }

    public ReleasePipelineExecutionInfoParser(String executionResponseJson) throws IOException {
        this.executionResponseJson = executionResponseJson;
        this.executionResponse = (ReleasePipelineExecutionInfo)this.mapper.readValue(executionResponseJson, ReleasePipelineExecutionInfo.class);
    }

    public TaskExecutionInfo getFailedTask() {
        TaskExecutionInfo failedTask = null;
        List<StageExecutionInfo> stages = this.executionResponse.getStages();
        block0: for (StageExecutionInfo stage : stages) {
            for (TaskExecutionInfo executionInfo : stage.getTasks()) {
                ExecutionStatus status;
                ExecutionInfo taskExecStatus = executionInfo.getExecutionInfo();
                if (taskExecStatus == null || ExecutionStatus.FAILED != (status = taskExecStatus.getStatus())) continue;
                failedTask = executionInfo;
                continue block0;
            }
        }
        return failedTask;
    }

    public ExecutionStatus getPipelineExecStatus() throws IOException {
        ExecutionStatus executionStatus = null;
        ExecutionInfo info = this.executionResponse.getExecutionInfo();
        if (info != null) {
            return info.getStatus();
        }
        return executionStatus;
    }

    public boolean isPipelineCompleted() throws IOException {
        ExecutionStatus pipelineExecStatus = this.getPipelineExecStatus();
        switch (pipelineExecStatus) {
            case COMPLETED: 
            case FAILED: 
            case CANCELED: {
                return true;
            }
        }
        return false;
    }

    public String getPipelineExeResponseAsJson() throws IOException {
        return this.executionResponseJson;
    }
}

