/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcac.code.stream.jenkins.plugin.model;

import com.vmware.vcac.code.stream.jenkins.plugin.model.PipelineParam;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class PluginParam
implements Serializable {
    private String serverUrl;
    private String userName;
    private String password;
    private String tenant;
    private String pipelineName;
    private boolean waitExec;
    private List<PipelineParam> pipelineParams;

    public PluginParam(String serverUrl, String userName, String password, String tenant, String pipelineName, boolean waitExec, List<PipelineParam> pipelineParams) {
        this.serverUrl = serverUrl;
        this.userName = userName;
        this.password = password;
        this.tenant = tenant;
        this.pipelineName = pipelineName;
        this.waitExec = waitExec;
        this.pipelineParams = pipelineParams;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getTenant() {
        return this.tenant;
    }

    public String getPipelineName() {
        return this.pipelineName;
    }

    public List<PipelineParam> getPipelineParams() {
        return this.pipelineParams;
    }

    public boolean isWaitExec() {
        return this.waitExec;
    }

    public Boolean validate() throws IOException {
        if (StringUtils.isBlank((String)this.getServerUrl())) {
            throw new IOException("CodeStream server url cannot be empty");
        }
        if (StringUtils.isBlank((String)this.getUserName())) {
            throw new IOException("CodeStream server username cannot be empty");
        }
        if (StringUtils.isBlank((String)this.getPassword())) {
            throw new IOException("CodeStream server password cannot be empty");
        }
        if (StringUtils.isBlank((String)this.getTenant())) {
            throw new IOException("CodeStream tenant cannot be empty");
        }
        if (StringUtils.isBlank((String)this.getPipelineName())) {
            throw new IOException("CodeStream pipeline name cannot be empty");
        }
        return true;
    }
}

