/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.transport.core.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

public class URISplitter {
    static List<String> split(URI uri) {
        List<String> pathItems = Arrays.asList(uri.getRawPath().split("/"));
        return URISplitter.cleanPathItems(pathItems);
    }

    public static List<String> split(String uri) {
        List<String> pathItems = Arrays.asList(uri.split("/"));
        return URISplitter.cleanPathItems(pathItems);
    }

    public static Map<String, Object> extractQueryParams(URI uri, Map<String, Class> methodArgs) {
        if (uri.getRawQuery() != null) {
            List<String> queryPairs = Arrays.asList(uri.getRawQuery().split("&"));
            HashMap<String, Object> mappedQueryPairs = new HashMap<String, Object>();
            for (String val : queryPairs) {
                if (val.isEmpty()) continue;
                String[] keyVal = val.split("=");
                String valueString = keyVal[1];
                Object value = null;
                try {
                    if (StringUtils.isNumeric((CharSequence)valueString) && methodArgs.get(keyVal[0]).equals(Integer.class)) {
                        value = Integer.parseInt(valueString);
                    }
                    if (value == null) {
                        UUID uuid = UUID.fromString(valueString);
                        if (methodArgs.get(keyVal[0]).equals(UUID.class)) {
                            value = uuid;
                        }
                    }
                }
                catch (Exception exp) {
                    value = valueString;
                }
                if (value == null) {
                    value = valueString;
                }
                mappedQueryPairs.put(keyVal[0], value);
            }
            return mappedQueryPairs;
        }
        return null;
    }

    private static List<String> cleanPathItems(List<String> pathItems) {
        ArrayList<String> cleanedItems = new ArrayList<String>();
        for (String val : pathItems) {
            if (val.isEmpty()) continue;
            cleanedItems.add(val);
        }
        return cleanedItems;
    }
}

