/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.transport.core.util;

import com.vmware.transport.core.util.RestControllerReflection;
import com.vmware.transport.core.util.URIMethodResult;
import com.vmware.transport.core.util.URISplitter;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.springframework.aop.framework.Advised;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Component
public class URIMatcher {
    private final RestControllerReflection reflectionUtil;

    URIMatcher(RestControllerReflection reflectionUtil) {
        this.reflectionUtil = reflectionUtil;
    }

    public URIMethodResult findControllerMatch(URI uri, RequestMethod requestMethod) throws Exception {
        Map<String, Object> controllers = this.reflectionUtil.locateRestControllers();
        URIMethodResult result = null;
        for (String key : controllers.keySet()) {
            Object controller;
            Object controllerBean = controllers.get(key);
            try {
                Advised advised = (Advised)controllerBean;
                controller = advised.getTargetSource().getTarget();
            }
            catch (ClassCastException exp) {
                controller = controllerBean;
            }
            Map<String, Method> methods = this.reflectionUtil.extractControllerRequestMappings(controller);
            result = this.checkRequestMappingMethods(uri, requestMethod, controller, methods);
            if (result != null || (result = this.checkPostMappingMethods(uri, requestMethod, controller, methods = this.reflectionUtil.extractControllerPostMappings(controller))) != null || (result = this.checkPatchMappingMethods(uri, requestMethod, controller, methods = this.reflectionUtil.extractControllerPatchMappings(controller))) != null || (result = this.checkGetMappingMethods(uri, requestMethod, controller, methods = this.reflectionUtil.extractControllerGetMappings(controller))) != null || (result = this.checkPutMappingMethods(uri, requestMethod, controller, methods = this.reflectionUtil.extractControllerPutMappings(controller))) != null) break;
            methods = this.reflectionUtil.extractControllerDeleteMappings(controller);
            result = this.checkDeleteMappingMethods(uri, requestMethod, controller, methods);
        }
        return result;
    }

    private URIMethodResult checkRequestMappingMethods(URI uri, RequestMethod requestMethod, Object controller, Map<String, Method> methods) {
        URIMethodResult result = null;
        for (String methodKey : methods.keySet()) {
            Method method = methods.get(methodKey);
            RequestMapping annotation = (RequestMapping)AnnotationUtils.findAnnotation((Method)method, RequestMapping.class);
            if (annotation == null || annotation.path().length <= 0) continue;
            String uriString = annotation.path()[0];
            RequestMethod annotationMethod = annotation.method()[0];
            if ((result = this.checkForControllerMatch(uri, requestMethod, controller, true, result, method, annotationMethod, uriString)) == null) continue;
            break;
        }
        return result;
    }

    private URIMethodResult checkPatchMappingMethods(URI uri, RequestMethod requestMethod, Object controller, Map<String, Method> methods) {
        URIMethodResult result = null;
        for (String methodKey : methods.keySet()) {
            Method method = methods.get(methodKey);
            PatchMapping mappingAnnotation = (PatchMapping)AnnotationUtils.findAnnotation((Method)method, PatchMapping.class);
            if (mappingAnnotation == null) continue;
            String uriSring = mappingAnnotation.value()[0];
            result = this.checkForControllerMatch(uri, requestMethod, controller, false, result, method, null, uriSring);
        }
        return result;
    }

    private URIMethodResult checkGetMappingMethods(URI uri, RequestMethod requestMethod, Object controller, Map<String, Method> methods) {
        URIMethodResult result = null;
        for (String methodKey : methods.keySet()) {
            Method method = methods.get(methodKey);
            GetMapping mappingAnnotation = (GetMapping)AnnotationUtils.findAnnotation((Method)method, GetMapping.class);
            if (mappingAnnotation == null) continue;
            String uriSring = mappingAnnotation.value()[0];
            result = this.checkForControllerMatch(uri, requestMethod, controller, false, result, method, null, uriSring);
        }
        return result;
    }

    private URIMethodResult checkPutMappingMethods(URI uri, RequestMethod requestMethod, Object controller, Map<String, Method> methods) {
        URIMethodResult result = null;
        for (String methodKey : methods.keySet()) {
            Method method = methods.get(methodKey);
            PutMapping mappingAnnotation = (PutMapping)AnnotationUtils.findAnnotation((Method)method, PutMapping.class);
            if (mappingAnnotation == null) continue;
            String uriSring = mappingAnnotation.value()[0];
            result = this.checkForControllerMatch(uri, requestMethod, controller, false, result, method, null, uriSring);
        }
        return result;
    }

    private URIMethodResult checkPostMappingMethods(URI uri, RequestMethod requestMethod, Object controller, Map<String, Method> methods) {
        URIMethodResult result = null;
        for (String methodKey : methods.keySet()) {
            Method method = methods.get(methodKey);
            PostMapping mappingAnnotation = (PostMapping)AnnotationUtils.findAnnotation((Method)method, PostMapping.class);
            if (mappingAnnotation == null) continue;
            String uriSring = mappingAnnotation.value()[0];
            result = this.checkForControllerMatch(uri, requestMethod, controller, false, result, method, null, uriSring);
        }
        return result;
    }

    private URIMethodResult checkDeleteMappingMethods(URI uri, RequestMethod requestMethod, Object controller, Map<String, Method> methods) {
        URIMethodResult result = null;
        for (String methodKey : methods.keySet()) {
            Method method = methods.get(methodKey);
            DeleteMapping mappingAnnotation = (DeleteMapping)AnnotationUtils.findAnnotation((Method)method, DeleteMapping.class);
            if (mappingAnnotation == null) continue;
            String uriSring = mappingAnnotation.value()[0];
            result = this.checkForControllerMatch(uri, requestMethod, controller, false, result, method, null, uriSring);
        }
        return result;
    }

    private URIMethodResult checkForControllerMatch(URI uri, RequestMethod requestMethod, Object controller, boolean checkMethod, URIMethodResult result, Method method, RequestMethod annotationMethod, String uriSring) {
        List<String> requestedPathItems = URISplitter.split(uri);
        List<String> controllerPathItems = URISplitter.split(uriSring);
        if (this.comparePaths(controllerPathItems, requestedPathItems)) {
            if (checkMethod) {
                if (annotationMethod.equals((Object)requestMethod)) {
                    result = this.buildURIMethodResult(uri, controller, method, requestedPathItems, controllerPathItems);
                }
            } else {
                result = this.buildURIMethodResult(uri, controller, method, requestedPathItems, controllerPathItems);
            }
        }
        return result;
    }

    private URIMethodResult buildURIMethodResult(URI uri, Object controller, Method method, List<String> requestedPathItems, List<String> controllerPathItems) {
        URIMethodResult result = new URIMethodResult();
        result.setPathItems(controllerPathItems);
        result.setMethodArgs(this.reflectionUtil.extractMethodParameters(method));
        result.setMethogArgList(this.reflectionUtil.extractMethodParameterList(method));
        result.setMethodAnnotationTypes(this.reflectionUtil.extractMethodAnnotationTypes(method));
        result.setMethodAnnotationValues(this.reflectionUtil.extractMethodAnnotationValues(method));
        result.setQueryString(URISplitter.extractQueryParams(uri, result.getMethodArgs()));
        result.setPathItemMap(this.createPathItemMap(controllerPathItems, requestedPathItems, this.reflectionUtil.extractMethodParameters(method)));
        result.setMethod(method);
        result.setController(controller);
        return result;
    }

    public Map<String, Object> createPathItemMap(List<String> controllerPathItems, List<String> requestedPathItems, Map<String, Class> methodArgs) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (controllerPathItems.size() == requestedPathItems.size()) {
            for (int x = 0; x < controllerPathItems.size(); ++x) {
                String pathItem = controllerPathItems.get(x);
                if (!pathItem.startsWith("{") || !pathItem.endsWith("}")) continue;
                String argName = pathItem.replaceAll("\\{([\\w].+)\\}", "$1");
                try {
                    if (methodArgs != null) {
                        Class methodArgClass = methodArgs.get(argName);
                        if (methodArgClass.equals(UUID.class)) {
                            UUID uuid = UUID.fromString(requestedPathItems.get(x));
                            map.put(argName, uuid);
                            continue;
                        }
                        map.put(argName, requestedPathItems.get(x));
                        continue;
                    }
                    map.put(argName, requestedPathItems.get(x));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    map.put(argName, requestedPathItems.get(x));
                }
            }
        }
        return map;
    }

    public boolean comparePaths(List<String> controllerPathItems, List<String> requestedPathItems) {
        boolean match = false;
        if (controllerPathItems.size() == requestedPathItems.size()) {
            int index = 0;
            for (String pathItem : controllerPathItems) {
                if (pathItem.startsWith("{") && pathItem.endsWith("}")) {
                    match = true;
                    ++index;
                    continue;
                }
                if (!pathItem.equals(requestedPathItems.get(index))) {
                    match = false;
                    break;
                }
                match = true;
                ++index;
            }
        }
        return match;
    }
}

