/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.transport.core.util;

import com.vmware.transport.core.error.RestError;
import com.vmware.transport.core.model.RestOperation;
import com.vmware.transport.core.util.URIMethodResult;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.springframework.context.ApplicationContext;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;

@Component
public class RestControllerInvoker {
    private final ApplicationContext context;

    RestControllerInvoker(ApplicationContext context) {
        this.context = context;
    }

    public void invokeMethod(URIMethodResult methodResult, RestOperation operation) {
        Object[] formulatedMethodArgs = new Object[methodResult.getMethogArgList().size()];
        if (methodResult.getMethodArgs().size() >= 1) {
            Map<String, Object> pathItemMap = methodResult.getPathItemMap();
            Map<String, Class> methodArgs = methodResult.getMethodArgs();
            Map<String, Class> methodAnnotationTypes = methodResult.getMethodAnnotationTypes();
            if (pathItemMap.size() >= 1) {
                if (this.doPathItemsAndMethodArgsMatch(pathItemMap, methodArgs, methodAnnotationTypes)) {
                    this.processAndCallMethod(methodResult, operation, formulatedMethodArgs, pathItemMap);
                } else {
                    operation.getErrorHandler().accept(this.getRestError("Supplied method can't be used, the params and path items don't align.", 500));
                }
            } else {
                this.processAndCallMethod(methodResult, operation, formulatedMethodArgs, pathItemMap);
            }
        } else {
            this.callControllerMethod(methodResult, operation, null);
        }
    }

    private void processAndCallMethod(URIMethodResult methodResult, RestOperation operation, Object[] formulatedMethodArgs, Map<String, Object> pathItemMap) {
        RestError error = this.processMethod(methodResult, pathItemMap, formulatedMethodArgs, operation);
        if (error != null) {
            operation.getErrorHandler().accept(error);
            return;
        }
        this.callControllerMethod(methodResult, operation, formulatedMethodArgs);
    }

    private boolean doPathItemsAndMethodArgsMatch(Map<String, Object> pathItemMap, Map<String, Class> methodArgs, Map<String, Class> methodAnnotations) {
        boolean match = false;
        for (String pathItem : pathItemMap.keySet()) {
            String className = methodAnnotations.get(pathItem).getName();
            if (!className.contentEquals("org.springframework.web.bind.annotation.PathVariable")) continue;
            match = methodArgs.get(pathItem) != null;
        }
        return match;
    }

    private void callControllerMethod(URIMethodResult methodResult, RestOperation operation, Object[] formulatedMethodArgs) {
        Method method = methodResult.getMethod();
        Object bean = this.context.getBean(methodResult.getController().getClass());
        try {
            if (formulatedMethodArgs != null) {
                operation.getSuccessHandler().accept(method.invoke(bean, formulatedMethodArgs));
            } else {
                operation.getSuccessHandler().accept(method.invoke(bean, new Object[0]));
            }
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException().getClass().equals(AuthenticationCredentialsNotFoundException.class)) {
                operation.getErrorHandler().accept(this.getRestError(e.getTargetException().getMessage(), 500));
            } else {
                operation.getErrorHandler().accept(this.getRestError(e.getTargetException().getMessage(), 401));
            }
        }
        catch (IllegalAccessException e) {
            operation.getErrorHandler().accept(this.getRestError("Method cannot be called, method param mismatch", 500));
        }
        catch (IllegalArgumentException e) {
            operation.getErrorHandler().accept(this.getRestError("Method cannot be called, method param types don't match", 500));
        }
    }

    private RestError processMethod(URIMethodResult methodResult, Map<String, Object> pathItemMap, Object[] formulatedMethodArgs, RestOperation operation) {
        RestError error = null;
        int index = 0;
        for (String paramName : methodResult.getMethogArgList()) {
            if (methodResult.getMethodAnnotationTypes().get(paramName) != null) {
                if (methodResult.getMethodAnnotationTypes().get(paramName).equals(PathVariable.class)) {
                    formulatedMethodArgs[index] = pathItemMap.get(paramName);
                }
                if (methodResult.getMethodAnnotationTypes().get(paramName).equals(RequestBody.class)) {
                    formulatedMethodArgs[index] = operation.getBody();
                }
                if (methodResult.getMethodAnnotationTypes().get(paramName).equals(RequestHeader.class)) {
                    RequestHeader requestHeader = (RequestHeader)methodResult.getMethodAnnotationValues().get(paramName);
                    if (requestHeader != null && !requestHeader.value().isEmpty()) {
                        if (requestHeader.required()) {
                            if (!operation.getHeaders().containsKey(requestHeader.value())) {
                                error = this.getRestError("Method requires headers parameters, however no header with key '" + requestHeader.value() + "' was found", 500);
                            } else {
                                formulatedMethodArgs[index] = operation.getHeaders().get(requestHeader.value());
                            }
                        } else {
                            formulatedMethodArgs[index] = !operation.getHeaders().containsKey(paramName) ? null : operation.getHeaders().get(paramName);
                        }
                    } else if (!operation.getHeaders().containsKey(paramName)) {
                        error = this.getRestError("Method requires headers parameters, however no header with key '" + paramName + "' was found", 500);
                    } else {
                        formulatedMethodArgs[index] = operation.getHeaders().get(paramName);
                    }
                }
                if (methodResult.getMethodAnnotationTypes().get(paramName).equals(RequestParam.class)) {
                    RequestParam requestParam = (RequestParam)methodResult.getMethodAnnotationValues().get(paramName);
                    if (requestParam != null && !requestParam.value().isEmpty()) {
                        if (requestParam.required()) {
                            if (methodResult.getQueryString() == null) {
                                error = this.getRestError("Method requires request parameters, however none have been supplied.", 500);
                            } else if (methodResult.getQueryString().get(requestParam.value()) == null) {
                                error = this.getRestError("Method requires request param '" + requestParam.value() + "', This maps to method argument '" + paramName + "', but wasn't supplied with URI properties.", 500);
                            } else {
                                formulatedMethodArgs[index] = methodResult.getQueryString().get(requestParam.value());
                            }
                        } else {
                            formulatedMethodArgs[index] = this.checkForNullQueryString(methodResult) ? null : (methodResult.getQueryString().get(requestParam.value()) == null ? null : methodResult.getQueryString().get(requestParam.value()));
                        }
                    } else {
                        formulatedMethodArgs[index] = this.checkForNullQueryString(methodResult) ? null : (methodResult.getQueryString().get(paramName) == null ? null : methodResult.getQueryString().get(paramName));
                    }
                }
                ++index;
                continue;
            }
            formulatedMethodArgs[index] = operation.getBody();
            ++index;
        }
        return error;
    }

    private boolean checkForNullQueryString(URIMethodResult methodResult) {
        return methodResult.getQueryString() == null;
    }

    private RestError getRestError(String message, Integer status) {
        RestError error = new RestError(message, status);
        return error;
    }
}

