/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.transport.core.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Loggable {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected boolean useJazz = false;

    public String getName() {
        return this.getClass().getName();
    }

    public void enableLoggingJazz() {
        this.useJazz = true;
    }

    public void disableLoggingJazz() {
        this.useJazz = false;
    }

    public void logInfoMessage(String emoji, String message, String value) {
        if (this.useJazz) {
            this.log.info("{}  {}: \u001b[1m\u001b[35;1m{}\u001b[0m", new Object[]{emoji, message.trim(), value.trim()});
        } else {
            this.log.info("{}  {}: ", (Object)message.trim(), (Object)value.trim());
        }
    }

    public void logErrorMessage(String message, String value) {
        if (this.useJazz) {
            this.log.error("\ud83d\uded1  \u001b[41;1m{}:\u001b[0m \u001b[31;1m{}\u001b[0m", (Object)message.trim(), (Object)value.trim());
        } else {
            this.log.error("{}: {}", (Object)message.trim(), (Object)value.trim());
        }
    }

    public void logDebugMessage(String message, String value) {
        if (this.useJazz) {
            this.log.debug("\ud83d\udd39  \u001b[38;5;245m{}: \u001b[35m{}\u001b[0m", (Object)message.trim(), (Object)value.trim());
        } else {
            this.log.debug("{}: {}", (Object)message.trim(), (Object)value.trim());
        }
    }

    public void logDebugMessage(String message) {
        if (this.useJazz) {
            this.log.debug("\ud83d\udd39  \u001b[38;5;245m{}\u001b[0m", (Object)message.trim());
        } else {
            this.log.debug("{}", (Object)message.trim());
        }
    }

    public void logTraceMessage(String message, String value) {
        if (this.useJazz) {
            this.log.trace("\ud83d\udd38  \u001b[38;5;245m{}: \u001b[38;5;67m{}\u001b[0m", (Object)message.trim(), (Object)value.trim());
        } else {
            this.log.trace("{}: {}", (Object)message.trim(), (Object)value.trim());
        }
    }

    public void logWarnMessage(String message) {
        if (this.useJazz) {
            this.log.warn("\u26a0\ufe0f  \u001b[33m\u001b[1m{}\u001b[0m", (Object)message.trim());
        } else {
            this.log.warn("{}", (Object)message.trim());
        }
    }

    public void logBannerMessage(String emoji, String message) {
        if (this.useJazz) {
            this.log.info("{}  \u001b[1m\u001b[38;5;200m{}\u001b[0m", (Object)emoji, (Object)message.trim());
        } else {
            this.log.info("{} {}", (Object)emoji, (Object)message.trim());
        }
    }
}

