/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.transport.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.vmware.transport.bridge.Request;
import com.vmware.transport.bridge.Response;
import com.vmware.transport.bridge.spring.TransportEnabled;
import com.vmware.transport.bridge.spring.TransportService;
import com.vmware.transport.bus.EventBus;
import com.vmware.transport.bus.model.Message;
import com.vmware.transport.bus.store.BusStoreApi;
import com.vmware.transport.bus.store.model.BusStore;
import com.vmware.transport.core.error.GeneralError;
import com.vmware.transport.core.error.RestError;
import com.vmware.transport.core.model.RestOperation;
import com.vmware.transport.core.model.RestServiceRequest;
import com.vmware.transport.core.util.Loggable;
import java.net.URI;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.ResourceLoader;
import org.springframework.http.HttpMethod;

@TransportService
public abstract class AbstractBase
extends Loggable
implements TransportEnabled {
    @Autowired
    protected EventBus bus;
    @Autowired
    protected BusStoreApi storeManager;
    @Autowired
    protected ApplicationContext context;
    @Autowired
    protected ResourceLoader resourceLoader;
    protected ObjectMapper mapper = new ObjectMapper();

    protected <Req, Resp> void restServiceRequest(UUID id, URI uri, HttpMethod method, Req payload, Map<String, String> headers, String responseApiClass, Consumer<Response<Resp>> successHandler, Consumer<Response<RestError>> errorHandler) {
        BusStore serviceWideHeadersStore = this.storeManager.createStore("service-wide-headers-store");
        if (serviceWideHeadersStore.get(this.getName()) == null) {
            serviceWideHeadersStore.put(this.getName(), new HashMap(), "service-headers-updated");
        }
        Map serviceHeadersMap = (Map)serviceWideHeadersStore.get(this.getName());
        HashMap<String, String> mergedHeaders = new HashMap<String, String>();
        if (headers != null) {
            for (String key : headers.keySet()) {
                mergedHeaders.merge(key, headers.get(key), (v, v2) -> v2);
            }
        }
        for (String key : serviceHeadersMap.keySet()) {
            mergedHeaders.merge(key, (String)serviceHeadersMap.get(key), (v, v2) -> v2);
        }
        RestServiceRequest req = new RestServiceRequest();
        req.setApiClass(responseApiClass);
        req.setMethod(method);
        req.setUri(uri);
        req.setBody(payload);
        req.setSentFrom(this.getName());
        req.setHeaders(mergedHeaders);
        Request request = new Request();
        request.setId(id);
        request.setHeaders(mergedHeaders);
        request.setPayload(req);
        request.setRequest(method.toString());
        request.setChannel("fabric-rest");
        request.setCreated(Calendar.getInstance().getTime());
        this.callService(id, "fabric-rest", request, successHandler, errorHandler);
    }

    @Deprecated
    protected <Req, Resp> void restServiceRequest(URI uri, HttpMethod method, Req payload, Map<String, String> headers, String responseApiClass, Consumer<Response<Resp>> successHandler, Consumer<Response<RestError>> errorHandler) throws Exception {
        this.restServiceRequest(UUID.randomUUID(), uri, method, payload, headers, responseApiClass, successHandler, errorHandler);
    }

    protected void restServiceRequest(RestOperation operation) {
        this.restServiceRequest(operation.getId(), operation.getUri(), operation.getMethod(), operation.getBody(), operation.getHeaders(), operation.getApiClass(), response -> operation.getSuccessHandler().accept(response.getPayload()), restErrorResponse -> operation.getErrorHandler().accept((RestError)restErrorResponse.getPayload()));
    }

    protected <Req, Resp, Err> void callService(UUID uuid, String channelName, Req request, Consumer<Resp> successHandler, Consumer<Err> errorHandler) {
        this.bus.requestOnceWithId(uuid, channelName, request, (io.reactivex.functions.Consumer<Message>)((io.reactivex.functions.Consumer)message -> successHandler.accept(message.getPayload())), (io.reactivex.functions.Consumer<Message>)((io.reactivex.functions.Consumer)message -> errorHandler.accept(message.getPayload())));
    }

    protected <Req, Resp> void callService(String channelName, Req request, Consumer<Resp> successHandler, Consumer<GeneralError> errorHandler) {
        this.callService(UUID.randomUUID(), channelName, request, successHandler, errorHandler);
    }

    public void setHeaders(Map<String, String> headersMap) {
        BusStore<String, Map<String, String>> busStore = this.storeManager.getStore("service-wide-headers-store");
        busStore.put(this.getName(), headersMap, "service-headers-updated");
    }

    protected void setGlobalRestServiceHostOptions(String host, String port) {
        BusStore<String, String> baseHostStore = this.bus.getStoreManager().getStore("rest-service-hostconfig");
        if (host != null) {
            baseHostStore.put("host", host, null);
        }
        if (port != null) {
            baseHostStore.put("port", port, null);
        }
    }
}

