/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.transport.bus.store;

import com.vmware.transport.bridge.Request;
import com.vmware.transport.bus.BusTransaction;
import com.vmware.transport.bus.model.Message;
import com.vmware.transport.bus.model.MonitorObject;
import com.vmware.transport.bus.model.MonitorType;
import com.vmware.transport.bus.store.BusStoreApi;
import com.vmware.transport.bus.store.model.BusStore;
import com.vmware.transport.bus.store.model.BusStoreError;
import com.vmware.transport.bus.store.model.CloseStoreRequest;
import com.vmware.transport.bus.store.model.OpenStoreRequest;
import com.vmware.transport.bus.store.model.StoreContentResponse;
import com.vmware.transport.bus.store.model.StoreStream;
import com.vmware.transport.bus.store.model.UpdateStoreRequest;
import com.vmware.transport.bus.store.model.UpdateStoreResponse;
import com.vmware.transport.core.AbstractBase;
import io.reactivex.functions.Consumer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GalacticStoreService
extends AbstractBase {
    public static final String GALACTIC_STORE_SYNC_UPDATE = "galacticStoreSyncUpdate";
    public static final String GALACTIC_STORE_SYNC_REMOVE = "galacticStoreSyncRemove";
    private BusStoreApi storeManager;
    private static final String STORE_SYNC_CHANNEL_PREFIX = "fabric-store-sync.";
    private final Map<String, GalacticStoreListener> openedStoresMap = new HashMap<String, GalacticStoreListener>();
    private final Map<String, Set<String>> clientChannelsToOpenStoresMap = new HashMap<String, Set<String>>();
    private final Map<String, BusTransaction> syncChannelsToRequestListeners = new HashMap<String, BusTransaction>();

    @Autowired
    public GalacticStoreService(BusStoreApi storeManager) {
        this.storeManager = storeManager;
    }

    @Override
    public void initialize() {
        this.bus.getApi().getMonitor().subscribe(message -> {
            MonitorObject mo = (MonitorObject)message.getPayload();
            if (mo == null || mo.getChannel() == null || !mo.getChannel().startsWith(STORE_SYNC_CHANNEL_PREFIX)) {
                return;
            }
            String channelName = mo.getChannel();
            if (mo.getType() == MonitorType.MonitorNewBridgeSubscription) {
                this.openNewStoreSyncChannel(channelName);
            } else if (mo.getType() == MonitorType.MonitorCloseChannel) {
                this.closeStoreSyncChannel(channelName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openNewStoreSyncChannel(String channelName) {
        Map<String, Set<String>> map = this.clientChannelsToOpenStoresMap;
        synchronized (map) {
            if (this.clientChannelsToOpenStoresMap.containsKey(channelName)) {
                return;
            }
            this.clientChannelsToOpenStoresMap.put(channelName, new HashSet());
            this.syncChannelsToRequestListeners.put(channelName, this.bus.listenRequestStream(channelName, (Consumer<Message>)((Consumer)message -> {
                try {
                    Request request = (Request)message.getPayload();
                    switch (request.getRequest()) {
                        case "openStore": {
                            this.onOpenStoreRequest(channelName, request);
                            break;
                        }
                        case "closeStore": {
                            this.onCloseStoreRequest(channelName, request);
                            break;
                        }
                        case "updateStore": {
                            this.onUpdateStoreRequest(channelName, request);
                        }
                    }
                }
                catch (Exception ex) {
                    this.logErrorMessage("Failed to process request", ex.getMessage() != null ? ex.getMessage() : ex.toString());
                }
            })));
        }
    }

    private void onUpdateStoreRequest(String syncChannelName, Request request) {
        Object itemValue;
        Object itemId;
        UpdateStoreRequest updateStoreRequest;
        try {
            updateStoreRequest = (UpdateStoreRequest)this.mapper.convertValue(request.getPayload(), UpdateStoreRequest.class);
        }
        catch (Exception ex) {
            this.logErrorMessage("Invalid UpdateStoreRequest", ex.getMessage());
            this.bus.sendErrorMessageWithId(syncChannelName, new BusStoreError("Invalid UpdateStoreRequest: " + ex.getMessage()), request.getId());
            return;
        }
        if (updateStoreRequest == null) {
            this.logErrorMessage("Invalid UpdateStoreRequest", "null request");
            this.bus.sendErrorMessageWithId(syncChannelName, new BusStoreError("Invalid UpdateStoreRequest: null request"), request.getId());
            return;
        }
        if (updateStoreRequest.storeId == null) {
            this.logErrorMessage("Invalid UpdateStoreRequest", "null storeId");
            this.bus.sendErrorMessageWithId(syncChannelName, new BusStoreError("Invalid UpdateStoreRequest: null storeId"), request.getId());
            return;
        }
        BusStore<Object, Object> store = this.storeManager.getStore(updateStoreRequest.storeId);
        if (store == null) {
            this.logErrorMessage("Invalid updateStore request: requested store doesn't exist", updateStoreRequest.storeId);
            this.bus.sendErrorMessageWithId(syncChannelName, new BusStoreError("Cannot update non-existing store: " + updateStoreRequest.storeId, updateStoreRequest.storeId), request.getId());
            return;
        }
        try {
            itemId = store.getKeyType() != null ? this.mapper.convertValue(updateStoreRequest.itemId, store.getKeyType()) : updateStoreRequest.itemId;
            itemValue = updateStoreRequest.newItemValue != null && store.getValueType() != null ? this.mapper.convertValue(updateStoreRequest.newItemValue, store.getValueType()) : updateStoreRequest.newItemValue;
        }
        catch (Exception ex) {
            this.logErrorMessage("Invalid UpdateStoreRequest.", ex.getMessage());
            this.bus.sendErrorMessageWithId(syncChannelName, new BusStoreError("Invalid UpdateStoreRequest: " + ex.getMessage(), updateStoreRequest.storeId, updateStoreRequest.itemId), request.getId());
            return;
        }
        if (itemValue != null) {
            store.put(itemId, itemValue, GALACTIC_STORE_SYNC_UPDATE);
        } else {
            store.remove(itemId, GALACTIC_STORE_SYNC_REMOVE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onOpenStoreRequest(String syncChannelName, Request request) {
        BusStore store;
        OpenStoreRequest openStoreRequest;
        try {
            openStoreRequest = (OpenStoreRequest)this.mapper.convertValue(request.getPayload(), OpenStoreRequest.class);
        }
        catch (Exception ex) {
            this.logErrorMessage("Invalid OpenStoreRequest.", ex.getMessage());
            this.bus.sendErrorMessageWithId(syncChannelName, new BusStoreError("Invalid OpenStoreRequest: " + ex.getMessage()), request.getId());
            return;
        }
        if (openStoreRequest == null) {
            this.logErrorMessage("Invalid OpenStoreRequest", "null request");
            this.bus.sendErrorMessageWithId(syncChannelName, new BusStoreError("Invalid OpenStoreRequest: null request"), request.getId());
            return;
        }
        if (openStoreRequest.storeId == null) {
            this.logErrorMessage("Invalid OpenStoreRequest", "null storeId");
            this.bus.sendErrorMessageWithId(syncChannelName, new BusStoreError("Invalid OpenStoreRequest: null storeId"), request.getId());
            return;
        }
        Map<String, Set<String>> map2 = this.clientChannelsToOpenStoresMap;
        synchronized (map2) {
            store = this.storeManager.getStore(openStoreRequest.storeId);
            if (store == null) {
                this.logErrorMessage("Invalid openStore request: requested store doesn't exist", openStoreRequest.storeId);
                this.bus.sendErrorMessageWithId(syncChannelName, new BusStoreError("Cannot open non-existing store: " + openStoreRequest.storeId, openStoreRequest.storeId), request.getId());
                return;
            }
            if (this.clientChannelsToOpenStoresMap.containsKey(syncChannelName)) {
                this.clientChannelsToOpenStoresMap.get(syncChannelName).add(openStoreRequest.storeId);
            }
            if (!this.openedStoresMap.containsKey(openStoreRequest.storeId)) {
                this.openedStoresMap.put(openStoreRequest.storeId, new GalacticStoreListener(store));
            }
            this.openedStoresMap.get(openStoreRequest.storeId).addClientChannel(syncChannelName);
        }
        store.whenReady(map -> this.bus.sendResponseMessageWithId(syncChannelName, new StoreContentResponse(openStoreRequest.storeId, store.getStoreContent()), request.getId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCloseStoreRequest(String syncChannelName, Request request) {
        CloseStoreRequest closeStoreRequest;
        try {
            closeStoreRequest = (CloseStoreRequest)this.mapper.convertValue(request.getPayload(), CloseStoreRequest.class);
        }
        catch (Exception ex) {
            this.logErrorMessage("Invalid CloseStoreRequest.", ex.getMessage());
            this.bus.sendErrorMessageWithId(syncChannelName, new BusStoreError("Invalid CloseStoreRequest: " + ex.getMessage()), request.getId());
            return;
        }
        if (closeStoreRequest == null) {
            this.logErrorMessage("Invalid CloseStoreRequest", "null request");
            this.bus.sendErrorMessageWithId(syncChannelName, new BusStoreError("Invalid CloseStoreRequest: null request"), request.getId());
            return;
        }
        if (closeStoreRequest.storeId == null) {
            this.logErrorMessage("Invalid CloseStoreRequest", "null storeId");
            this.bus.sendErrorMessageWithId(syncChannelName, new BusStoreError("Invalid CloseStoreRequest: null storeId"), request.getId());
            return;
        }
        Map<String, Set<String>> map = this.clientChannelsToOpenStoresMap;
        synchronized (map) {
            GalacticStoreListener listener;
            if (this.clientChannelsToOpenStoresMap.containsKey(syncChannelName)) {
                this.clientChannelsToOpenStoresMap.get(syncChannelName).remove(closeStoreRequest.storeId);
            }
            if ((listener = this.openedStoresMap.get(closeStoreRequest.storeId)) != null && !listener.isEmpty()) {
                listener.removeClientChannel(syncChannelName);
                if (listener.isEmpty()) {
                    listener.unsubscribe();
                    this.openedStoresMap.remove(closeStoreRequest.storeId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeStoreSyncChannel(String channelName) {
        BusTransaction requestListener;
        Map<String, Set<String>> map = this.clientChannelsToOpenStoresMap;
        synchronized (map) {
            if (!this.clientChannelsToOpenStoresMap.containsKey(channelName)) {
                return;
            }
            for (String store : this.clientChannelsToOpenStoresMap.get(channelName)) {
                GalacticStoreListener listener = this.openedStoresMap.get(store);
                if (listener == null) continue;
                listener.removeClientChannel(channelName);
                if (!listener.isEmpty()) continue;
                listener.unsubscribe();
                this.openedStoresMap.remove(store);
            }
            this.clientChannelsToOpenStoresMap.remove(channelName);
            this.bus.closeChannel(channelName, this.getName());
            requestListener = this.syncChannelsToRequestListeners.remove(channelName);
        }
        if (requestListener != null) {
            requestListener.unsubscribe();
        }
    }

    static class GalacticStoreCommands {
        static final String OpenStore = "openStore";
        static final String UpdateStore = "updateStore";
        static final String CloseStore = "closeStore";

        private GalacticStoreCommands() {
        }
    }

    private class GalacticStoreListener {
        private final Set<String> clientChannels = new HashSet<String>();
        private final StoreStream<?> storeStream;
        private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();

        GalacticStoreListener(BusStore store) {
            this.storeStream = store.onAllChanges(new Object[0]);
            this.storeStream.subscribe((item, stateChange) -> {
                UpdateStoreResponse updateStoreMsg = new UpdateStoreResponse(store.getStoreType(), stateChange.getStoreVersion(), stateChange.getObjectId(), stateChange.isDeleteChange() ? null : stateChange.getValue());
                try {
                    this.readWriteLock.readLock().lock();
                    for (String channel : this.clientChannels) {
                        try {
                            GalacticStoreService.this.bus.sendResponseMessage(channel, updateStoreMsg);
                        }
                        catch (Exception ex) {
                            GalacticStoreService.this.logErrorMessage("Failed to send store update", ex.getMessage());
                        }
                    }
                }
                finally {
                    this.readWriteLock.readLock().unlock();
                }
            });
        }

        void addClientChannel(String clientChannel) {
            this.readWriteLock.writeLock().lock();
            try {
                this.clientChannels.add(clientChannel);
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
        }

        void removeClientChannel(String clientChannel) {
            this.readWriteLock.writeLock().lock();
            try {
                this.clientChannels.remove(clientChannel);
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
        }

        public boolean isEmpty() {
            try {
                this.readWriteLock.readLock().lock();
                boolean bl = this.clientChannels.isEmpty();
                return bl;
            }
            finally {
                this.readWriteLock.readLock().unlock();
            }
        }

        public void unsubscribe() {
            this.storeStream.unsubscribe();
        }
    }
}

