/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.transport.bus.model;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vmware.transport.bus.model.Message;
import com.vmware.transport.bus.model.MessageHeaders;
import com.vmware.transport.bus.model.MessageType;
import java.util.UUID;
import lombok.Generated;

public class MessageObject<T>
implements Message<T> {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private String targetUser;
    protected MessageType type;
    protected Class<T> payloadClass;
    protected T payload;
    protected UUID id;
    protected MessageHeaders headers;

    public MessageObject() {
    }

    public MessageObject(MessageType type, T payload) {
        this.type = type;
        this.payload = payload;
        if (payload != null) {
            this.payloadClass = payload.getClass();
        }
    }

    @Override
    public boolean isRequest() {
        return this.type == MessageType.MessageTypeRequest;
    }

    @Override
    public boolean isResponse() {
        return this.type == MessageType.MessageTypeResponse;
    }

    @Override
    public boolean isError() {
        return this.type == MessageType.MessageTypeError;
    }

    @Override
    public Object getHeader(String headerName) {
        if (this.headers != null) {
            return this.headers.getHeader(headerName);
        }
        return null;
    }

    @Override
    public String getPayloadAsString() throws JsonProcessingException {
        if (this.payload instanceof String) {
            return (String)this.payload;
        }
        return objectMapper.writeValueAsString(this.payload);
    }

    public String toString() {
        return this.payload.toString();
    }

    @Override
    @Generated
    public void setTargetUser(String targetUser) {
        this.targetUser = targetUser;
    }

    @Override
    @Generated
    public String getTargetUser() {
        return this.targetUser;
    }

    @Generated
    public void setType(MessageType type) {
        this.type = type;
    }

    @Generated
    public MessageType getType() {
        return this.type;
    }

    @Override
    @Generated
    public void setPayloadClass(Class<T> payloadClass) {
        this.payloadClass = payloadClass;
    }

    @Override
    @Generated
    public Class<T> getPayloadClass() {
        return this.payloadClass;
    }

    @Override
    @Generated
    public void setPayload(T payload) {
        this.payload = payload;
    }

    @Override
    @Generated
    public T getPayload() {
        return this.payload;
    }

    @Override
    @Generated
    public UUID getId() {
        return this.id;
    }

    @Override
    @Generated
    public void setId(UUID id) {
        this.id = id;
    }

    @Override
    @Generated
    public MessageHeaders getHeaders() {
        return this.headers;
    }

    @Override
    @Generated
    public void setHeaders(MessageHeaders headers) {
        this.headers = headers;
    }
}

