/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.transport.bridge.spring.controllers;

import com.vmware.transport.bridge.Request;
import com.vmware.transport.bridge.RequestException;
import com.vmware.transport.bridge.Response;
import com.vmware.transport.bus.EventBus;
import com.vmware.transport.bus.model.MessageHeaders;
import com.vmware.transport.core.util.ClassMapper;
import com.vmware.transport.core.util.Loggable;
import io.reactivex.exceptions.OnErrorNotImplementedException;
import java.security.Principal;
import java.util.Map;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.handler.annotation.DestinationVariable;
import org.springframework.messaging.handler.annotation.Headers;
import org.springframework.messaging.handler.annotation.MessageExceptionHandler;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;

@Controller
public class MessageController
extends Loggable {
    private EventBus bus;

    @Autowired
    MessageController(EventBus eventBus) {
        this.bus = eventBus;
    }

    @MessageMapping(value={"/{topicDestination}"})
    public void bridgeMessage(Request request, @DestinationVariable String topicDestination, @Headers Map<String, Object> headers) throws RequestException {
        this.validateRequest(request);
        this.logTraceMessage("New inbound message received for channel: ", topicDestination);
        if (headers != null) {
            request.setSessionAttributes((Map)headers.get("simpSessionAttributes"));
        }
        MessageHeaders messageHeaders = ClassMapper.CastMessageHeaders(request.getHeaders());
        if (this.bus.isGalacticChannel(topicDestination)) {
            this.bus.sendRequestMessage(topicDestination, request.getPayload(), messageHeaders);
        } else {
            this.bus.sendRequestMessage(topicDestination, request, messageHeaders);
        }
    }

    @MessageMapping(value={"/queue/{queueDestination}"})
    public void bridgeQueueMessage(Request request, @DestinationVariable String queueDestination, Principal principal, @Headers Map<String, Object> headers) throws RequestException {
        this.validateRequest(request);
        request.setTargetUser(principal.getName());
        if (headers != null) {
            request.setSessionAttributes((Map)headers.get("simpSessionAttributes"));
        }
        MessageHeaders messageHeaders = ClassMapper.CastMessageHeaders(request.getHeaders());
        this.logTraceMessage("New inbound message received for private channel: ", queueDestination);
        this.bus.sendRequestMessageToTarget(queueDestination, request, request.getId(), principal.getName(), messageHeaders);
    }

    @MessageExceptionHandler
    public Response handleException(Throwable exception) {
        this.logErrorMessage("New inbound message received cannot be processed", exception.getMessage());
        Response resp = new Response(UUID.randomUUID(), true);
        resp.setErrorCode(400);
        resp.setErrorMessage("Request cannot be processed: " + exception.getMessage());
        return resp;
    }

    @ExceptionHandler(value={RequestException.class, OnErrorNotImplementedException.class})
    public Response handleRequestException(Throwable exception) {
        return this.handleException(exception);
    }

    private void validateRequest(Request request) throws RequestException {
        if (request.getId() == null) {
            throw new RequestException("Request 'id' is missing");
        }
        if (request.getRequest() == null) {
            throw new RequestException("Request 'request' is missing");
        }
        if (request.getVersion() == null) {
            throw new RequestException("Request 'version' is missing");
        }
    }
}

