/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.transport.bridge.spring.config.interceptors;

import com.vmware.transport.bridge.spring.config.StompInterceptorRegistration;
import com.vmware.transport.bridge.spring.config.TransportBridgeConfiguration;
import java.util.List;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.simp.stomp.StompCommand;
import org.springframework.messaging.simp.stomp.StompHeaderAccessor;
import org.springframework.messaging.support.ChannelInterceptorAdapter;

public class TransportChannelInterceptor
extends ChannelInterceptorAdapter {
    private TransportBridgeConfiguration configuration;

    public TransportChannelInterceptor(TransportBridgeConfiguration configuration) {
        this.configuration = configuration;
    }

    public Message<?> preSend(Message<?> message, MessageChannel channel) {
        List<StompInterceptorRegistration> interceptors = this.configuration.getRegisteredTransportStompInterceptors();
        if (interceptors.isEmpty()) {
            return message;
        }
        StompHeaderAccessor header = StompHeaderAccessor.wrap(message);
        String destination = header.getDestination();
        if (destination == null || destination.isEmpty()) {
            return message;
        }
        StompCommand stompCommand = header.getCommand();
        for (StompInterceptorRegistration interceptorRegistration : interceptors) {
            if (interceptorRegistration.commandSet.contains(stompCommand) && interceptorRegistration.destinationMatcher.match(destination)) {
                message = interceptorRegistration.interceptor.preSend(message);
            }
            if (message != null) continue;
            break;
        }
        return message;
    }
}

